/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.query;

import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.Extractable;
import com.hazelcast.query.impl.IndexUtils;
import java.util.Map;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;

public class GeoPredicate<K, V>
implements Predicate<K, V> {
    private static final double KM_TO_MILES = 0.621371;
    private static final double KM_TO_NEUTRAL = 0.539957;
    private static final double R = 6372.8;
    final String attributeName;
    final Point queryPoint;
    final Distance distance;

    public GeoPredicate(String attribute, Point point, Distance distance) {
        this.attributeName = IndexUtils.canonicalizeAttribute((String)attribute);
        this.queryPoint = point;
        this.distance = distance;
    }

    public boolean apply(Map.Entry<K, V> mapEntry) {
        Object attributeValue = this.readAttributeValue(mapEntry);
        if (attributeValue instanceof Point) {
            return this.compareDistance((Point)attributeValue);
        }
        throw new IllegalArgumentException(String.format("Cannot use %s predicate with attribute other than Point", this.getClass().getSimpleName()));
    }

    private boolean compareDistance(Point point) {
        double calculatedDistance = this.calculateDistance(point.getX(), point.getY(), this.queryPoint.getX(), this.queryPoint.getY(), this.distance.getMetric());
        return calculatedDistance < this.distance.getValue();
    }

    private double calculateDistance(double lat1, double lng1, double lat2, double lng2, Metric metric) {
        if (lat1 == lat2 && lng1 == lng2) {
            return 0.0;
        }
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lng2 - lng1);
        double lat1Radians = Math.toRadians(lat1);
        double lat2Radians = Math.toRadians(lat2);
        double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.pow(Math.sin(dLon / 2.0), 2.0) * Math.cos(lat1Radians) * Math.cos(lat2Radians);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        double dist = 6372.8 * c;
        if (Metrics.MILES.equals((Object)metric)) {
            dist *= 0.621371;
        } else if (Metrics.NEUTRAL.equals((Object)metric)) {
            dist *= 0.539957;
        }
        return dist;
    }

    private Object readAttributeValue(Map.Entry<K, V> entry) {
        Extractable extractable = (Extractable)entry;
        return extractable.getAttributeValue(this.attributeName);
    }
}

