/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.query;

import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;

public class HazelcastCriteriaAccessor
implements CriteriaAccessor<Predicate<?, ?>> {
    public Predicate<?, ?> resolve(KeyValueQuery<?> query) {
        if (query == null) {
            return null;
        }
        Object criteria = query.getCriteria();
        if (criteria == null) {
            return null;
        }
        if (criteria instanceof PagingPredicateImpl) {
            PagingPredicateImpl pagingPredicate = (PagingPredicateImpl)criteria;
            query.limit(pagingPredicate.getPageSize());
            return pagingPredicate.getPredicate();
        }
        if (criteria instanceof Predicate) {
            return (Predicate)criteria;
        }
        throw new UnsupportedOperationException(query.toString());
    }
}

