/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.query;

import com.hazelcast.query.impl.getters.ReflectionHelper;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Comparator;
import java.util.Map;

public class HazelcastPropertyComparator
implements Comparator<Map.Entry<?, ?>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final MethodHandle EXTRACT_VALUE_HAZELCAST_41 = HazelcastPropertyComparator.resolveExtractValueHazelcast41();
    private static final MethodHandle EXTRACT_VALUE_HAZELCAST_403 = HazelcastPropertyComparator.resolveExtractValueHazelcast403();
    private final String attributeName;
    private final int direction;

    private static MethodHandle resolveExtractValueHazelcast41() {
        try {
            return MethodHandles.lookup().findStatic(ReflectionHelper.class, "extractValue", MethodType.methodType(Object.class, Object.class, String.class, Boolean.TYPE));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private static MethodHandle resolveExtractValueHazelcast403() {
        try {
            return MethodHandles.lookup().findStatic(ReflectionHelper.class, "extractValue", MethodType.methodType(Object.class, Object.class, String.class));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public HazelcastPropertyComparator(String attributeName, boolean ascending) {
        this.attributeName = attributeName;
        this.direction = ascending ? 1 : -1;
    }

    @Override
    public int compare(Map.Entry<?, ?> o1, Map.Entry<?, ?> o2) {
        try {
            Object o2Field;
            Object o1Field;
            if (EXTRACT_VALUE_HAZELCAST_41 == null && EXTRACT_VALUE_HAZELCAST_403 == null) {
                throw new IllegalStateException("Could not resolve a ReflectionHelper.extractValue method. Using a non-supported Hazelcast version");
            }
            try {
                if (EXTRACT_VALUE_HAZELCAST_403 != null) {
                    o1Field = EXTRACT_VALUE_HAZELCAST_403.invoke(o1.getValue(), this.attributeName);
                    o2Field = EXTRACT_VALUE_HAZELCAST_403.invoke(o2.getValue(), this.attributeName);
                } else {
                    o1Field = EXTRACT_VALUE_HAZELCAST_41.invoke(o1.getValue(), this.attributeName, true);
                    o2Field = EXTRACT_VALUE_HAZELCAST_41.invoke(o2.getValue(), this.attributeName, true);
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Could not resolve a ReflectionHelper.extractValue method. Using a non-supported Hazelcast version", throwable);
            }
            if (o1Field == o2Field) {
                return 0;
            }
            if (o1Field == null) {
                return this.direction;
            }
            if (o2Field == null) {
                return -1 * this.direction;
            }
            if (o1Field instanceof Comparable && o2Field instanceof Comparable) {
                return this.direction * ((Comparable)o1Field).compareTo(o2Field);
            }
        }
        catch (Exception ex) {
            return 0;
        }
        return 0;
    }
}

