/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.hazelcast.repository.query.Query;
import org.springframework.data.keyvalue.annotation.KeySpace;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.StringUtils;

public class HazelcastQueryMethod
extends QueryMethod {
    private final Method method;

    public HazelcastQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
    }

    public boolean hasAnnotatedQuery() {
        return StringUtils.hasText((String)this.getAnnotatedQuery());
    }

    String getAnnotatedQuery() {
        Query query = this.method.getAnnotation(Query.class);
        String queryString = query != null ? (String)AnnotationUtils.getValue((Annotation)query) : null;
        return StringUtils.hasText((String)queryString) ? queryString : null;
    }

    String getKeySpace() {
        Class clazz = this.getEntityInformation().getJavaType();
        KeySpace keySpace = clazz.getAnnotation(KeySpace.class);
        String queryString = keySpace != null ? (String)AnnotationUtils.getValue((Annotation)keySpace) : null;
        return StringUtils.hasText((String)queryString) ? queryString : clazz.getName();
    }
}

