/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.support;

import com.hazelcast.core.HazelcastInstance;
import java.util.Optional;
import org.springframework.data.hazelcast.repository.support.HazelcastEntityInformation;
import org.springframework.data.hazelcast.repository.support.HazelcastQueryLookupStrategy;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.query.SpelQueryCreator;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactory;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.util.Assert;

public class HazelcastRepositoryFactory
extends KeyValueRepositoryFactory {
    private static final Class<SpelQueryCreator> DEFAULT_QUERY_CREATOR = SpelQueryCreator.class;
    private final KeyValueOperations keyValueOperations;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private final HazelcastInstance hazelcastInstance;

    public HazelcastRepositoryFactory(KeyValueOperations keyValueOperations, HazelcastInstance hazelcastInstance) {
        this(keyValueOperations, DEFAULT_QUERY_CREATOR, hazelcastInstance);
    }

    public HazelcastRepositoryFactory(KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, HazelcastInstance hazelcastInstance) {
        super(keyValueOperations, queryCreator);
        this.keyValueOperations = keyValueOperations;
        this.queryCreator = queryCreator;
        this.hazelcastInstance = hazelcastInstance;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new HazelcastQueryLookupStrategy(key, evaluationContextProvider, this.keyValueOperations, this.queryCreator, this.hazelcastInstance));
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        PersistentEntity entity = this.keyValueOperations.getMappingContext().getPersistentEntity(domainClass);
        Assert.notNull((Object)entity, (String)"Entity must not be 'null'.");
        return new HazelcastEntityInformation(entity);
    }
}

