/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.colorspace.shading;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.colorspace.shading.PdfAxialShading;
import com.itextpdf.kernel.pdf.colorspace.shading.PdfCoonsPatchShading;
import com.itextpdf.kernel.pdf.colorspace.shading.PdfFreeFormGouraudShadedTriangleShading;
import com.itextpdf.kernel.pdf.colorspace.shading.PdfFunctionBasedShading;
import com.itextpdf.kernel.pdf.colorspace.shading.PdfLatticeFormGouraudShadedTriangleShading;
import com.itextpdf.kernel.pdf.colorspace.shading.PdfRadialShading;
import com.itextpdf.kernel.pdf.colorspace.shading.PdfTensorProductPatchShading;
import com.itextpdf.kernel.pdf.function.IPdfFunction;

public abstract class AbstractPdfShading
extends PdfObjectWrapper<PdfDictionary> {
    public static AbstractPdfShading makeShading(PdfDictionary shadingDictionary) {
        AbstractPdfShading shading;
        if (!shadingDictionary.containsKey(PdfName.ShadingType)) {
            throw new PdfException("Shading type not found.");
        }
        if (!shadingDictionary.containsKey(PdfName.ColorSpace)) {
            throw new PdfException("ColorSpace not found.");
        }
        switch (shadingDictionary.getAsNumber(PdfName.ShadingType).intValue()) {
            case 1: {
                shading = new PdfFunctionBasedShading(shadingDictionary);
                break;
            }
            case 2: {
                shading = new PdfAxialShading(shadingDictionary);
                break;
            }
            case 3: {
                shading = new PdfRadialShading(shadingDictionary);
                break;
            }
            case 4: {
                if (!shadingDictionary.isStream()) {
                    throw new PdfException("Unexpected shading type.");
                }
                shading = new PdfFreeFormGouraudShadedTriangleShading((PdfStream)shadingDictionary);
                break;
            }
            case 5: {
                if (!shadingDictionary.isStream()) {
                    throw new PdfException("Unexpected shading type.");
                }
                shading = new PdfLatticeFormGouraudShadedTriangleShading((PdfStream)shadingDictionary);
                break;
            }
            case 6: {
                if (!shadingDictionary.isStream()) {
                    throw new PdfException("Unexpected shading type.");
                }
                shading = new PdfCoonsPatchShading((PdfStream)shadingDictionary);
                break;
            }
            case 7: {
                if (!shadingDictionary.isStream()) {
                    throw new PdfException("Unexpected shading type.");
                }
                shading = new PdfTensorProductPatchShading((PdfStream)shadingDictionary);
                break;
            }
            default: {
                throw new PdfException("Unexpected shading type.");
            }
        }
        return shading;
    }

    protected AbstractPdfShading(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    protected AbstractPdfShading(PdfDictionary pdfObject, int type, PdfColorSpace colorSpace) {
        super(pdfObject);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ShadingType, new PdfNumber(type));
        if (colorSpace instanceof PdfSpecialCs.Pattern) {
            throw new IllegalArgumentException("colorSpace");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ColorSpace, (PdfObject)colorSpace.getPdfObject());
    }

    public int getShadingType() {
        return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.ShadingType);
    }

    public PdfObject getColorSpace() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.ColorSpace);
    }

    public PdfObject getFunction() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.Function);
    }

    public final void setFunction(IPdfFunction function) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Function, function.getAsPdfObject());
        this.setModified();
    }

    public final void setFunction(IPdfFunction[] functions) {
        PdfArray arr = new PdfArray();
        for (IPdfFunction func : functions) {
            arr.add(func.getAsPdfObject());
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Function, arr);
        this.setModified();
    }

    @Override
    public final void flush() {
        super.flush();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }
}

