/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.WriterProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class MemoryFirstPdfWriter
extends PdfWriter {
    private static final int MAX_ALLOWED_STREAMS = 100;
    private static final Map<String, MemoryFirstPdfWriter> waitingStreams = new ConcurrentHashMap<String, MemoryFirstPdfWriter>();
    private final String filePath;
    private final ByteArrayOutputStream outStream;

    MemoryFirstPdfWriter(String filename, WriterProperties properties) {
        this(filename, MemoryFirstPdfWriter.createBAOutputStream(), properties);
    }

    private MemoryFirstPdfWriter(String filename, ByteArrayOutputStream outputStream, WriterProperties properties) {
        super(outputStream, properties);
        this.setCloseStream(false);
        this.filePath = filename;
        this.outStream = outputStream;
        if (waitingStreams.size() >= 100) {
            throw new RuntimeException("Too many PdfWriter's have been created. Verify that you call CompareTool.cleanup where necessary");
        }
        waitingStreams.put(filename, this);
    }

    static MemoryFirstPdfWriter get(String filename) {
        return waitingStreams.get(filename);
    }

    static void cleanup(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Provided path is null");
        }
        for (String filePath : waitingStreams.keySet()) {
            if (!filePath.startsWith(path)) continue;
            waitingStreams.remove(filePath);
        }
    }

    void dump() throws IOException {
        try (OutputStream fos = FileUtil.getFileOutputStream((String)this.filePath);){
            this.outStream.writeTo(fos);
        }
    }

    ByteArrayOutputStream getBAOutputStream() {
        return this.outStream;
    }

    private static ByteArrayOutputStream createBAOutputStream() {
        return new ByteArrayOutputStream();
    }
}

