/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.signatures.PdfSignatureBuildProperties;

public class PdfSignature
extends PdfObjectWrapper<PdfDictionary> {
    public PdfSignature() {
        super((PdfObject)new PdfDictionary());
        this.put(PdfName.Type, (PdfObject)PdfName.Sig);
    }

    public PdfSignature(PdfName filter, PdfName subFilter) {
        this();
        this.put(PdfName.Filter, (PdfObject)filter);
        this.put(PdfName.SubFilter, (PdfObject)subFilter);
    }

    public PdfSignature(PdfDictionary sigDictionary) {
        super((PdfObject)sigDictionary);
        PdfString contents = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Contents);
        if (contents != null) {
            contents.markAsUnencryptedObject();
        }
    }

    public PdfName getSubFilter() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.SubFilter);
    }

    public PdfName getType() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Type);
    }

    public void setByteRange(int[] range) {
        PdfArray array = new PdfArray();
        for (int i : range) {
            array.add((PdfObject)new PdfNumber(i));
        }
        this.put(PdfName.ByteRange, (PdfObject)array);
    }

    public PdfArray getByteRange() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.ByteRange);
    }

    public void setContents(byte[] contents) {
        PdfString contentsString = new PdfString(contents).setHexWriting(true);
        contentsString.markAsUnencryptedObject();
        this.put(PdfName.Contents, (PdfObject)contentsString);
    }

    public PdfString getContents() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Contents);
    }

    public void setCert(byte[] cert) {
        this.put(PdfName.Cert, (PdfObject)new PdfString(cert));
    }

    public PdfString getCert() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Cert);
    }

    public PdfObject getCertObject() {
        PdfString certAsStr = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Cert);
        PdfArray certAsArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Cert);
        if (certAsStr != null) {
            return certAsStr;
        }
        return certAsArray;
    }

    public void setName(String name) {
        this.put(PdfName.Name, (PdfObject)new PdfString(name, "UnicodeBig"));
    }

    public String getName() {
        PdfString nameStr = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Name);
        PdfName nameName = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Name);
        if (nameStr != null) {
            return nameStr.toUnicodeString();
        }
        return nameName != null ? nameName.getValue() : null;
    }

    public void setDate(PdfDate date) {
        this.put(PdfName.M, date.getPdfObject());
    }

    public PdfString getDate() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.M);
    }

    public void setLocation(String location) {
        this.put(PdfName.Location, (PdfObject)new PdfString(location, "UnicodeBig"));
    }

    public String getLocation() {
        PdfString locationStr = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Location);
        return locationStr != null ? locationStr.toUnicodeString() : null;
    }

    public void setReason(String reason) {
        this.put(PdfName.Reason, (PdfObject)new PdfString(reason, "UnicodeBig"));
    }

    public String getReason() {
        PdfString reasonStr = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Reason);
        return reasonStr != null ? reasonStr.toUnicodeString() : null;
    }

    public void setSignatureCreator(String signatureCreator) {
        if (signatureCreator != null) {
            this.getPdfSignatureBuildProperties().setSignatureCreator(signatureCreator);
        }
    }

    public void setContact(String contactInfo) {
        this.put(PdfName.ContactInfo, (PdfObject)new PdfString(contactInfo, "UnicodeBig"));
    }

    public PdfSignature put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private PdfSignatureBuildProperties getPdfSignatureBuildProperties() {
        PdfDictionary buildPropDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Prop_Build);
        if (buildPropDict == null) {
            buildPropDict = new PdfDictionary();
            this.put(PdfName.Prop_Build, (PdfObject)buildPropDict);
        }
        return new PdfSignatureBuildProperties(buildPropDict);
    }
}

