/*
 * NeoLoad API
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.neotys.ascode.swagger.client.api;

import com.neotys.ascode.swagger.client.*;


import com.google.gson.reflect.TypeToken;

import java.io.IOException;




import com.neotys.ascode.swagger.client.model.ArrayOfElementDefinition;
import com.neotys.ascode.swagger.client.model.ArrayOfTestDefinition;
import com.neotys.ascode.swagger.client.model.CounterDefinition;
import com.neotys.ascode.swagger.client.model.CounterValues;
import com.neotys.ascode.swagger.client.model.ElementValues;
import com.neotys.ascode.swagger.client.model.MonitorPostRequest;
import com.neotys.ascode.swagger.client.model.Points;
import com.neotys.ascode.swagger.client.model.Sla;
import com.neotys.ascode.swagger.client.model.TestDefinition;
import com.neotys.ascode.swagger.client.model.TestStatistics;
import com.neotys.ascode.swagger.client.model.TestUpdateRequest;


import java.lang.reflect.Type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;



public class ResultsApi {
    private ApiClient apiClient;

    public ResultsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResultsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Build call for deleteTest
     * @param testId Unique identifier representing a specific test. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call deleteTestCall(String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTestValidateBeforeCall(String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling deleteTest(Async)");
        }
        
        
        com.squareup.okhttp.Call call = deleteTestCall(testId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Deletes a test result
     * Deletes a test result and all the associated statistics. This action cannot be undone.
     * @param testId Unique identifier representing a specific test. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public void deleteTest(String testId) throws ApiException {
        deleteTestWithHttpInfo(testId);
    }

    /**
     * Deletes a test result
     * Deletes a test result and all the associated statistics. This action cannot be undone.
     * @param testId Unique identifier representing a specific test. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<Void> deleteTestWithHttpInfo(String testId) throws ApiException {
        com.squareup.okhttp.Call call = deleteTestValidateBeforeCall(testId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deletes a test result (asynchronously)
     * Deletes a test result and all the associated statistics. This action cannot be undone.
     * @param testId Unique identifier representing a specific test. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call deleteTestAsync(String testId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTestValidateBeforeCall(testId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    
    /**
     * Build call for getTest
     * @param testId Unique identifier representing a specific test. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestCall(String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestValidateBeforeCall(String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTest(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestCall(testId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Test result description
     * Provides a test result description using a unique test identifier. Provides name, dates, owner ...
     * @param testId Unique identifier representing a specific test. (required)
     * @return TestDefinition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public TestDefinition getTest(String testId) throws ApiException {
        ApiResponse<TestDefinition> resp = getTestWithHttpInfo(testId);
        return resp.getData();
    }

    /**
     * Test result description
     * Provides a test result description using a unique test identifier. Provides name, dates, owner ...
     * @param testId Unique identifier representing a specific test. (required)
     * @return ApiResponse&lt;TestDefinition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<TestDefinition> getTestWithHttpInfo(String testId) throws ApiException {
        com.squareup.okhttp.Call call = getTestValidateBeforeCall(testId, null, null);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Test result description (asynchronously)
     * Provides a test result description using a unique test identifier. Provides name, dates, owner ...
     * @param testId Unique identifier representing a specific test. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestAsync(String testId, final ApiCallback<TestDefinition> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestValidateBeforeCall(testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTestElements
     * @param testId Unique identifier representing a specific test. (required)
     * @param category Category of the elements to return. Available categories are: TRANSACTION, PAGE, REQUEST. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestElementsCall(String testId, String category, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/elements"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (category != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("category", category));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestElementsValidateBeforeCall(String testId, String category, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElements(Async)");
        }
        
        // verify the required parameter 'category' is set
        if (category == null) {
            throw new ApiException("Missing the required parameter 'category' when calling getTestElements(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestElementsCall(testId, category, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Test elements
     * Provides the tests elements of a test result. The elements type must be provided.
     * @param testId Unique identifier representing a specific test. (required)
     * @param category Category of the elements to return. Available categories are: TRANSACTION, PAGE, REQUEST. (required)
     * @return ArrayOfElementDefinition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ArrayOfElementDefinition getTestElements(String testId, String category) throws ApiException {
        ApiResponse<ArrayOfElementDefinition> resp = getTestElementsWithHttpInfo(testId, category);
        return resp.getData();
    }

    /**
     * Test elements
     * Provides the tests elements of a test result. The elements type must be provided.
     * @param testId Unique identifier representing a specific test. (required)
     * @param category Category of the elements to return. Available categories are: TRANSACTION, PAGE, REQUEST. (required)
     * @return ApiResponse&lt;ArrayOfElementDefinition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<ArrayOfElementDefinition> getTestElementsWithHttpInfo(String testId, String category) throws ApiException {
        com.squareup.okhttp.Call call = getTestElementsValidateBeforeCall(testId, category, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfElementDefinition>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Test elements (asynchronously)
     * Provides the tests elements of a test result. The elements type must be provided.
     * @param testId Unique identifier representing a specific test. (required)
     * @param category Category of the elements to return. Available categories are: TRANSACTION, PAGE, REQUEST. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestElementsAsync(String testId, String category, final ApiCallback<ArrayOfElementDefinition> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestElementsValidateBeforeCall(testId, category, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfElementDefinition>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTestElementsPoints
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @param statistics Comma-separated list of statistics to get. Available statistics are: AVG_DURATION, MIN_DURATION, MAX_DURATION, COUNT, THROUGHPUT, ELEMENTS_PER_SECOND, ERRORS, ERRORS_PER_SECOND, ERROR_RATE, AVG_TTFB, MIN_TTFB, MAX_TTFB (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestElementsPointsCall(String testId, String elementId, String statistics, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/elements/{elementId}/points"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()))
            .replaceAll("\\{" + "elementId" + "\\}", apiClient.escapeString(elementId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (statistics != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("statistics", statistics));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestElementsPointsValidateBeforeCall(String testId, String elementId, String statistics, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElementsPoints(Async)");
        }
        
        // verify the required parameter 'elementId' is set
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsPoints(Async)");
        }
        
        // verify the required parameter 'statistics' is set
        if (statistics == null) {
            throw new ApiException("Missing the required parameter 'statistics' when calling getTestElementsPoints(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestElementsPointsCall(testId, elementId, statistics, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Tests elements points since the beginning of the test
     * Provides all the ponits of a test element for the selected statistics.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @param statistics Comma-separated list of statistics to get. Available statistics are: AVG_DURATION, MIN_DURATION, MAX_DURATION, COUNT, THROUGHPUT, ELEMENTS_PER_SECOND, ERRORS, ERRORS_PER_SECOND, ERROR_RATE, AVG_TTFB, MIN_TTFB, MAX_TTFB (required)
     * @return Points
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public Points getTestElementsPoints(String testId, String elementId, String statistics) throws ApiException {
        ApiResponse<Points> resp = getTestElementsPointsWithHttpInfo(testId, elementId, statistics);
        return resp.getData();
    }

    /**
     * Tests elements points since the beginning of the test
     * Provides all the ponits of a test element for the selected statistics.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @param statistics Comma-separated list of statistics to get. Available statistics are: AVG_DURATION, MIN_DURATION, MAX_DURATION, COUNT, THROUGHPUT, ELEMENTS_PER_SECOND, ERRORS, ERRORS_PER_SECOND, ERROR_RATE, AVG_TTFB, MIN_TTFB, MAX_TTFB (required)
     * @return ApiResponse&lt;Points&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<Points> getTestElementsPointsWithHttpInfo(String testId, String elementId, String statistics) throws ApiException {
        com.squareup.okhttp.Call call = getTestElementsPointsValidateBeforeCall(testId, elementId, statistics, null, null);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Tests elements points since the beginning of the test (asynchronously)
     * Provides all the ponits of a test element for the selected statistics.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @param statistics Comma-separated list of statistics to get. Available statistics are: AVG_DURATION, MIN_DURATION, MAX_DURATION, COUNT, THROUGHPUT, ELEMENTS_PER_SECOND, ERRORS, ERRORS_PER_SECOND, ERROR_RATE, AVG_TTFB, MIN_TTFB, MAX_TTFB (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestElementsPointsAsync(String testId, String elementId, String statistics, final ApiCallback<Points> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestElementsPointsValidateBeforeCall(testId, elementId, statistics, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTestElementsSla
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestElementsSlaCall(String testId, String elementId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/elements/{elementId}/sla"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()))
            .replaceAll("\\{" + "elementId" + "\\}", apiClient.escapeString(elementId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestElementsSlaValidateBeforeCall(String testId, String elementId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElementsSla(Async)");
        }
        
        // verify the required parameter 'elementId' is set
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsSla(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestElementsSlaCall(testId, elementId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Test elements SLA status since the beginning of the test
     * Provides the SLA status of a test element.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @return Sla
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public Sla getTestElementsSla(String testId, String elementId) throws ApiException {
        ApiResponse<Sla> resp = getTestElementsSlaWithHttpInfo(testId, elementId);
        return resp.getData();
    }

    /**
     * Test elements SLA status since the beginning of the test
     * Provides the SLA status of a test element.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @return ApiResponse&lt;Sla&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<Sla> getTestElementsSlaWithHttpInfo(String testId, String elementId) throws ApiException {
        com.squareup.okhttp.Call call = getTestElementsSlaValidateBeforeCall(testId, elementId, null, null);
        Type localVarReturnType = new TypeToken<Sla>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Test elements SLA status since the beginning of the test (asynchronously)
     * Provides the SLA status of a test element.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestElementsSlaAsync(String testId, String elementId, final ApiCallback<Sla> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestElementsSlaValidateBeforeCall(testId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Sla>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTestElementsValues
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestElementsValuesCall(String testId, String elementId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/elements/{elementId}/values"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()))
            .replaceAll("\\{" + "elementId" + "\\}", apiClient.escapeString(elementId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestElementsValuesValidateBeforeCall(String testId, String elementId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElementsValues(Async)");
        }
        
        // verify the required parameter 'elementId' is set
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsValues(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestElementsValuesCall(testId, elementId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Test elements values
     * Provides the values of a test element.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @return ElementValues
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ElementValues getTestElementsValues(String testId, String elementId) throws ApiException {
        ApiResponse<ElementValues> resp = getTestElementsValuesWithHttpInfo(testId, elementId);
        return resp.getData();
    }

    /**
     * Test elements values
     * Provides the values of a test element.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @return ApiResponse&lt;ElementValues&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<ElementValues> getTestElementsValuesWithHttpInfo(String testId, String elementId) throws ApiException {
        com.squareup.okhttp.Call call = getTestElementsValuesValidateBeforeCall(testId, elementId, null, null);
        Type localVarReturnType = new TypeToken<ElementValues>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Test elements values (asynchronously)
     * Provides the values of a test element.
     * @param testId Unique identifier representing a specific test. (required)
     * @param elementId Unique identifier representing a specific element. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestElementsValuesAsync(String testId, String elementId, final ApiCallback<ElementValues> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestElementsValuesValidateBeforeCall(testId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ElementValues>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTestMonitors
     * @param testId Unique identifier representing a specific test. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestMonitorsCall(String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/monitors"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestMonitorsValidateBeforeCall(String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestMonitors(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestMonitorsCall(testId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Test monitors
     * Provides all the tests counters of all monitors for a test result.
     * @param testId Unique identifier representing a specific test. (required)
     * @return CounterDefinition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public CounterDefinition getTestMonitors(String testId) throws ApiException {
        ApiResponse<CounterDefinition> resp = getTestMonitorsWithHttpInfo(testId);
        return resp.getData();
    }

    /**
     * Test monitors
     * Provides all the tests counters of all monitors for a test result.
     * @param testId Unique identifier representing a specific test. (required)
     * @return ApiResponse&lt;CounterDefinition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<CounterDefinition> getTestMonitorsWithHttpInfo(String testId) throws ApiException {
        com.squareup.okhttp.Call call = getTestMonitorsValidateBeforeCall(testId, null, null);
        Type localVarReturnType = new TypeToken<CounterDefinition>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Test monitors (asynchronously)
     * Provides all the tests counters of all monitors for a test result.
     * @param testId Unique identifier representing a specific test. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestMonitorsAsync(String testId, final ApiCallback<CounterDefinition> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestMonitorsValidateBeforeCall(testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CounterDefinition>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTestMonitorsPoints
     * @param testId Unique identifier representing a specific test. (required)
     * @param counterId Unique identifier representing a specific counter. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestMonitorsPointsCall(String testId, String counterId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/monitors/{counterId}/points"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()))
            .replaceAll("\\{" + "counterId" + "\\}", apiClient.escapeString(counterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestMonitorsPointsValidateBeforeCall(String testId, String counterId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestMonitorsPoints(Async)");
        }
        
        // verify the required parameter 'counterId' is set
        if (counterId == null) {
            throw new ApiException("Missing the required parameter 'counterId' when calling getTestMonitorsPoints(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestMonitorsPointsCall(testId, counterId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Tests monitors points
     * Provides all the points of a test counter. The values are the average on the specified interval.
     * @param testId Unique identifier representing a specific test. (required)
     * @param counterId Unique identifier representing a specific counter. (required)
     * @return Points
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public Points getTestMonitorsPoints(String testId, String counterId) throws ApiException {
        ApiResponse<Points> resp = getTestMonitorsPointsWithHttpInfo(testId, counterId);
        return resp.getData();
    }

    /**
     * Tests monitors points
     * Provides all the points of a test counter. The values are the average on the specified interval.
     * @param testId Unique identifier representing a specific test. (required)
     * @param counterId Unique identifier representing a specific counter. (required)
     * @return ApiResponse&lt;Points&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<Points> getTestMonitorsPointsWithHttpInfo(String testId, String counterId) throws ApiException {
        com.squareup.okhttp.Call call = getTestMonitorsPointsValidateBeforeCall(testId, counterId, null, null);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Tests monitors points (asynchronously)
     * Provides all the points of a test counter. The values are the average on the specified interval.
     * @param testId Unique identifier representing a specific test. (required)
     * @param counterId Unique identifier representing a specific counter. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestMonitorsPointsAsync(String testId, String counterId, final ApiCallback<Points> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestMonitorsPointsValidateBeforeCall(testId, counterId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTestMonitorsValues
     * @param testId Unique identifier representing a specific test. (required)
     * @param counterId Unique identifier representing a specific counter. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestMonitorsValuesCall(String testId, String counterId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/monitors/{counterId}/values"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()))
            .replaceAll("\\{" + "counterId" + "\\}", apiClient.escapeString(counterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestMonitorsValuesValidateBeforeCall(String testId, String counterId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestMonitorsValues(Async)");
        }
        
        // verify the required parameter 'counterId' is set
        if (counterId == null) {
            throw new ApiException("Missing the required parameter 'counterId' when calling getTestMonitorsValues(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestMonitorsValuesCall(testId, counterId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Tests monitors values
     * Provides the values of a test counter.
     * @param testId Unique identifier representing a specific test. (required)
     * @param counterId Unique identifier representing a specific counter. (required)
     * @return CounterValues
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public CounterValues getTestMonitorsValues(String testId, String counterId) throws ApiException {
        ApiResponse<CounterValues> resp = getTestMonitorsValuesWithHttpInfo(testId, counterId);
        return resp.getData();
    }

    /**
     * Tests monitors values
     * Provides the values of a test counter.
     * @param testId Unique identifier representing a specific test. (required)
     * @param counterId Unique identifier representing a specific counter. (required)
     * @return ApiResponse&lt;CounterValues&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<CounterValues> getTestMonitorsValuesWithHttpInfo(String testId, String counterId) throws ApiException {
        com.squareup.okhttp.Call call = getTestMonitorsValuesValidateBeforeCall(testId, counterId, null, null);
        Type localVarReturnType = new TypeToken<CounterValues>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Tests monitors values (asynchronously)
     * Provides the values of a test counter.
     * @param testId Unique identifier representing a specific test. (required)
     * @param counterId Unique identifier representing a specific counter. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestMonitorsValuesAsync(String testId, String counterId, final ApiCallback<CounterValues> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestMonitorsValuesValidateBeforeCall(testId, counterId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CounterValues>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTestStatistics
     * @param testId Unique identifier representing a specific test. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestStatisticsCall(String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/statistics"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestStatisticsValidateBeforeCall(String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestStatistics(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTestStatisticsCall(testId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Test result main statistics
     * Provides the main statistics of a test result. For a runnning test, these statistics are live, for a finished test, those are average for the all test.
     * @param testId Unique identifier representing a specific test. (required)
     * @return TestStatistics
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public TestStatistics getTestStatistics(String testId) throws ApiException {
        ApiResponse<TestStatistics> resp = getTestStatisticsWithHttpInfo(testId);
        return resp.getData();
    }

    /**
     * Test result main statistics
     * Provides the main statistics of a test result. For a runnning test, these statistics are live, for a finished test, those are average for the all test.
     * @param testId Unique identifier representing a specific test. (required)
     * @return ApiResponse&lt;TestStatistics&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<TestStatistics> getTestStatisticsWithHttpInfo(String testId) throws ApiException {
        com.squareup.okhttp.Call call = getTestStatisticsValidateBeforeCall(testId, null, null);
        Type localVarReturnType = new TypeToken<TestStatistics>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Test result main statistics (asynchronously)
     * Provides the main statistics of a test result. For a runnning test, these statistics are live, for a finished test, those are average for the all test.
     * @param testId Unique identifier representing a specific test. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestStatisticsAsync(String testId, final ApiCallback<TestStatistics> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestStatisticsValidateBeforeCall(testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestStatistics>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for getTests
     * @param status Returns only the test with the specified status. Available status are: STARTING, RUNNING, TERMINATED. (optional)
     * @param project Project name. Returns only the tests of the specified project. (optional)
     * @param author The author of the test. Returns only the tests launched by the specified author. (optional)
     * @param limit The maximum number of test results returned by this call. (optional)
     * @param offset The offset of the first test to return. Starting at this offset the query will return a maximum of &#x27;limit&#x27; tests. (optional)
     * @param fields Comma-separated list of fields to include in the json test definition. (optional)
     * @param pretty If true the Json returned is human readable. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call getTestsCall(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tests";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("status", status));
        if (project != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("project", project));
        if (author != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("author", author));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (fields != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("fields", fields));
        if (pretty != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pretty", pretty));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTestsValidateBeforeCall(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        
        com.squareup.okhttp.Call call = getTestsCall(status, project, author, limit, offset, fields, pretty, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Lists test results
     * Lists the test results of the Account according to the method parameters.
     * @param status Returns only the test with the specified status. Available status are: STARTING, RUNNING, TERMINATED. (optional)
     * @param project Project name. Returns only the tests of the specified project. (optional)
     * @param author The author of the test. Returns only the tests launched by the specified author. (optional)
     * @param limit The maximum number of test results returned by this call. (optional)
     * @param offset The offset of the first test to return. Starting at this offset the query will return a maximum of &#x27;limit&#x27; tests. (optional)
     * @param fields Comma-separated list of fields to include in the json test definition. (optional)
     * @param pretty If true the Json returned is human readable. (optional)
     * @return ArrayOfTestDefinition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ArrayOfTestDefinition getTests(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty) throws ApiException {
        ApiResponse<ArrayOfTestDefinition> resp = getTestsWithHttpInfo(status, project, author, limit, offset, fields, pretty);
        return resp.getData();
    }

    /**
     * Lists test results
     * Lists the test results of the Account according to the method parameters.
     * @param status Returns only the test with the specified status. Available status are: STARTING, RUNNING, TERMINATED. (optional)
     * @param project Project name. Returns only the tests of the specified project. (optional)
     * @param author The author of the test. Returns only the tests launched by the specified author. (optional)
     * @param limit The maximum number of test results returned by this call. (optional)
     * @param offset The offset of the first test to return. Starting at this offset the query will return a maximum of &#x27;limit&#x27; tests. (optional)
     * @param fields Comma-separated list of fields to include in the json test definition. (optional)
     * @param pretty If true the Json returned is human readable. (optional)
     * @return ApiResponse&lt;ArrayOfTestDefinition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<ArrayOfTestDefinition> getTestsWithHttpInfo(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty) throws ApiException {
        com.squareup.okhttp.Call call = getTestsValidateBeforeCall(status, project, author, limit, offset, fields, pretty, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfTestDefinition>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Lists test results (asynchronously)
     * Lists the test results of the Account according to the method parameters.
     * @param status Returns only the test with the specified status. Available status are: STARTING, RUNNING, TERMINATED. (optional)
     * @param project Project name. Returns only the tests of the specified project. (optional)
     * @param author The author of the test. Returns only the tests launched by the specified author. (optional)
     * @param limit The maximum number of test results returned by this call. (optional)
     * @param offset The offset of the first test to return. Starting at this offset the query will return a maximum of &#x27;limit&#x27; tests. (optional)
     * @param fields Comma-separated list of fields to include in the json test definition. (optional)
     * @param pretty If true the Json returned is human readable. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call getTestsAsync(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty, final ApiCallback<ArrayOfTestDefinition> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTestsValidateBeforeCall(status, project, author, limit, offset, fields, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfTestDefinition>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /**
     * Build call for postTestMonitors
     * @param body List of custom monitors (required)
     * @param testId Unique identifier representing a specific test. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call postTestMonitorsCall(MonitorPostRequest body, String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}/monitors"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postTestMonitorsValidateBeforeCall(MonitorPostRequest body, String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postTestMonitors(Async)");
        }
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling postTestMonitors(Async)");
        }
        
        
        com.squareup.okhttp.Call call = postTestMonitorsCall(body, testId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Create custom monitors
     * Pushes monitoring data (external data) for a given running test. &lt;br/&gt;&lt;br/&gt; &lt;b&gt;Resolution limitation&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;Maximum resolution for a monitor value is &lt;b&gt;1 per second&lt;/b&gt;, otherwise &lt;b&gt;the first value is kept&lt;/b&gt;.&lt;/li&gt; &lt;/ul&gt; &lt;b&gt;Maximum paths and monitors&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;Maximum 100 different &lt;b&gt;unique&lt;/b&gt; paths.&lt;/li&gt;   &lt;li&gt;Maximum 50 different monitors for a given path.&lt;/li&gt;   &lt;li&gt;Maximum length is 10 for a path.&lt;/li&gt; &lt;/ul&gt; &lt;b&gt;Other requirements&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;The timestamp is an epoch time in seconds. It must be after the beginning of the test and not more than 10 minutes in the future.&lt;/li&gt;   &lt;li&gt;&#x27;|&#x27; character is not allowed in name and path element.&lt;/li&gt;   &lt;li&gt;The test must be &lt;b&gt;running&lt;/b&gt; while pushing the data.&lt;/li&gt;   &lt;li&gt;For a given timestamp, all monitors relative to a path must be sent in the same request.&lt;/li&gt;   &lt;li&gt;These elements must not be empty: &lt;b&gt;monitor name&lt;/b&gt;, &lt;b&gt;a path element&lt;/b&gt; and &lt;b&gt;values&lt;/b&gt;.&lt;/li&gt; &lt;/ul&gt; 
     * @param body List of custom monitors (required)
     * @param testId Unique identifier representing a specific test. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public void postTestMonitors(MonitorPostRequest body, String testId) throws ApiException {
        postTestMonitorsWithHttpInfo(body, testId);
    }

    /**
     * Create custom monitors
     * Pushes monitoring data (external data) for a given running test. &lt;br/&gt;&lt;br/&gt; &lt;b&gt;Resolution limitation&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;Maximum resolution for a monitor value is &lt;b&gt;1 per second&lt;/b&gt;, otherwise &lt;b&gt;the first value is kept&lt;/b&gt;.&lt;/li&gt; &lt;/ul&gt; &lt;b&gt;Maximum paths and monitors&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;Maximum 100 different &lt;b&gt;unique&lt;/b&gt; paths.&lt;/li&gt;   &lt;li&gt;Maximum 50 different monitors for a given path.&lt;/li&gt;   &lt;li&gt;Maximum length is 10 for a path.&lt;/li&gt; &lt;/ul&gt; &lt;b&gt;Other requirements&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;The timestamp is an epoch time in seconds. It must be after the beginning of the test and not more than 10 minutes in the future.&lt;/li&gt;   &lt;li&gt;&#x27;|&#x27; character is not allowed in name and path element.&lt;/li&gt;   &lt;li&gt;The test must be &lt;b&gt;running&lt;/b&gt; while pushing the data.&lt;/li&gt;   &lt;li&gt;For a given timestamp, all monitors relative to a path must be sent in the same request.&lt;/li&gt;   &lt;li&gt;These elements must not be empty: &lt;b&gt;monitor name&lt;/b&gt;, &lt;b&gt;a path element&lt;/b&gt; and &lt;b&gt;values&lt;/b&gt;.&lt;/li&gt; &lt;/ul&gt; 
     * @param body List of custom monitors (required)
     * @param testId Unique identifier representing a specific test. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<Void> postTestMonitorsWithHttpInfo(MonitorPostRequest body, String testId) throws ApiException {
        com.squareup.okhttp.Call call = postTestMonitorsValidateBeforeCall(body, testId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Create custom monitors (asynchronously)
     * Pushes monitoring data (external data) for a given running test. &lt;br/&gt;&lt;br/&gt; &lt;b&gt;Resolution limitation&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;Maximum resolution for a monitor value is &lt;b&gt;1 per second&lt;/b&gt;, otherwise &lt;b&gt;the first value is kept&lt;/b&gt;.&lt;/li&gt; &lt;/ul&gt; &lt;b&gt;Maximum paths and monitors&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;Maximum 100 different &lt;b&gt;unique&lt;/b&gt; paths.&lt;/li&gt;   &lt;li&gt;Maximum 50 different monitors for a given path.&lt;/li&gt;   &lt;li&gt;Maximum length is 10 for a path.&lt;/li&gt; &lt;/ul&gt; &lt;b&gt;Other requirements&lt;/b&gt;: &lt;ul&gt;   &lt;li&gt;The timestamp is an epoch time in seconds. It must be after the beginning of the test and not more than 10 minutes in the future.&lt;/li&gt;   &lt;li&gt;&#x27;|&#x27; character is not allowed in name and path element.&lt;/li&gt;   &lt;li&gt;The test must be &lt;b&gt;running&lt;/b&gt; while pushing the data.&lt;/li&gt;   &lt;li&gt;For a given timestamp, all monitors relative to a path must be sent in the same request.&lt;/li&gt;   &lt;li&gt;These elements must not be empty: &lt;b&gt;monitor name&lt;/b&gt;, &lt;b&gt;a path element&lt;/b&gt; and &lt;b&gt;values&lt;/b&gt;.&lt;/li&gt; &lt;/ul&gt; 
     * @param body List of custom monitors (required)
     * @param testId Unique identifier representing a specific test. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call postTestMonitorsAsync(MonitorPostRequest body, String testId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postTestMonitorsValidateBeforeCall(body, testId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    
    /**
     * Build call for updateTest
     * @param body  (required)
     * @param testId Unique identifier representing a specific test. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
        
     */
    public com.squareup.okhttp.Call updateTestCall(TestUpdateRequest body, String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/tests/{testId}"
            .replaceAll("\\{" + "testId" + "\\}", apiClient.escapeString(testId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "NeoloadAuthorizer" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateTestValidateBeforeCall(TestUpdateRequest body, String testId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateTest(Async)");
        }
        
        // verify the required parameter 'testId' is set
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling updateTest(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updateTestCall(body, testId, progressListener, progressRequestListener);
        return call;

        
        
        
        
        
        
    }

    /**
     * Update a test result
     * Updates a test result with new name, description or quality status.
     * @param body  (required)
     * @param testId Unique identifier representing a specific test. (required)
     * @return TestDefinition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public TestDefinition updateTest(TestUpdateRequest body, String testId) throws ApiException {
        ApiResponse<TestDefinition> resp = updateTestWithHttpInfo(body, testId);
        return resp.getData();
    }

    /**
     * Update a test result
     * Updates a test result with new name, description or quality status.
     * @param body  (required)
     * @param testId Unique identifier representing a specific test. (required)
     * @return ApiResponse&lt;TestDefinition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
        
     */
    public ApiResponse<TestDefinition> updateTestWithHttpInfo(TestUpdateRequest body, String testId) throws ApiException {
        com.squareup.okhttp.Call call = updateTestValidateBeforeCall(body, testId, null, null);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update a test result (asynchronously)
     * Updates a test result with new name, description or quality status.
     * @param body  (required)
     * @param testId Unique identifier representing a specific test. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
        
     */
    public com.squareup.okhttp.Call updateTestAsync(TestUpdateRequest body, String testId, final ApiCallback<TestDefinition> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateTestValidateBeforeCall(body, testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
}
