/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.datatype.DataType;
import com.nexacro.xapi.data.datatype.DataTypeFactory;
import com.nexacro.xapi.data.datatype.PlatformDataType;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnHeader
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8469749920381404050L;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_CONSTANT = 1;
    private String name;
    private int type;
    private int dataType;
    private int dataSize;
    private Object value;

    public ColumnHeader(String name) {
        this(name, 2, 32);
    }

    public ColumnHeader(String name, int dataType) {
        this(name, dataType, DataTypes.getDefaultSize(dataType));
    }

    public ColumnHeader(String name, int dataType, int dataSize) {
        this(name, 0, dataType, dataSize, null);
    }

    public ColumnHeader(String name, DataType dataType) {
        this(name, dataType, PlatformDataType.getDefaultSize(dataType));
    }

    public ColumnHeader(String name, DataType dataType, int dataSize) {
        this(name, 0, PlatformDataType.getType(dataType), dataSize, null);
    }

    protected ColumnHeader(String name, Object value) {
        this(name, DataTypes.findType(value), value);
    }

    protected ColumnHeader(String name, int dataType, Object value) {
        this(name, dataType, DataTypes.getDefaultSize(dataType), value);
    }

    protected ColumnHeader(String name, int dataType, int dataSize, Object value) {
        this(name, 1, dataType, dataSize, value);
    }

    protected ColumnHeader(String name, DataType dataType, Object value) {
        this(name, dataType, PlatformDataType.getDefaultSize(dataType), value);
    }

    protected ColumnHeader(String name, DataType dataType, int dataSize, Object value) {
        this(name, 1, PlatformDataType.getType(dataType), dataSize, value);
    }

    private ColumnHeader(String name, int type, int dataType, int dataSize, Object value) {
        this.setName(name);
        this.setType(type);
        this.setDataType(dataType);
        this.setDataSize(dataSize);
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.checkName(name);
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    void setType(int type) {
        this.type = type;
    }

    public boolean isConstant() {
        return this.getType() == 1;
    }

    public int getDataType() {
        return this.dataType;
    }

    void setDataType(int dataType) {
        this.checkDataType(dataType);
        this.dataType = dataType;
    }

    public DataType getPlatformDataType() {
        return DataTypeFactory.getPlatformDataType(this.dataType);
    }

    void setPlatformDataType(DataType dataType) {
        this.dataType = PlatformDataType.getType(dataType);
    }

    public int getDataSize() {
        return this.dataSize;
    }

    void setDataSize(int dataSize) {
        this.checkDataSize(dataSize);
        this.dataSize = dataSize;
    }

    protected Object getValue() {
        return this.value;
    }

    protected void setValue(Object value) {
        this.value = value;
    }

    public ColumnHeader getClone() {
        try {
            return (ColumnHeader)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log log = LogFactory.getLog((Class)ColumnHeader.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not clone", (Throwable)ex);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnHeader) {
            ColumnHeader another = (ColumnHeader)obj;
            return this.name.equals(another.name) && this.type == another.type && this.dataType == another.dataType && this.dataSize == another.dataSize && this.equalsValue(another);
        }
        return false;
    }

    private boolean equalsValue(ColumnHeader another) {
        if (this.value == null) {
            return another.value == null;
        }
        return this.value.equals(another.value);
    }

    private void checkName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.charAt(0) == ' ' && "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
    }

    private void checkDataType(int dataType) {
        if (dataType < 0 || dataType > 13) {
            throw new IllegalArgumentException("Invalid data type: " + dataType);
        }
    }

    private void checkDataSize(int dataSize) {
        if (dataSize < 0) {
            throw new IllegalArgumentException("Invalid data size: " + dataSize);
        }
    }
}

