/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.PlatformSsvDataDeserializer;
import com.nexacro.xapi.data.PlatformSsvDataSerializer;
import com.nexacro.xapi.data.PlatformXmlDataDeserializer;
import com.nexacro.xapi.data.PlatformXmlDataSerializer;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.PlatformException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformData
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8979436269137318153L;
    private VariableList varList = new VariableList();
    private DataSetList dsList = new DataSetList();
    private int saveType = 0;

    public int getSaveType() {
        return this.saveType;
    }

    public void setSaveType(int saveType) {
        this.saveType = saveType;
    }

    public Variable getVariable(String name) {
        return this.varList.get(name);
    }

    public Variable getVariable(int index) {
        return this.varList.get(index);
    }

    public void addVariable(Variable var) {
        this.varList.add(var);
    }

    public int getVariableCount() {
        return this.varList.size();
    }

    public VariableList getVariableList() {
        return this.varList;
    }

    public void setVariableList(VariableList varList) {
        this.varList = varList;
    }

    public DataSet getDataSet(String name) {
        return this.dsList.get(name);
    }

    public DataSet getDataSet(int index) {
        return this.dsList.get(index);
    }

    public void addDataSet(DataSet ds) {
        this.dsList.add(ds);
    }

    public int getDataSetCount() {
        return this.dsList.size();
    }

    public DataSetList getDataSetList() {
        return this.dsList;
    }

    public void setDataSetList(DataSetList dsList) {
        this.dsList = dsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadXml(String str) {
        StringReader in = new StringReader(str);
        try {
            PlatformXmlDataDeserializer deserializer = new PlatformXmlDataDeserializer();
            deserializer.readData((Reader)in, this);
            boolean bl = true;
            return bl;
        }
        catch (PlatformException ex) {
            Log log = LogFactory.getLog((Class)PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not load xml", (Throwable)ex);
            }
        }
        finally {
            in.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveXml() {
        StringWriter out = new StringWriter();
        try {
            PlatformXmlDataSerializer serializer = new PlatformXmlDataSerializer();
            serializer.writeData((Writer)out, this);
            String string = out.toString();
            return string;
        }
        catch (PlatformException ex) {
            Log log = LogFactory.getLog((Class)PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not save xml", (Throwable)ex);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSsv(String str) {
        StringReader in = new StringReader(str);
        try {
            PlatformSsvDataDeserializer deserializer = new PlatformSsvDataDeserializer();
            deserializer.readData((Reader)in, this);
            boolean bl = true;
            return bl;
        }
        catch (PlatformException ex) {
            Log log = LogFactory.getLog((Class)PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not load ssv", (Throwable)ex);
            }
        }
        finally {
            in.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveSsv() {
        StringWriter out = new StringWriter();
        try {
            PlatformSsvDataSerializer serializer = new PlatformSsvDataSerializer();
            serializer.writeData((Writer)out, this);
            String string = out.toString();
            return string;
        }
        catch (PlatformException ex) {
            Log log = LogFactory.getLog((Class)PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not save ssv", (Throwable)ex);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public PlatformData getClone() {
        try {
            return (PlatformData)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log log = LogFactory.getLog((Class)PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not clone", (Throwable)ex);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PlatformData data = (PlatformData)super.clone();
        data.varList = (VariableList)this.varList.clone();
        data.dsList = (DataSetList)this.dsList.clone();
        return data;
    }
}

