/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.datatype;

import com.nexacro.xapi.data.datatype.DataType;
import com.nexacro.xapi.data.datatype.DataTypeFactory;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;

public class JavaDataType {
    public static final String CATEGORY_NAME = "JAVA";
    public static final DataType BYTE = new DataType("JAVA", 1, "byte");
    public static final DataType SHORT = new DataType("JAVA", 2, "short");
    public static final DataType INT = new DataType("JAVA", 3, "int");
    public static final DataType LONG = new DataType("JAVA", 4, "long");
    public static final DataType FLOAT = new DataType("JAVA", 5, "float");
    public static final DataType DOUBLE = new DataType("JAVA", 6, "double");
    public static final DataType BOOLEAN = new DataType("JAVA", 7, "boolean");
    public static final DataType CHAR = new DataType("JAVA", 8, "char");
    public static final DataType BYTE_OBJECT = new DataType("JAVA", 11, JavaDataType.getSimpleName(Byte.class) + "_OBJECT");
    public static final DataType SHORT_OBJECT = new DataType("JAVA", 12, JavaDataType.getSimpleName(Short.class) + "_OBJECT");
    public static final DataType INT_OBJECT = new DataType("JAVA", 13, JavaDataType.getSimpleName(Integer.class) + "_OBJECT");
    public static final DataType LONG_OBJECT = new DataType("JAVA", 14, JavaDataType.getSimpleName(Long.class) + "_OBJECT");
    public static final DataType FLOAT_OBJECT = new DataType("JAVA", 15, JavaDataType.getSimpleName(Float.class) + "_OBJECT");
    public static final DataType DOUBLE_OBJECT = new DataType("JAVA", 16, JavaDataType.getSimpleName(Double.class) + "_OBJECT");
    public static final DataType BOOLEAN_OBJECT = new DataType("JAVA", 17, JavaDataType.getSimpleName(Boolean.class) + "_OBJECT");
    public static final DataType CHAR_OBJECT = new DataType("JAVA", 18, JavaDataType.getSimpleName(Character.class) + "_OBJECT");
    public static final DataType STRING = new DataType("JAVA", 21, JavaDataType.getSimpleName(String.class));
    public static final DataType DATE = new DataType("JAVA", 22, JavaDataType.getSimpleName(Date.class));
    public static final DataType OBJECT = new DataType("JAVA", 23, JavaDataType.getSimpleName(Object.class));
    public static final DataType NULL = new DataType("JAVA", 24, "null");
    public static final DataType BIG_DECIMAL = new DataType("JAVA", 25, JavaDataType.getSimpleName(BigDecimal.class));
    public static final DataType OBJECT_ARRAY = new DataType("JAVA", 31, "Object[]");
    public static final DataType BYTE_ARRAY = new DataType("JAVA", 32, "byte[]");
    public static final DataType CHAR_ARRAY = new DataType("JAVA", 33, "char[]");
    public static final DataType INVALID = new DataType("JAVA", 40, "invalid");
    static final DataType ONLY_DATE = new DataType("JAVA", 51, "only_date");
    static final DataType ONLY_TIME = new DataType("JAVA", 52, "only_time");
    private static int maxType = JavaDataType.getMaxType();

    static void registerDefinedDataType() {
        DataTypeFactory.register(JavaDataType.class);
    }

    static void registerConvertible() {
        JavaDataType.setAsConvertible(BYTE, BYTE_OBJECT);
        JavaDataType.setAsConvertible(SHORT, SHORT_OBJECT);
        JavaDataType.setAsConvertible(INT, INT_OBJECT);
        JavaDataType.setAsConvertible(LONG, LONG_OBJECT);
        JavaDataType.setAsConvertible(FLOAT, FLOAT_OBJECT);
        JavaDataType.setAsConvertible(DOUBLE, DOUBLE_OBJECT);
        JavaDataType.setAsConvertible(CHAR, CHAR_OBJECT);
        JavaDataType.setAsConvertible(BOOLEAN, BOOLEAN_OBJECT);
        JavaDataType.setAsConvertible(BYTE_OBJECT, BYTE);
        JavaDataType.setAsConvertible(SHORT_OBJECT, SHORT);
        JavaDataType.setAsConvertible(INT_OBJECT, INT);
        JavaDataType.setAsConvertible(LONG_OBJECT, LONG);
        JavaDataType.setAsConvertible(FLOAT_OBJECT, FLOAT);
        JavaDataType.setAsConvertible(DOUBLE_OBJECT, DOUBLE);
        JavaDataType.setAsConvertible(CHAR_OBJECT, CHAR);
        JavaDataType.setAsConvertible(BOOLEAN_OBJECT, BOOLEAN);
        JavaDataType.setAsConvertible(BOOLEAN, BYTE);
        JavaDataType.setAsConvertible(BYTE, CHAR);
        JavaDataType.setAsConvertible(CHAR, SHORT);
        JavaDataType.setAsConvertible(SHORT, INT);
        JavaDataType.setAsConvertible(INT, LONG);
        JavaDataType.setAsConvertible(INT, FLOAT);
        JavaDataType.setAsConvertible(FLOAT, DOUBLE);
        JavaDataType.setAsConvertible(LONG, BIG_DECIMAL);
        JavaDataType.setAsConvertible(FLOAT, BIG_DECIMAL);
        JavaDataType.setAsConvertible(DOUBLE, STRING);
        JavaDataType.setAsConvertible(DATE, STRING);
        JavaDataType.setAsConvertible(BIG_DECIMAL, STRING);
        JavaDataType.setAsConvertible(STRING, OBJECT);
        JavaDataType.setAsConvertible(DATE, LONG);
    }

    static String getSimpleName(Class clazz) {
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    static synchronized int getNewType() {
        return ++maxType;
    }

    private static void setAsConvertible(DataType from, DataType to) {
        DataTypeFactory.setAsConvertible(from, to);
    }

    private static int getMaxType() {
        int maxType = -1;
        Field[] fields = JavaDataType.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!DataTypeFactory.isDataTypeField(fields[i])) continue;
            try {
                DataType dataType = (DataType)fields[i].get(null);
                int type = dataType.getType();
                if (type <= maxType) continue;
                maxType = type;
                continue;
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return maxType;
    }

    private JavaDataType() {
    }
}

