/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.datatype;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.datatype.DataType;
import com.nexacro.xapi.data.datatype.DataTypeFactory;
import com.nexacro.xapi.data.datatype.JavaDataType;

public class PlatformDataType {
    public static final String CATEGORY_NAME = "PLATFORM";
    public static final DataType UNDEFINED = new DataType("PLATFORM", 0, "undefined");
    public static final DataType NULL = new DataType("PLATFORM", 1, "null");
    public static final DataType STRING = new DataType("PLATFORM", 2, "string");
    public static final DataType INT = new DataType("PLATFORM", 3, "int");
    public static final DataType BOOLEAN = new DataType("PLATFORM", 4, "boolean");
    public static final DataType LONG = new DataType("PLATFORM", 5, "long");
    public static final DataType FLOAT = new DataType("PLATFORM", 6, "float");
    public static final DataType DOUBLE = new DataType("PLATFORM", 7, "double");
    public static final DataType BIG_DECIMAL = new DataType("PLATFORM", 8, "bigdecimal");
    public static final DataType DATE = new DataType("PLATFORM", 9, "date");
    public static final DataType TIME = new DataType("PLATFORM", 10, "time");
    public static final DataType DATE_TIME = new DataType("PLATFORM", 11, "datetime");
    public static final DataType BLOB = new DataType("PLATFORM", 12, "blob");
    public static final DataType DATASET = new DataType("PLATFORM", 21, "dataset");
    public static final DataType INVALID = new DataType("PLATFORM", 30, "invalid");

    public static int getType(DataType dataType) {
        return DataTypeFactory.getPlatformDataType(dataType).getType();
    }

    public static int getDefaultSize(DataType dataType) {
        return DataTypes.getDefaultSize(PlatformDataType.getType(dataType));
    }

    static void registerDefinedDataType() {
        DataTypeFactory.register(PlatformDataType.class);
        DataTypeFactory.bindConverting(UNDEFINED, JavaDataType.OBJECT);
        DataTypeFactory.bindConverting(NULL, JavaDataType.NULL);
        DataTypeFactory.bindConverting(STRING, JavaDataType.STRING);
        DataTypeFactory.bindConverting(INT, JavaDataType.INT);
        DataTypeFactory.bindConverting(BOOLEAN, JavaDataType.BOOLEAN);
        DataTypeFactory.bindConverting(LONG, JavaDataType.LONG);
        DataTypeFactory.bindConverting(FLOAT, JavaDataType.FLOAT);
        DataTypeFactory.bindConverting(DOUBLE, JavaDataType.DOUBLE);
        DataTypeFactory.bindConverting(BIG_DECIMAL, JavaDataType.BIG_DECIMAL);
        DataTypeFactory.bindConverting(DATE, JavaDataType.ONLY_DATE);
        DataTypeFactory.bindConverting(TIME, JavaDataType.ONLY_TIME);
        DataTypeFactory.bindConverting(DATE_TIME, JavaDataType.DATE);
        DataTypeFactory.bindConverting(BLOB, JavaDataType.BYTE_ARRAY);
        DataTypeFactory.bindConverting(DATASET, JavaDataType.OBJECT);
        DataTypeFactory.bindConverting(INVALID, JavaDataType.INVALID);
        DataTypeFactory.bindConverting(JavaDataType.BYTE, INT);
        DataTypeFactory.bindConverting(JavaDataType.SHORT, INT);
        DataTypeFactory.bindConverting(JavaDataType.INT, INT);
        DataTypeFactory.bindConverting(JavaDataType.LONG, LONG);
        DataTypeFactory.bindConverting(JavaDataType.FLOAT, FLOAT);
        DataTypeFactory.bindConverting(JavaDataType.DOUBLE, DOUBLE);
        DataTypeFactory.bindConverting(JavaDataType.BOOLEAN, BOOLEAN);
        DataTypeFactory.bindConverting(JavaDataType.CHAR, STRING);
        DataTypeFactory.bindConverting(JavaDataType.BYTE_OBJECT, INT);
        DataTypeFactory.bindConverting(JavaDataType.SHORT_OBJECT, INT);
        DataTypeFactory.bindConverting(JavaDataType.INT_OBJECT, INT);
        DataTypeFactory.bindConverting(JavaDataType.LONG_OBJECT, LONG);
        DataTypeFactory.bindConverting(JavaDataType.FLOAT_OBJECT, FLOAT);
        DataTypeFactory.bindConverting(JavaDataType.DOUBLE_OBJECT, DOUBLE);
        DataTypeFactory.bindConverting(JavaDataType.BOOLEAN_OBJECT, BOOLEAN);
        DataTypeFactory.bindConverting(JavaDataType.CHAR_OBJECT, STRING);
        DataTypeFactory.bindConverting(JavaDataType.STRING, STRING);
        DataTypeFactory.bindConverting(JavaDataType.ONLY_DATE, DATE);
        DataTypeFactory.bindConverting(JavaDataType.ONLY_TIME, TIME);
        DataTypeFactory.bindConverting(JavaDataType.DATE, DATE_TIME);
        DataTypeFactory.bindConverting(JavaDataType.OBJECT, UNDEFINED);
        DataTypeFactory.bindConverting(JavaDataType.NULL, NULL);
        DataTypeFactory.bindConverting(JavaDataType.BIG_DECIMAL, DOUBLE);
        DataTypeFactory.bindConverting(JavaDataType.OBJECT_ARRAY, UNDEFINED);
        DataTypeFactory.bindConverting(JavaDataType.BYTE_ARRAY, BLOB);
        DataTypeFactory.bindConverting(JavaDataType.CHAR_ARRAY, STRING);
        DataTypeFactory.bindConverting(JavaDataType.INVALID, INVALID);
    }

    static void registerConvertible() {
        PlatformDataType.setAsConvertible(BOOLEAN, INT);
        PlatformDataType.setAsConvertible(INT, LONG);
        PlatformDataType.setAsConvertible(INT, FLOAT);
        PlatformDataType.setAsConvertible(FLOAT, DOUBLE);
        PlatformDataType.setAsConvertible(LONG, DOUBLE);
        PlatformDataType.setAsConvertible(LONG, BIG_DECIMAL);
        PlatformDataType.setAsConvertible(DOUBLE, BIG_DECIMAL);
        PlatformDataType.setAsConvertible(LONG, STRING);
        PlatformDataType.setAsConvertible(DOUBLE, STRING);
        PlatformDataType.setAsConvertible(BIG_DECIMAL, STRING);
        PlatformDataType.setAsConvertible(DATE, DATE_TIME);
        PlatformDataType.setAsConvertible(TIME, DATE_TIME);
        PlatformDataType.setAsConvertible(LONG, DATE_TIME);
        PlatformDataType.setAsConvertible(DATE_TIME, LONG);
        PlatformDataType.setAsConvertible(DATE, STRING);
        PlatformDataType.setAsConvertible(TIME, STRING);
        PlatformDataType.setAsConvertible(DATE_TIME, STRING);
        PlatformDataType.setAsConvertible(BIG_DECIMAL, JavaDataType.BIG_DECIMAL);
        PlatformDataType.setAsConvertible(JavaDataType.LONG, BIG_DECIMAL);
        PlatformDataType.setAsConvertible(DATE, JavaDataType.ONLY_DATE);
        PlatformDataType.setAsConvertible(TIME, JavaDataType.ONLY_TIME);
        PlatformDataType.setAsConvertible(JavaDataType.ONLY_DATE, DATE);
        PlatformDataType.setAsConvertible(JavaDataType.ONLY_TIME, TIME);
    }

    private static void setAsConvertible(DataType from, DataType to) {
        DataTypeFactory.setAsConvertible(from, to);
    }

    private PlatformDataType() {
    }
}

