/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import java.math.BigDecimal;
import java.util.Date;

class BigDecimalTypeConverter {
    public Object toObject(BigDecimal value) {
        return value;
    }

    public String toString(BigDecimal value) {
        return value == null ? DataTypes.DEFAULT_VALUE_STRING : value.toString();
    }

    public int toInt(BigDecimal value) {
        return value == null ? 0 : value.intValue();
    }

    public boolean toBoolean(BigDecimal value) {
        return false;
    }

    public long toLong(BigDecimal value) {
        return value == null ? 0L : value.longValue();
    }

    public float toFloat(BigDecimal value) {
        return value == null ? 0.0f : value.floatValue();
    }

    public double toDouble(BigDecimal value) {
        return value == null ? 0.0 : value.doubleValue();
    }

    public Date toDate(BigDecimal value) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(BigDecimal value) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(BigDecimal value) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(BigDecimal value) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(BigDecimal value, int type) {
        switch (type) {
            case 2: {
                return this.toString(value);
            }
            case 3: {
                return new Integer(this.toInt(value));
            }
            case 4: {
                return this.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(value));
            }
            case 6: {
                return new Float(this.toFloat(value));
            }
            case 7: {
                return new Double(this.toDouble(value));
            }
            case 8: {
                return this.toObject(value);
            }
            case 9: {
                return this.toDate(value);
            }
            case 10: {
                return this.toTime(value);
            }
            case 11: {
                return this.toDateTime(value);
            }
            case 12: {
                return this.toObject(value);
            }
        }
        return this.toObject(value);
    }
}

