/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BlobTypeConverter {
    public Object toObject(byte[] value) {
        return value;
    }

    public String toString(byte[] value) {
        return this.toString(value, null);
    }

    public String toString(byte[] value, String charset) {
        try {
            if (value == null) {
                return DataTypes.DEFAULT_VALUE_STRING;
            }
            if (charset == null) {
                return new String(value);
            }
            return new String(value, charset);
        }
        catch (UnsupportedEncodingException ex) {
            Log log = LogFactory.getLog((Class)BlobTypeConverter.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Converting to type byte[] failed: value=" + new String(value) + ", charset=" + charset), (Throwable)ex);
            }
            return new String(value);
        }
    }

    public int toInt(byte[] value) {
        return 0;
    }

    public boolean toBoolean(byte[] value) {
        return false;
    }

    public long toLong(byte[] value) {
        return 0L;
    }

    public float toFloat(byte[] value) {
        return 0.0f;
    }

    public double toDouble(byte[] value) {
        return 0.0;
    }

    public BigDecimal toBigDecimal(byte[] value) {
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public Date toDate(byte[] value) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(byte[] value) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(byte[] value) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public Object convert(byte[] value, int type) {
        return this.convert(value, type, null);
    }

    public Object convert(byte[] value, int type, String charset) {
        switch (type) {
            case 2: {
                return this.toString(value, charset);
            }
            case 3: {
                return new Integer(this.toInt(value));
            }
            case 4: {
                return this.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(value));
            }
            case 6: {
                return new Float(this.toFloat(value));
            }
            case 7: {
                return new Double(this.toDouble(value));
            }
            case 8: {
                return this.toBigDecimal(value);
            }
            case 9: {
                return this.toDate(value);
            }
            case 10: {
                return this.toTime(value);
            }
            case 11: {
                return this.toDateTime(value);
            }
            case 12: {
                return this.toObject(value);
            }
        }
        return this.toObject(value);
    }
}

