/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import java.math.BigDecimal;
import java.util.Date;

class BooleanTypeConverter {
    public Object toObject(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString(boolean value) {
        return String.valueOf(value);
    }

    public int toInt(boolean value) {
        return 0;
    }

    public long toLong(boolean value) {
        return 0L;
    }

    public float toFloat(boolean value) {
        return 0.0f;
    }

    public double toDouble(boolean value) {
        return 0.0;
    }

    public BigDecimal toBigDecimal(boolean value) {
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public Date toDate(boolean value) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(boolean value) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(boolean value) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(boolean value) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(boolean value, int type) {
        switch (type) {
            case 2: {
                return this.toString(value);
            }
            case 3: {
                return new Integer(this.toInt(value));
            }
            case 4: {
                return this.toObject(value);
            }
            case 5: {
                return new Long(this.toLong(value));
            }
            case 6: {
                return new Float(this.toFloat(value));
            }
            case 7: {
                return new Double(this.toDouble(value));
            }
            case 8: {
                return this.toBigDecimal(value);
            }
            case 9: {
                return this.toDate(value);
            }
            case 10: {
                return this.toTime(value);
            }
            case 11: {
                return this.toDateTime(value);
            }
            case 12: {
                return this.toBlob(value);
            }
        }
        return this.toObject(value);
    }
}

