/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.util.BigDecimalTypeConverter;
import com.nexacro.xapi.data.util.BlobTypeConverter;
import com.nexacro.xapi.data.util.BooleanTypeConverter;
import com.nexacro.xapi.data.util.DateTypeConverter;
import com.nexacro.xapi.data.util.DoubleTypeConverter;
import com.nexacro.xapi.data.util.FloatTypeConverter;
import com.nexacro.xapi.data.util.IntegerTypeConverter;
import com.nexacro.xapi.data.util.LongTypeConverter;
import com.nexacro.xapi.data.util.StringTypeConverter;
import java.math.BigDecimal;
import java.util.Date;

public class TypeConverter {
    private static final StringTypeConverter STRING_CONVERTER = new StringTypeConverter();
    private static final IntegerTypeConverter INT_CONVERTER = new IntegerTypeConverter();
    private static final BooleanTypeConverter BOOLEAN_CONVERTER = new BooleanTypeConverter();
    private static final LongTypeConverter LONG_CONVERTER = new LongTypeConverter();
    private static final FloatTypeConverter FLOAT_CONVERTER = new FloatTypeConverter();
    private static final DoubleTypeConverter DOUBLE_CONVERTER = new DoubleTypeConverter();
    private static final BigDecimalTypeConverter BIG_DECIMAL_CONVERTER = new BigDecimalTypeConverter();
    private static final DateTypeConverter DATE_CONVERTER = new DateTypeConverter();
    private static final BlobTypeConverter BLOB_CONVERTER = new BlobTypeConverter();

    public static Object toObject(Object value) {
        return value;
    }

    public static String toString(Object value) {
        return TypeConverter.toString(value, 0);
    }

    public static String toString(Object value, int type) {
        return TypeConverter.toString(value, type, null);
    }

    public static String toString(Object value, int type, String charset) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toString((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toString((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toString((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toString(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toString((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toString((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toString((Date)value, type);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toString((byte[])value, charset);
        }
        return value.toString();
    }

    public static int toInt(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toInt((String)value);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toInt((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toInt((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toInt(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toInt((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toInt((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toInt((Date)value);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toInt((byte[])value);
        }
        return 0;
    }

    public static boolean toBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toBoolean((String)value);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toBoolean((Integer)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toBoolean((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toBoolean(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toBoolean((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toBoolean((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toBoolean((Date)value);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toBoolean((byte[])value);
        }
        return false;
    }

    public static long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toLong((String)value);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toLong((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toLong((Boolean)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toLong(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toLong((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toLong((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toLong((Date)value);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toLong((byte[])value);
        }
        return 0L;
    }

    public static float toFloat(Object value) {
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toFloat((String)value);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toFloat((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toFloat((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toFloat((Long)value);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toFloat((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toFloat((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toFloat((Date)value);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toFloat((byte[])value);
        }
        return 0.0f;
    }

    public static double toDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toDouble((String)value);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toDouble((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toDouble((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toDouble((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toDouble(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toDouble((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toDouble((Date)value);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toDouble((byte[])value);
        }
        return 0.0;
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toBigDecimal((String)value);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toBigDecimal((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toBigDecimal((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toBigDecimal((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toBigDecimal(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toBigDecimal((Double)value);
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toBigDecimal((Date)value);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toBigDecimal((byte[])value);
        }
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public static Date toDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toDate((String)value);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toDate((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toDate((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toDate((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toDate(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toDate((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toDate((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toDate((Date)value);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toDate((byte[])value);
        }
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public static Date toTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toTime((String)value);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toTime((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toTime((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toTime((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toTime(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toTime((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toTime((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toTime((Date)value);
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toTime((byte[])value);
        }
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public static Date toDateTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toDateTime((String)value);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toDateTime((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toDateTime((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toDateTime((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toDateTime(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toDateTime((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toDateTime((BigDecimal)value);
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof byte[]) {
            return BLOB_CONVERTER.toDateTime((byte[])value);
        }
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public static byte[] toBlob(Object value) {
        return TypeConverter.toBlob(value, null);
    }

    public static byte[] toBlob(Object value, String charset) {
        if (value == null) {
            return DataTypes.DEFAULT_VALUE_BLOB;
        }
        if (value instanceof String) {
            return STRING_CONVERTER.toBlob((String)value, charset);
        }
        if (value instanceof Integer) {
            return INT_CONVERTER.toBlob((Integer)value);
        }
        if (value instanceof Boolean) {
            return BOOLEAN_CONVERTER.toBlob((Boolean)value);
        }
        if (value instanceof Long) {
            return LONG_CONVERTER.toBlob((Long)value);
        }
        if (value instanceof Float) {
            return FLOAT_CONVERTER.toBlob(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DOUBLE_CONVERTER.toBlob((Double)value);
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toBlob((BigDecimal)value);
        }
        if (value instanceof Date) {
            return DATE_CONVERTER.toBlob((Date)value);
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public static Object toObject(String value) {
        return STRING_CONVERTER.toObject(value);
    }

    public static int toInt(String value) {
        return STRING_CONVERTER.toInt(value);
    }

    public static boolean toBoolean(String value) {
        return STRING_CONVERTER.toBoolean(value);
    }

    public static long toLong(String value) {
        return STRING_CONVERTER.toLong(value);
    }

    public static float toFloat(String value) {
        return STRING_CONVERTER.toFloat(value);
    }

    public static double toDouble(String value) {
        return STRING_CONVERTER.toDouble(value);
    }

    public static BigDecimal toBigDecimal(String value) {
        return STRING_CONVERTER.toBigDecimal(value);
    }

    public static Date toDate(String value) {
        return STRING_CONVERTER.toDate(value);
    }

    public static Date toTime(String value) {
        return STRING_CONVERTER.toTime(value);
    }

    public static Date toDateTime(String value) {
        return STRING_CONVERTER.toDateTime(value);
    }

    public static byte[] toBlob(String value) {
        return TypeConverter.toBlob(value, null);
    }

    public static byte[] toBlob(String value, String charset) {
        return STRING_CONVERTER.toBlob(value, charset);
    }

    public static Object toObject(int value) {
        return INT_CONVERTER.toObject(value);
    }

    public static String toString(int value) {
        return INT_CONVERTER.toString(value);
    }

    public static boolean toBoolean(int value) {
        return INT_CONVERTER.toBoolean(value);
    }

    public static long toLong(int value) {
        return INT_CONVERTER.toLong(value);
    }

    public static float toFloat(int value) {
        return INT_CONVERTER.toFloat(value);
    }

    public static double toDouble(int value) {
        return INT_CONVERTER.toDouble(value);
    }

    public static BigDecimal toBigDecimal(int value) {
        return INT_CONVERTER.toBigDecimal(value);
    }

    public static Date toDate(int value) {
        return INT_CONVERTER.toDate(value);
    }

    public static Date toTime(int value) {
        return INT_CONVERTER.toTime(value);
    }

    public static Date toDateTime(int value) {
        return INT_CONVERTER.toDateTime(value);
    }

    public static byte[] toBlob(int value) {
        return INT_CONVERTER.toBlob(value);
    }

    public static Object toObject(boolean value) {
        return BOOLEAN_CONVERTER.toObject(value);
    }

    public static String toString(boolean value) {
        return BOOLEAN_CONVERTER.toString(value);
    }

    public static int toInt(boolean value) {
        return BOOLEAN_CONVERTER.toInt(value);
    }

    public static long toLong(boolean value) {
        return BOOLEAN_CONVERTER.toLong(value);
    }

    public static float toFloat(boolean value) {
        return BOOLEAN_CONVERTER.toFloat(value);
    }

    public static double toDouble(boolean value) {
        return BOOLEAN_CONVERTER.toDouble(value);
    }

    public static BigDecimal toBigDecimal(boolean value) {
        return BOOLEAN_CONVERTER.toBigDecimal(value);
    }

    public static Date toDate(boolean value) {
        return BOOLEAN_CONVERTER.toDate(value);
    }

    public static Date toTime(boolean value) {
        return BOOLEAN_CONVERTER.toTime(value);
    }

    public static Date toDateTime(boolean value) {
        return BOOLEAN_CONVERTER.toDateTime(value);
    }

    public static byte[] toBlob(boolean value) {
        return BOOLEAN_CONVERTER.toBlob(value);
    }

    public static Object toObject(long value) {
        return LONG_CONVERTER.toObject(value);
    }

    public static String toString(long value) {
        return LONG_CONVERTER.toString(value);
    }

    public static int toInt(long value) {
        return LONG_CONVERTER.toInt(value);
    }

    public static boolean toBoolean(long value) {
        return LONG_CONVERTER.toBoolean(value);
    }

    public static float toFloat(long value) {
        return LONG_CONVERTER.toFloat(value);
    }

    public static double toDouble(long value) {
        return LONG_CONVERTER.toDouble(value);
    }

    public static BigDecimal toBigDecimal(long value) {
        return LONG_CONVERTER.toBigDecimal(value);
    }

    public static Date toDate(long value) {
        return LONG_CONVERTER.toDate(value);
    }

    public static Date toTime(long value) {
        return LONG_CONVERTER.toTime(value);
    }

    public static Date toDateTime(long value) {
        return LONG_CONVERTER.toDateTime(value);
    }

    public static byte[] toBlob(long value) {
        return LONG_CONVERTER.toBlob(value);
    }

    public static Object toObject(float value) {
        return FLOAT_CONVERTER.toObject(value);
    }

    public static String toString(float value) {
        return FLOAT_CONVERTER.toString(value);
    }

    public static int toInt(float value) {
        return FLOAT_CONVERTER.toInt(value);
    }

    public static boolean toBoolean(float value) {
        return FLOAT_CONVERTER.toBoolean(value);
    }

    public static long toLong(float value) {
        return FLOAT_CONVERTER.toLong(value);
    }

    public static double toDouble(float value) {
        return FLOAT_CONVERTER.toDouble(value);
    }

    public static BigDecimal toBigDecimal(float value) {
        return FLOAT_CONVERTER.toBigDecimal(value);
    }

    public static Date toDate(float value) {
        return FLOAT_CONVERTER.toDate(value);
    }

    public static Date toTime(float value) {
        return FLOAT_CONVERTER.toTime(value);
    }

    public static Date toDateTime(float value) {
        return FLOAT_CONVERTER.toDateTime(value);
    }

    public static byte[] toBlob(float value) {
        return FLOAT_CONVERTER.toBlob(value);
    }

    public static Object toObject(double value) {
        return DOUBLE_CONVERTER.toObject(value);
    }

    public static String toString(double value) {
        return DOUBLE_CONVERTER.toString(value);
    }

    public static int toInt(double value) {
        return DOUBLE_CONVERTER.toInt(value);
    }

    public static boolean toBoolean(double value) {
        return DOUBLE_CONVERTER.toBoolean(value);
    }

    public static long toLong(double value) {
        return DOUBLE_CONVERTER.toLong(value);
    }

    public static float toFloat(double value) {
        return DOUBLE_CONVERTER.toFloat(value);
    }

    public static BigDecimal toBigDecimal(double value) {
        return DOUBLE_CONVERTER.toBigDecimal(value);
    }

    public static Date toDate(double value) {
        return DOUBLE_CONVERTER.toDate(value);
    }

    public static Date toTime(double value) {
        return DOUBLE_CONVERTER.toTime(value);
    }

    public static Date toDateTime(double value) {
        return DOUBLE_CONVERTER.toDateTime(value);
    }

    public static byte[] toBlob(double value) {
        return DOUBLE_CONVERTER.toBlob(value);
    }

    public static Object toObject(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toObject(value);
    }

    public static String toString(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toString(value);
    }

    public static int toInt(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toInt(value);
    }

    public static boolean toBoolean(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toBoolean(value);
    }

    public static long toLong(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toLong(value);
    }

    public static float toFloat(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toFloat(value);
    }

    public static double toDouble(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toDouble(value);
    }

    public static Date toDate(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toDate(value);
    }

    public static Date toTime(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toTime(value);
    }

    public static Date toDateTime(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toDateTime(value);
    }

    public static byte[] toBlob(BigDecimal value) {
        return BIG_DECIMAL_CONVERTER.toBlob(value);
    }

    public static Object toObject(Date value) {
        return DATE_CONVERTER.toObject(value);
    }

    public static String toString(Date value) {
        return DATE_CONVERTER.toString(value);
    }

    public static int toInt(Date value) {
        return DATE_CONVERTER.toInt(value);
    }

    public static boolean toBoolean(Date value) {
        return DATE_CONVERTER.toBoolean(value);
    }

    public static long toLong(Date value) {
        return DATE_CONVERTER.toLong(value);
    }

    public static float toFloat(Date value) {
        return DATE_CONVERTER.toFloat(value);
    }

    public static double toDouble(Date value) {
        return DATE_CONVERTER.toDouble(value);
    }

    public static BigDecimal toBigDecimal(Date value) {
        return DATE_CONVERTER.toBigDecimal(value);
    }

    public static Date toDate(Date value) {
        return DATE_CONVERTER.toDate(value);
    }

    public static Date toTime(Date value) {
        return DATE_CONVERTER.toTime(value);
    }

    public static byte[] toBlob(Date value) {
        return DATE_CONVERTER.toBlob(value);
    }

    public static Object toObject(byte[] value) {
        return BLOB_CONVERTER.toObject(value);
    }

    public static String toString(byte[] value) {
        return TypeConverter.toString(value, null);
    }

    public static String toString(byte[] value, String charset) {
        return BLOB_CONVERTER.toString(value, charset);
    }

    public static int toInt(byte[] value) {
        return BLOB_CONVERTER.toInt(value);
    }

    public static long toLong(byte[] value) {
        return BLOB_CONVERTER.toLong(value);
    }

    public static float toFloat(byte[] value) {
        return BLOB_CONVERTER.toFloat(value);
    }

    public static double toDouble(byte[] value) {
        return BLOB_CONVERTER.toDouble(value);
    }

    public static BigDecimal toBigDecimal(byte[] value) {
        return BLOB_CONVERTER.toBigDecimal(value);
    }

    public static Date toDate(byte[] value) {
        return BLOB_CONVERTER.toDate(value);
    }

    public static Date toTime(byte[] value) {
        return BLOB_CONVERTER.toTime(value);
    }

    public static Date toDateTime(byte[] value) {
        return BLOB_CONVERTER.toDateTime(value);
    }

    public static Object convert(Object value, int type) {
        return TypeConverter.convert(value, type, null);
    }

    public static Object convert(Object value, int type, String charset) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return TypeConverter.convert((String)value, type, charset);
        }
        if (value instanceof Integer) {
            return TypeConverter.convert((Integer)value, type);
        }
        if (value instanceof Boolean) {
            return TypeConverter.convert((Boolean)value, type);
        }
        if (value instanceof Long) {
            return TypeConverter.convert((Long)value, type);
        }
        if (value instanceof Float) {
            return TypeConverter.convert(((Float)value).floatValue(), type);
        }
        if (value instanceof Double) {
            return TypeConverter.convert((Double)value, type);
        }
        if (value instanceof BigDecimal) {
            return TypeConverter.convert((BigDecimal)value, type);
        }
        if (value instanceof Date) {
            return TypeConverter.convert((Date)value, type);
        }
        if (value instanceof byte[]) {
            return TypeConverter.convert((byte[])value, type, charset);
        }
        return value;
    }

    public static Object convert(String value, int type) {
        return TypeConverter.convert(value, type, null);
    }

    public static Object convert(String value, int type, String charset) {
        return STRING_CONVERTER.convert(value, type, charset);
    }

    public static Object convert(int value, int type) {
        return INT_CONVERTER.convert(value, type);
    }

    public static Object convert(boolean value, int type) {
        return BOOLEAN_CONVERTER.convert(value, type);
    }

    public static Object convert(long value, int type) {
        return LONG_CONVERTER.convert(value, type);
    }

    public static Object convert(float value, int type) {
        return FLOAT_CONVERTER.convert(value, type);
    }

    public static Object convert(double value, int type) {
        return DOUBLE_CONVERTER.convert(value, type);
    }

    public static Object convert(BigDecimal value, int type) {
        return BIG_DECIMAL_CONVERTER.convert(value, type);
    }

    public static Object convert(Date value, int type) {
        return DATE_CONVERTER.convert(value, type);
    }

    public static Object convert(byte[] value, int type) {
        return TypeConverter.convert(value, type, null);
    }

    public static Object convert(byte[] value, int type, String charset) {
        return BLOB_CONVERTER.convert(value, type, charset);
    }

    private TypeConverter() {
    }
}

