/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.PartDataSerializer;
import com.nexacro.xapi.tx.impl.MiBinaryDataDeserializer;
import com.nexacro.xapi.tx.impl.MiBinaryDataSerializer;
import com.nexacro.xapi.tx.impl.MiXmlDataDeserializer;
import com.nexacro.xapi.tx.impl.MiXmlDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformBinaryDataDeserializer;
import com.nexacro.xapi.tx.impl.PlatformBinaryDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformBinaryPartDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformHtmlDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformSsvDataDeserializer;
import com.nexacro.xapi.tx.impl.PlatformSsvDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformSsvExtDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformSsvPartDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformXmlDataDeserializer;
import com.nexacro.xapi.tx.impl.PlatformXmlDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformXmlPartDataSerializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSerializerFactory {
    private static final String SUFFIX_SERIALIZER = ".serializer";
    private static final String SUFFIX_PART_SERIALIZER = ".partserializer";
    private static final String SUFFIX_DESERIALIZER = ".deserializer";
    private static Map filters = new HashMap();

    public static DataSerializer getSerializer(String type) {
        block4: {
            Object serializer = filters.get(type + SUFFIX_SERIALIZER);
            if (serializer instanceof DataSerializer) {
                return (DataSerializer)serializer;
            }
            if (serializer instanceof Class) {
                try {
                    return (DataSerializer)((Class)serializer).newInstance();
                }
                catch (Throwable ex) {
                    Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not create DataSerializer: type=" + type), ex);
                }
            }
        }
        return null;
    }

    public static PartDataSerializer getPartSerializer(String type) {
        block4: {
            Object serializer = filters.get(type + SUFFIX_PART_SERIALIZER);
            if (serializer instanceof PartDataSerializer) {
                return (PartDataSerializer)serializer;
            }
            if (serializer instanceof Class) {
                try {
                    return (PartDataSerializer)((Class)serializer).newInstance();
                }
                catch (Throwable ex) {
                    Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not create PartDataSerializer: type=" + type), ex);
                }
            }
        }
        return null;
    }

    public static DataDeserializer getDeserializer(String type) {
        block4: {
            Object deserializer = filters.get(type + SUFFIX_DESERIALIZER);
            if (deserializer instanceof DataDeserializer) {
                return (DataDeserializer)deserializer;
            }
            if (deserializer instanceof Class) {
                try {
                    return (DataDeserializer)((Class)deserializer).newInstance();
                }
                catch (Throwable ex) {
                    Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not create DataDeserializer: type=" + type), ex);
                }
            }
        }
        return null;
    }

    public static void registerSerializer(String type, Object serializer) {
        block12: {
            DataSerializerFactory.checkType(type);
            Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
            String contentType = type.trim();
            if (serializer instanceof DataSerializer) {
                filters.put(contentType + SUFFIX_SERIALIZER, serializer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register DataSerializer: type=" + type + ", serializer=" + serializer));
                }
            } else {
                if (serializer instanceof Class) {
                    try {
                        Object obj = ((Class)serializer).newInstance();
                        if (obj instanceof DataSerializer) {
                            filters.put(contentType + SUFFIX_SERIALIZER, serializer);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Register DataSerializer: type=" + type + ", serializer=" + serializer));
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Could not register DataSerializer: type=" + type + ", serializer=" + serializer));
                        }
                        break block12;
                    }
                    catch (Throwable ex) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not register DataSerializer: type=" + type + ", serializer=" + serializer), ex);
                        }
                        break block12;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not register DataSerializer: type=" + type + ", serializer=" + serializer));
                }
            }
        }
    }

    public static void registerPartSerializer(String type, Object serializer) {
        block12: {
            DataSerializerFactory.checkType(type);
            Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
            String contentType = type.trim();
            if (serializer instanceof PartDataSerializer) {
                filters.put(contentType + SUFFIX_PART_SERIALIZER, serializer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register PartDataSerializer: type=" + type + ", serializer=" + serializer));
                }
            } else {
                if (serializer instanceof Class) {
                    try {
                        Object obj = ((Class)serializer).newInstance();
                        if (obj instanceof PartDataSerializer) {
                            filters.put(contentType + SUFFIX_PART_SERIALIZER, serializer);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Register PartDataSerializer: type=" + type + ", serializer=" + serializer));
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Could not register PartDataSerializer: type=" + type + ", serializer=" + serializer));
                        }
                        break block12;
                    }
                    catch (Throwable ex) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not register PartDataSerializer: type=" + type + ", serializer=" + serializer), ex);
                        }
                        break block12;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not register PartDataSerializer: type=" + type + ", serializer=" + serializer));
                }
            }
        }
    }

    public static void registerDeserializer(String type, Object deserializer) {
        block12: {
            DataSerializerFactory.checkType(type);
            Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
            String contentType = type.trim();
            if (deserializer instanceof DataDeserializer) {
                filters.put(contentType + SUFFIX_DESERIALIZER, deserializer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register DataDeserializer: type=" + type + ", deserializer=" + deserializer));
                }
            } else {
                if (deserializer instanceof Class) {
                    try {
                        Object obj = ((Class)deserializer).newInstance();
                        if (obj instanceof DataDeserializer) {
                            filters.put(contentType + SUFFIX_DESERIALIZER, deserializer);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Register DataDeserializer: type=" + type + ", deserializer=" + deserializer));
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Could not register DataDeserializer: type=" + type + ", deserializer=" + deserializer));
                        }
                        break block12;
                    }
                    catch (Throwable ex) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not register DataDeserializer: type=" + type + ", deserializer=" + deserializer), ex);
                        }
                        break block12;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not register DataDeserializer: type=" + type + ", deserializer=" + deserializer));
                }
            }
        }
    }

    private static void initSerializers(Map filters) {
        filters.put("PlatformXml.serializer", PlatformXmlDataSerializer.class);
        filters.put("PlatformBinary.serializer", PlatformBinaryDataSerializer.class);
        filters.put("PlatformSsv.serializer", PlatformSsvDataSerializer.class);
        filters.put("MiXml.serializer", MiXmlDataSerializer.class);
        filters.put("MiBinary.serializer", MiBinaryDataSerializer.class);
        filters.put("PlatformHtml.serializer", new PlatformHtmlDataSerializer());
        filters.put("PlatformSsvExt.serializer", PlatformSsvExtDataSerializer.class);
    }

    private static void initPartSerializers(Map filters) {
        filters.put("PlatformXml.partserializer", PlatformXmlPartDataSerializer.class);
        filters.put("PlatformBinary.partserializer", PlatformBinaryPartDataSerializer.class);
        filters.put("PlatformSsv.partserializer", PlatformSsvPartDataSerializer.class);
    }

    private static void initDeserializers(Map filters) {
        filters.put("PlatformXml.deserializer", PlatformXmlDataDeserializer.class);
        filters.put("PlatformBinary.deserializer", PlatformBinaryDataDeserializer.class);
        filters.put("PlatformSsv.deserializer", PlatformSsvDataDeserializer.class);
        filters.put("MiXml.deserializer", MiXmlDataDeserializer.class);
        filters.put("MiBinary.deserializer", MiBinaryDataDeserializer.class);
    }

    private static void checkType(String type) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("No type specified");
        }
        if (type.charAt(0) == ' ' && "".equals(type.trim())) {
            throw new IllegalArgumentException("Invalid type: \"" + type + "\"");
        }
    }

    private DataSerializerFactory() {
    }

    static {
        DataSerializerFactory.initSerializers(filters);
        DataSerializerFactory.initPartSerializers(filters);
        DataSerializerFactory.initDeserializers(filters);
    }
}

