/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformUtils;
import com.nexacro.xapi.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpPlatformRequest
extends PlatformRequest {
    private Log log = LogFactory.getLog((Class)HttpPlatformRequest.class);
    private static final String REGISTER_GET_PARAMETER = "http.getparameter.register";
    private static final String GET_PARAMETER_AS_VARIABLE = "http.getparameter.asvariable";
    private HttpServletRequest httpReq;

    public HttpPlatformRequest(InputStream in) {
        super(in);
    }

    public HttpPlatformRequest(InputStream in, String contentType) {
        super(in, contentType);
    }

    public HttpPlatformRequest(InputStream in, String contentType, String charset) {
        super(in, contentType, charset);
    }

    public HttpPlatformRequest(Reader reader) {
        super(reader);
    }

    public HttpPlatformRequest(Reader reader, String contentType) {
        super(reader, contentType);
    }

    public HttpPlatformRequest(Reader reader, String contentType, String charset) {
        super(reader, contentType, charset);
    }

    public HttpPlatformRequest(HttpServletRequest httpReq) {
        this(httpReq, null, null);
    }

    public HttpPlatformRequest(HttpServletRequest httpReq, String contentType) {
        this(httpReq, contentType, null);
    }

    public HttpPlatformRequest(HttpServletRequest httpReq, String contentType, String charset) {
        super(contentType, charset);
        this.httpReq = httpReq;
        this.setCheckLicense(!this.isLocalRequest(httpReq));
    }

    public Object getProperty(String key) {
        return super.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
    }

    public void receiveData() throws PlatformException {
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Receiving data from HTTP: " + this.toSimpleString()));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Receiving data from HTTP: " + this.toSimpleString()));
        }
        if (this.httpReq == null) {
            super.receiveData();
            return;
        }
        int contentLength = this.httpReq.getContentLength();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Receiving data: contentLength=" + contentLength));
        }
        try {
            this.findContentTypeAndCharset(this.httpReq);
            String currentCharset = this.getCurrentCharset();
            boolean isHttpPost = this.isHttpPost(this.httpReq);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Checking HTTP POST: isHttpPost=" + isHttpPost));
            }
            if (isHttpPost) {
                this.setData(this.createEmptyData());
                this.parseHttpParametersToDataSet(this.httpReq);
            } else {
                if (contentLength > 0) {
                    this.readFrom(this.httpReq);
                } else {
                    this.setData(this.createEmptyData());
                }
                if (this.isRegisterGetParameter()) {
                    if (this.isRegisterGetParameterAsVariable()) {
                        this.parseHttpParametersToVariables(this.httpReq);
                    } else {
                        this.parseHttpParametersToDataSet(this.httpReq);
                    }
                }
            }
        }
        catch (PlatformException ex) {
            throw ex;
        }
        catch (Throwable th) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Receiving data failed", th);
            }
            throw new PlatformException("Receiving data failed", th);
        }
    }

    void readFrom(HttpServletRequest httpReq) throws PlatformException {
        try {
            this.setInputStream((InputStream)httpReq.getInputStream());
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not get HTTP InputStream", (Throwable)ex);
            }
            throw new PlatformException("Could not get HTTP InputStream", ex);
        }
        super.receiveData();
    }

    void parseHttpParametersToDataSet(HttpServletRequest httpReq) {
        Enumeration names;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Parsing HTTP Parameters: " + this));
        }
        if (this.getData() == null) {
            this.setData(this.createEmptyData());
        }
        if ((names = httpReq.getParameterNames()).hasMoreElements()) {
            DataSet httpData = new DataSet("httpData");
            DataSet httpDataCount = new DataSet("httpDataCount");
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                httpData.addColumn(name, 2, 256);
                httpDataCount.addColumn(name, 3, 4);
            }
            httpDataCount.newRow();
            int columnCount = httpData.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                int j;
                String name = httpData.getColumn(i).getName();
                String[] values = httpReq.getParameterValues(name);
                if (values == null || values.length == 0) {
                    httpDataCount.set(0, name, 0);
                    continue;
                }
                int count = values.length;
                httpDataCount.set(0, name, count);
                int n = count - httpData.getRowCount();
                if (n > 0) {
                    for (j = 0; j < n; ++j) {
                        httpData.newRow();
                    }
                }
                for (j = 0; j < count; ++j) {
                    httpData.set(j, name, values[j]);
                }
            }
            this.getData().addDataSet(httpData);
            this.getData().addDataSet(httpDataCount);
        }
    }

    void parseHttpParametersToVariables(HttpServletRequest httpReq) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Parsing HTTP Parameters: " + this));
        }
        if (this.getData() == null) {
            this.setData(this.createEmptyData());
        }
        VariableList vl = this.getData().getVariableList();
        Enumeration names = httpReq.getParameterNames();
        if (names.hasMoreElements()) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = httpReq.getParameter(name);
                vl.add(name, value);
            }
        }
    }

    private void findContentTypeAndCharset(HttpServletRequest httpReq) {
        String charset;
        String contentType;
        String httpContentType = httpReq.getContentType();
        String httpContentEncoding = httpReq.getHeader("Content-Encoding");
        String userAgent = httpReq.getHeader("User-Agent");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: httpContentType=" + httpContentType + ", httpContentEncoding=" + httpContentEncoding + ", userAgent=" + userAgent));
        }
        if ((contentType = this.getContentType()) == null) {
            contentType = this.findContentType(httpContentType, userAgent);
        }
        if ((charset = this.getCharset()) == null) {
            charset = this.findCharset(httpContentType);
        }
        this.setContentType(contentType);
        this.setCharset(charset);
    }

    String findContentType(String httpContentType, String userAgent) {
        String contentType;
        if (StringUtils.isEmpty(httpContentType)) {
            return null;
        }
        int index = httpContentType.indexOf(59);
        String string = contentType = index == -1 ? httpContentType : httpContentType.substring(0, index);
        if ("text/xml".equals(contentType)) {
            if (this.isMiPlatform(userAgent)) {
                return "MiXml";
            }
            return "PlatformXml";
        }
        if ("application/octet-stream".equals(contentType)) {
            if (this.isMiPlatform(userAgent)) {
                return "MiBinary";
            }
            return "PlatformBinary";
        }
        if ("text/html".equals(contentType)) {
            return "PlatformHtml";
        }
        return null;
    }

    String findCharset(String httpContentType) {
        String[] types = PlatformUtils.splitKeyAndValue(httpContentType, ';');
        if (types == null) {
            return null;
        }
        String[] charset = PlatformUtils.splitKeyAndValue(types[1], '=');
        if (charset == null) {
            return null;
        }
        if ("charset".equals(charset[0]) && !StringUtils.isEmpty(charset[1])) {
            return charset[1];
        }
        return null;
    }

    private boolean isMiPlatform(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return userAgent.startsWith("MiPlatform");
    }

    private boolean isHttpPost(HttpServletRequest httpReq) {
        return "application/x-www-form-urlencoded".equals(httpReq.getContentType());
    }

    private boolean isLocalRequest(HttpServletRequest httpReq) {
        String serverName = httpReq.getServerName();
        return "localhost".equals(serverName) || "127.0.0.1".equals(serverName);
    }

    private boolean isRegisterGetParameter() {
        return "true".equals(this.getProperty(REGISTER_GET_PARAMETER));
    }

    private boolean isRegisterGetParameterAsVariable() {
        return "true".equals(this.getProperty(GET_PARAMETER_AS_VARIABLE));
    }

    private PlatformData createEmptyData() {
        return new PlatformData();
    }
}

