/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataSerializerFactory;
import com.nexacro.xapi.tx.PartDataSerializer;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformTransaction;
import com.nexacro.xapi.tx.ProtocolEncoder;
import com.nexacro.xapi.tx.ProtocolFilterFactory;
import com.nexacro.xapi.util.PlatformGlobals;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartPlatformResponse
extends PlatformTransaction {
    private Log log = LogFactory.getLog((Class)PartPlatformResponse.class);
    private static final String IO_CLOSE_KEY = "platform.tx.PlatformResponse.ioclose";
    private static final String AUTO_DATA_CLEAR_KEY = "platform.tx.PartPlatformResponse.autodataclear";
    private static final int INDEX_INIT = 0;
    private static final int INDEX_STARTED = 1;
    private static final int INDEX_HEAD = 2;
    private static final int INDEX_VARIABLE = 3;
    private static final int INDEX_DATASET = 4;
    private static final int INDEX_TAIL = 5;
    private static final int INDEX_ENDED = 6;
    private static final String[] INDEX_NAMES = new String[]{"INIT", "STARTED", "HEAD", "VARIABLE", "DATASET", "TAIL", "ENDED", "UNKNOWN"};
    private OutputStream out;
    private Writer writer;
    private boolean autoDataClear = PlatformGlobals.getBooleanProperty("platform.tx.PartPlatformResponse.autodataclear", true);
    private int index;
    private long startTime;
    private PartDataSerializer serializer;
    private OutputStream[] streamEncoders;
    private OutputStream streamEncoder;
    private Writer[] writerEncoders;
    private Writer writerEncoder;

    public PartPlatformResponse() {
    }

    public PartPlatformResponse(String contentType) {
        this(contentType, null);
    }

    public PartPlatformResponse(String contentType, String charset) {
        super(contentType, charset);
    }

    public PartPlatformResponse(PlatformRequest req) {
        this(req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public PartPlatformResponse(OutputStream out) {
        this(out, (String)null);
    }

    public PartPlatformResponse(OutputStream out, String contentType) {
        this(out, contentType, null);
    }

    public PartPlatformResponse(OutputStream out, String contentType, String charset) {
        super(contentType, charset);
        this.out = out;
    }

    public PartPlatformResponse(OutputStream out, PlatformRequest req) {
        this(out, req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public PartPlatformResponse(Writer writer) {
        this(writer, (String)null);
    }

    public PartPlatformResponse(Writer writer, String contentType) {
        this(writer, contentType, null);
    }

    public PartPlatformResponse(Writer writer, String contentType, String charset) {
        super(contentType, charset);
        this.writer = writer;
    }

    public PartPlatformResponse(Writer writer, PlatformRequest req) {
        this(writer, req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public boolean isAutoDataClear() {
        return this.autoDataClear;
    }

    public void setAutoDataClear(boolean autoDataClear) {
        this.autoDataClear = autoDataClear;
    }

    public void start() throws PlatformException {
        if (this.getIndex() > 0) {
            throw new PlatformException("Sending data failed. command=start, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkLicense();
        this.setStartTime(System.currentTimeMillis());
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset()));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ", startTime=" + this.startTime));
        }
        this.checkStream();
        this.init();
        this.setIndex(1);
        this.serializer.writeHead();
        this.setIndex(2);
    }

    public void end() throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 4) {
            throw new PlatformException("Sending data failed. command=end, index=" + this.getIndexName(this.getIndex()));
        }
        this.serializer.writeTail();
        this.setIndex(5);
        this.destroy();
        this.setIndex(6);
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - this.getStartTime();
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime + ", endTime=" + endTime));
        }
    }

    public void sendVariable(Variable var) throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 3) {
            throw new PlatformException("Sending data failed. command=variable, index=" + this.getIndexName(this.getIndex()));
        }
        if (var == null) {
            throw new PlatformException("Variable is null");
        }
        this.serializer.writeVariable(var);
        this.setIndex(3);
    }

    public void sendDataSet(DataSet ds) throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 4) {
            throw new PlatformException("Sending data failed. command=dataset, index=" + this.getIndexName(this.getIndex()));
        }
        if (ds == null) {
            throw new PlatformException("DataSet is null");
        }
        this.serializer.writeDataSet(ds);
        if (this.isAutoDataClear()) {
            ds.clearData();
        }
        this.setIndex(4);
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setOutputStream(OutputStream out) {
        this.out = out;
    }

    Writer getWriter() {
        return this.writer;
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    boolean useOutputStream() {
        return this.writer == null;
    }

    private void init() throws PlatformException {
        this.initSerializer();
        if (this.useOutputStream()) {
            this.initStreamEncoders(this.getOutputStream());
        } else {
            this.initWriterEncoders(this.getWriter());
        }
    }

    private void destroy() throws PlatformException {
        this.destroySerializer();
        if (this.useOutputStream()) {
            this.destroyStreamEncoders();
        } else {
            this.destroyWriterEncoders();
        }
    }

    private void initSerializer() throws PlatformException {
        String contentType = this.getCurrentContentType();
        PartDataSerializer dataSerializer = DataSerializerFactory.getPartSerializer(contentType);
        if (dataSerializer == null) {
            throw new PlatformException("Could not create PartDataSerializer: " + contentType);
        }
        this.serializer = dataSerializer;
    }

    private void initStreamEncoders(OutputStream out) throws PlatformException {
        int protocolTypeCount = this.getProtocolTypeCount();
        OutputStream[] encoders = null;
        OutputStream encoder = out;
        if (protocolTypeCount > 0) {
            encoders = new OutputStream[protocolTypeCount];
            for (int i = 0; i < protocolTypeCount; ++i) {
                String protocolType = this.getProtocolType(i);
                encoders[i] = encoder = ProtocolFilterFactory.getEncoder(protocolType, encoder);
                if (encoder != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + protocolType);
            }
        }
        this.streamEncoders = encoders;
        this.streamEncoder = encoder;
        this.serializer.setCharset(this.getCurrentCharset());
        this.serializer.setDataTypeChanger(this.getDataTypeChanger());
        this.serializer.setOutputStream(encoder);
    }

    private void initWriterEncoders(Writer writer) throws PlatformException {
        int protocolTypeCount = this.getProtocolTypeCount();
        Writer[] encoders = null;
        Writer encoder = writer;
        if (protocolTypeCount > 0) {
            encoders = new Writer[protocolTypeCount];
            for (int i = 0; i < protocolTypeCount; ++i) {
                String protocolType = this.getProtocolType(i);
                encoders[i] = encoder = ProtocolFilterFactory.getEncoder(protocolType, encoder);
                if (encoder != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + protocolType);
            }
        }
        this.writerEncoders = encoders;
        this.writerEncoder = encoder;
        this.serializer.setCharset(this.getCurrentCharset());
        this.serializer.setDataTypeChanger(this.getDataTypeChanger());
        this.serializer.setWriter(encoder);
    }

    private void destroySerializer() throws PlatformException {
    }

    private void destroyStreamEncoders() throws PlatformException {
        int protocolTypeCount = this.getProtocolTypeCount();
        OutputStream[] encoders = this.streamEncoders;
        OutputStream encoder = this.streamEncoder;
        try {
            encoder.flush();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing OutputStream failed", (Throwable)ex);
            }
            throw new PlatformException("Flushing OutputStream failed", ex);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                encoder.close();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing OutputStream failed", (Throwable)ex);
                }
                throw new PlatformException("Closing OutputStream failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            for (int i = 0; i < protocolTypeCount; ++i) {
                ((ProtocolEncoder)((Object)encoders[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + encoders[i]));
            }
        }
    }

    private void destroyWriterEncoders() throws PlatformException {
        int protocolTypeCount = this.getProtocolTypeCount();
        Writer[] encoders = this.writerEncoders;
        Writer encoder = this.writerEncoder;
        try {
            encoder.flush();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing Writer failed", (Throwable)ex);
            }
            throw new PlatformException("Flushing Writer failed", ex);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                encoder.close();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing Writer failed", (Throwable)ex);
                }
                throw new PlatformException("Closing Writer failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            for (int i = 0; i < protocolTypeCount; ++i) {
                ((ProtocolEncoder)((Object)encoders[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + encoders[i]));
            }
        }
    }

    private int getIndex() {
        return this.index;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    private String getIndexName(int index) {
        int len = INDEX_NAMES.length;
        if (index >= 0 && index < len) {
            return INDEX_NAMES[index];
        }
        return INDEX_NAMES[len];
    }

    private long getStartTime() {
        return this.startTime;
    }

    private void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private void checkStream() throws PlatformException {
        if (this.out == null && this.writer == null) {
            throw new PlatformException("OutputStream and Writer are null");
        }
    }
}

