/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformResponse;
import com.nexacro.xapi.tx.PlatformUtils;
import com.nexacro.xapi.tx.StreamLog;
import com.nexacro.xapi.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformHttpClient {
    private Log log = LogFactory.getLog((Class)PlatformHttpClient.class);
    private static final String STREAM_LOG_PREFIX = "xapi_http";
    private static final String STREAM_LOG_SUFFIX = "req";
    private String spec;
    private URL url;
    private URLConnection connection;
    private String contentType;
    private String charset;
    private List protocolTypes;
    private boolean verbose;
    private StreamLog streamLog;
    private List requestHeaderKeyList;
    private Map requestHeaderMap;
    private List responseHeaderKeyList;
    private Map responseHeaderMap;

    public PlatformHttpClient(String spec) {
        this(spec, null);
    }

    public PlatformHttpClient(String spec, String contentType) {
        this(spec, contentType, null);
    }

    public PlatformHttpClient(String spec, String contentType, String charset) {
        this.spec = spec;
        this.contentType = contentType;
        this.charset = charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getProtocolType(int index) {
        return this.protocolTypes == null ? null : (String)this.protocolTypes.get(index);
    }

    public void addProtocolType(String protocolType) {
        if (this.protocolTypes == null) {
            this.protocolTypes = new ArrayList();
        }
        if (this.protocolTypes.contains(protocolType)) {
            throw new IllegalArgumentException("Duplicate protocol type: " + protocolType);
        }
        this.protocolTypes.add(protocolType);
    }

    public void removeProtocolType(int index) {
        this.protocolTypes.remove(index);
    }

    public void removeProtocolType(String protocolType) {
        this.protocolTypes.remove(protocolType);
    }

    public boolean containsProtocolType(String protocolType) {
        return this.protocolTypes == null ? false : this.protocolTypes.contains(protocolType);
    }

    public void clearProtocolTypes() {
        if (this.getProtocolTypeCount() > 0) {
            this.protocolTypes.clear();
        }
    }

    public int getProtocolTypeCount() {
        return this.protocolTypes == null ? 0 : this.protocolTypes.size();
    }

    public void addRequestHeader(String key, String value) {
        this.checkRequestHeader(key, value);
        if (this.requestHeaderKeyList == null || this.requestHeaderMap == null) {
            this.requestHeaderKeyList = new ArrayList();
            this.requestHeaderMap = new HashMap();
        }
        this.requestHeaderKeyList.add(key);
        this.requestHeaderMap.put(key, value);
    }

    String getRequestHeaderKey(int index) {
        return this.requestHeaderKeyList == null ? null : (String)this.requestHeaderKeyList.get(index);
    }

    String getRequestHeaderValue(String key) {
        return this.requestHeaderMap == null ? null : (String)this.requestHeaderMap.get(key);
    }

    int getRequestHeaderCount() {
        return this.requestHeaderKeyList == null ? 0 : this.requestHeaderKeyList.size();
    }

    void addResponseHeader(String key, String value) {
        if (key == null) {
            return;
        }
        if (this.responseHeaderKeyList == null || this.responseHeaderMap == null) {
            this.responseHeaderKeyList = new ArrayList();
            this.responseHeaderMap = new HashMap();
        }
        this.responseHeaderKeyList.add(key);
        this.responseHeaderMap.put(key, value);
    }

    String getResponseHeaderKey(int index) {
        return this.responseHeaderKeyList == null ? null : (String)this.responseHeaderKeyList.get(index);
    }

    String getResponseHeaderValue(String key) {
        return this.responseHeaderMap == null ? null : (String)this.responseHeaderMap.get(key);
    }

    int getResponseHeaderCount() {
        return this.responseHeaderKeyList == null ? 0 : this.responseHeaderKeyList.size();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isStreamLogEnabled() {
        return this.streamLog == null ? false : this.streamLog.isLogEnabled();
    }

    public void setStreamLogEnabled(boolean isStreamLogEnabled) {
        this.checkStreamLog();
        this.streamLog.setLogEnabled(isStreamLogEnabled);
    }

    public String getStreamLogDir() {
        return this.streamLog == null ? null : this.streamLog.getLogDir();
    }

    public void setStreamLogDir(String streamLogDir) {
        this.checkStreamLog();
        this.streamLog.setLogDir(streamLogDir);
    }

    public int getStreamLogMaxSize() {
        return this.streamLog == null ? 0 : this.streamLog.getLogMaxSize();
    }

    public void setStreamLogMaxSize(int streamLogMaxSize) {
        this.checkStreamLog();
        this.streamLog.setLogMaxSize(streamLogMaxSize);
    }

    /*
     * Loose catch block
     */
    public void sendData(PlatformData data) throws PlatformException {
        long startTime;
        boolean isVerbose;
        block22: {
            isVerbose = this.isVerbose();
            startTime = System.currentTimeMillis();
            if (isVerbose) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Sending data: " + this.toSimpleString() + ", spec=" + this.spec + ", contentType=" + this.contentType + ", charset=" + this.charset));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending data: " + this.toSimpleString() + ", spec=" + this.spec + ", contentType=" + this.contentType + ", charset=" + this.charset + ", startTime=" + startTime));
            }
            OutputStream out = null;
            try {
                this.init(true);
                out = this.connection.getOutputStream();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("Could not create OutputStream: connection=" + this.connection), (Throwable)ex);
                }
                throw new PlatformException("Could not create OutputStream: connection=" + this.connection, ex);
            }
            PlatformResponse res = new PlatformResponse(out);
            res.setContentType(this.getCurrentContentType());
            res.setCharset(this.getCurrentCharset());
            int protocolTypeCount = this.getProtocolTypeCount();
            for (int i = 0; i < protocolTypeCount; ++i) {
                res.addProtocolType(this.getProtocolType(i));
            }
            res.setData(data);
            res.sendData();
            Object var10_12 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block22;
            }
            catch (IOException ex) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("Closing OutputStream failed: connection=" + this.connection), (Throwable)ex);
                }
                break block22;
            }
            {
                catch (PlatformException ex) {
                    throw new PlatformException("Sending data failed: connection=" + this.connection, ex);
                }
            }
            catch (Throwable throwable) {
                block23: {
                    Object var10_13 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!this.log.isWarnEnabled()) break block23;
                        this.log.warn((Object)("Closing OutputStream failed: connection=" + this.connection), (Throwable)ex);
                    }
                }
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        if (isVerbose) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime + ", endTime=" + endTime));
        }
    }

    /*
     * Loose catch block
     */
    public PlatformData receiveData() throws PlatformException {
        PlatformData platformData;
        InputStream in;
        block22: {
            boolean isVerbose = this.isVerbose();
            long startTime = System.currentTimeMillis();
            if (isVerbose) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Receiving data: " + this.toSimpleString() + ", spec=" + this.spec + ", contentType=" + this.contentType + ", charset=" + this.charset));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Receiving data: " + this.toSimpleString() + ", spec=" + this.spec + ", contentType=" + this.contentType + ", charset=" + this.charset + ", startTime=" + startTime));
            }
            in = null;
            try {
                this.init(false);
                in = this.connection.getInputStream();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("Could not create InputStream: connection=" + this.connection), (Throwable)ex);
                }
                throw new PlatformException("Could not create InputStream: connection=" + this.connection, ex);
            }
            PlatformRequest req = new PlatformRequest(in);
            req.setContentType(this.getCurrentContentType());
            req.setCharset(this.getCurrentCharset());
            int protocolTypeCount = this.getProtocolTypeCount();
            for (int i = 0; i < protocolTypeCount; ++i) {
                req.addProtocolType(this.getProtocolType(i));
            }
            if (this.streamLog != null && this.streamLog.isLogEnabled()) {
                req.setStreamLogEnabled(true);
                req.setStreamLogDir(this.streamLog.getLogDir());
                req.setStreamLogMaxSize(this.streamLog.getLogMaxSize());
                req.setStreamLogPrefix(STREAM_LOG_PREFIX);
                req.setStreamLogSuffix(STREAM_LOG_SUFFIX);
            }
            req.receiveData();
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            if (isVerbose) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Received data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime + ", endTime=" + endTime));
            }
            platformData = req.getData();
            Object var13_12 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex2) {
                if (!this.log.isWarnEnabled()) break block22;
                this.log.warn((Object)("Closing InputStream failed: connection=" + this.connection), (Throwable)ex2);
            }
        }
        this.close();
        return platformData;
        catch (PlatformException ex) {
            try {
                throw new PlatformException("Receiving data failed: connection=" + this.connection, ex);
            }
            catch (Throwable throwable) {
                block23: {
                    Object var13_13 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex2) {
                        if (!this.log.isWarnEnabled()) break block23;
                        this.log.warn((Object)("Closing InputStream failed: connection=" + this.connection), (Throwable)ex2);
                    }
                }
                this.close();
                throw throwable;
            }
        }
    }

    public void close() {
        this.close(this.connection);
        this.connection = null;
    }

    void init(boolean isPost) throws IOException {
        if (this.url == null) {
            this.url = new URL(this.spec);
        }
        if (this.connection == null) {
            this.connection = this.open(this.url, isPost);
        }
    }

    URLConnection open(URL url, boolean isPost) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String httpContentType = this.getHttpContentType();
        conn.setRequestProperty("Content-Type", httpContentType);
        int headerCount = this.getRequestHeaderCount();
        for (int i = 0; i < headerCount; ++i) {
            String key = this.getRequestHeaderKey(i);
            String value = this.getRequestHeaderValue(key);
            conn.setRequestProperty(key, value);
        }
        if (isPost) {
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
        } else {
            conn.setRequestMethod("GET");
        }
        return conn;
    }

    void close(URLConnection conn) {
        int headerCount;
        if (conn == null) {
            return;
        }
        Map<String, List<String>> headerMap = conn.getHeaderFields();
        int n = headerCount = headerMap == null ? 0 : headerMap.size();
        if (headerCount > 0) {
            Iterator<Map.Entry<String, List<String>>> iter = headerMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, List<String>> map = iter.next();
                String key = map.getKey();
                if (key == null) continue;
                String value = conn.getHeaderField(key);
                this.addResponseHeader(key, value);
            }
        }
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    String toSimpleString() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name + "@" + Integer.toHexString(this.hashCode());
        }
        return name.substring(index + 1) + "@" + Integer.toHexString(this.hashCode());
    }

    private String getHttpContentType() {
        String contentType = this.getCurrentContentType();
        String charset = this.getCurrentCharset();
        return PlatformUtils.getHttpContentType(contentType, charset);
    }

    private String getCurrentContentType() {
        String contentType = this.getContentType();
        return StringUtils.isEmpty(contentType) ? this.getDefaultContentType() : contentType;
    }

    private String getCurrentCharset() {
        String charset = this.getCharset();
        return StringUtils.isEmpty(charset) ? this.getDefaultCharset() : charset;
    }

    private String getDefaultContentType() {
        return "PlatformXml";
    }

    private String getDefaultCharset() {
        return "UTF-8";
    }

    private void checkStreamLog() {
        if (this.streamLog == null) {
            this.streamLog = new StreamLog();
        }
    }

    private void checkRequestHeader(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("No header key specified");
        }
        if ("".equals(key)) {
            throw new IllegalArgumentException("No header key specified");
        }
        if (key.charAt(0) == ' ' && "".equals(key.trim())) {
            throw new IllegalArgumentException("Invalid header key: \"" + key + "\"");
        }
        if ("content-type".equals(key.toLowerCase())) {
            throw new IllegalArgumentException("Invalid header key: \"" + key + "\"");
        }
    }
}

