/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataSerializerFactory;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformTransaction;
import com.nexacro.xapi.tx.ProtocolEncoder;
import com.nexacro.xapi.tx.ProtocolFilterFactory;
import com.nexacro.xapi.util.PlatformGlobals;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformResponse
extends PlatformTransaction {
    private Log log = LogFactory.getLog((Class)PlatformResponse.class);
    private static final String IO_CLOSE_KEY = "platform.tx.PlatformResponse.ioclose";
    private OutputStream out;
    private Writer writer;

    public PlatformResponse() {
    }

    public PlatformResponse(String contentType) {
        this(contentType, null);
    }

    public PlatformResponse(String contentType, String charset) {
        super(contentType, charset);
    }

    public PlatformResponse(PlatformRequest req) {
        this(req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public PlatformResponse(OutputStream out) {
        this(out, (String)null);
    }

    public PlatformResponse(OutputStream out, String contentType) {
        this(out, contentType, null);
    }

    public PlatformResponse(OutputStream out, String contentType, String charset) {
        super(contentType, charset);
        this.out = out;
    }

    public PlatformResponse(OutputStream out, PlatformRequest req) {
        this(out, req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public PlatformResponse(Writer writer) {
        this(writer, (String)null);
    }

    public PlatformResponse(Writer writer, String contentType) {
        this(writer, contentType, null);
    }

    public PlatformResponse(Writer writer, String contentType, String charset) {
        super(contentType, charset);
        this.writer = writer;
    }

    public PlatformResponse(Writer writer, PlatformRequest req) {
        this(writer, req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public void sendData() throws PlatformException {
        this.checkLicense();
        boolean isVerbose = this.isCurrentVerbose();
        long startTime = System.currentTimeMillis();
        if (isVerbose) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset()));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ", startTime=" + startTime));
        }
        this.checkData();
        this.checkStream();
        if (this.useOutputStream()) {
            this.writeTo(this.getOutputStream());
        } else {
            this.writeTo(this.getWriter());
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        if (isVerbose) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime + ", endTime=" + endTime));
        }
    }

    void writeTo(OutputStream out) throws PlatformException {
        int i;
        String contentType = this.getCurrentContentType();
        DataSerializer serializer = DataSerializerFactory.getSerializer(contentType);
        if (serializer == null) {
            throw new PlatformException("Could not create DataSerializer: " + contentType);
        }
        int protocolTypeCount = this.getProtocolTypeCount();
        OutputStream[] encoders = null;
        OutputStream encoder = out;
        if (protocolTypeCount > 0) {
            encoders = new OutputStream[protocolTypeCount];
            for (i = 0; i < protocolTypeCount; ++i) {
                String protocolType = this.getProtocolType(i);
                encoders[i] = encoder = ProtocolFilterFactory.getEncoder(protocolType, encoder);
                if (encoder != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + protocolType);
            }
        }
        serializer.writeData(encoder, this.getData(), this.getDataTypeChanger(), this.getCurrentCharset());
        try {
            encoder.flush();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing OutputStream failed", (Throwable)ex);
            }
            throw new PlatformException("Flushing OutputStream failed", ex);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                encoder.close();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing OutputStream failed", (Throwable)ex);
                }
                throw new PlatformException("Closing OutputStream failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            for (i = 0; i < protocolTypeCount; ++i) {
                ((ProtocolEncoder)((Object)encoders[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + encoders[i]));
            }
        }
    }

    void writeTo(Writer writer) throws PlatformException {
        int i;
        String contentType = this.getCurrentContentType();
        DataSerializer serializer = DataSerializerFactory.getSerializer(contentType);
        if (serializer == null) {
            throw new PlatformException("Could not create DataSerializer: " + contentType);
        }
        int protocolTypeCount = this.getProtocolTypeCount();
        Writer[] encoders = null;
        Writer encoder = writer;
        if (protocolTypeCount > 0) {
            encoders = new Writer[protocolTypeCount];
            for (i = 0; i < protocolTypeCount; ++i) {
                String protocolType = this.getProtocolType(i);
                encoders[i] = encoder = ProtocolFilterFactory.getEncoder(protocolType, encoder);
                if (encoder != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + protocolType);
            }
        }
        serializer.writeData(encoder, this.getData(), this.getDataTypeChanger(), this.getCurrentCharset());
        try {
            encoder.flush();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing Writer failed", (Throwable)ex);
            }
            throw new PlatformException("Flushing Writer failed", ex);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                encoder.close();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing Writer failed", (Throwable)ex);
                }
                throw new PlatformException("Closing Writer failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            for (i = 0; i < protocolTypeCount; ++i) {
                ((ProtocolEncoder)((Object)encoders[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + encoders[i]));
            }
        }
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setOutputStream(OutputStream out) {
        this.out = out;
    }

    Writer getWriter() {
        return this.writer;
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    boolean useOutputStream() {
        return this.writer == null;
    }

    private void checkData() throws PlatformException {
        if (this.getData() == null) {
            throw new PlatformException("PlatformData is null");
        }
    }

    private void checkStream() throws PlatformException {
        if (this.out == null && this.writer == null) {
            throw new PlatformException("OutputStream and Writer are null");
        }
    }
}

