/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.StreamLog;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StreamLogReader
extends Reader {
    private Reader in;
    private StreamLog streamLog;
    private CharArrayWriter buffer;

    public StreamLogReader(Reader in, StreamLog streamLog) {
        this.in = in;
        this.streamLog = streamLog;
    }

    public int read() throws IOException {
        int ch = this.in.read();
        if (ch != -1 && this.checkBuffer(1)) {
            this.buffer.write(ch);
        }
        return ch;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int n = this.in.read(cbuf, off, len);
        if (n > 0 && this.checkBuffer(n)) {
            this.buffer.write(cbuf, off, n);
        }
        return n;
    }

    public long skip(long n) throws IOException {
        long remaining;
        int nr;
        if (n <= 0L) {
            return 0L;
        }
        char[] skipBuffer = new char[2048];
        for (remaining = n; remaining > 0L && (nr = this.in.read(skipBuffer, 0, (int)Math.min(2048L, remaining))) >= 0; remaining -= (long)nr) {
            if (nr <= 0 || !this.checkBuffer(nr)) continue;
            this.buffer.write(skipBuffer, 0, nr);
        }
        return n - remaining;
    }

    public boolean ready() throws IOException {
        return this.in.ready();
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStreamLog() throws IOException {
        File parent;
        Log log = LogFactory.getLog((Class)StreamLogReader.class);
        String path = this.streamLog.getLogPath();
        File file = new File(path);
        boolean exists = file.exists();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing stream: path=" + path + ", exists=" + exists));
        }
        if (exists) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            path = this.streamLog.getLogPath();
            file = new File(path);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing stream: path=" + path));
            }
        }
        if (!(parent = file.getParentFile()).exists()) {
            parent.mkdirs();
        }
        FileWriter out = new FileWriter(file);
        try {
            if (this.buffer == null) {
                if (this.in == null) {
                    out.write("The buffer does not exist. in=null");
                } else if (this.in.ready()) {
                    this.copy(this.in, out);
                } else {
                    out.write("The buffer does not exist. in.ready()=false");
                }
            } else {
                out.write(this.buffer.toCharArray());
                if (this.streamLog.isExceededSize()) {
                    int maxSize = this.streamLog.getLogMaxSize();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The buffer was exceeded. maxSize=" + maxSize));
                    }
                    out.write(System.getProperty("line.separator"));
                    out.write("The buffer was exceeded. maxSize=" + maxSize);
                } else if (this.in.ready()) {
                    this.copy(this.in, out);
                }
            }
        }
        finally {
            out.close();
        }
    }

    private long copy(Reader in, Writer out) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private boolean checkBuffer(int length) {
        if (this.streamLog.isExceededSize()) {
            return false;
        }
        if (this.buffer == null) {
            this.buffer = new CharArrayWriter();
        }
        if (this.buffer.size() + length > this.streamLog.getLogMaxSize()) {
            this.streamLog.setExceededSize(true);
            return false;
        }
        return true;
    }
}

