/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class EmptyElementReader
extends FilterReader {
    private Log log = LogFactory.getLog((Class)EmptyElementReader.class);
    private static final char[] EMPTY_SUFFIX = " empty=\"true\"/>".toCharArray();
    private char[] buffer;
    private int pos;

    public EmptyElementReader(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        throw new IOException("Unsupported operation");
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.buffer == null || this.buffer.length - this.pos <= 0) {
            return this.readFromSource(cbuf, off, len);
        }
        return this.readFromBuffer(cbuf, off, len);
    }

    private int readFromBuffer(char[] cbuf, int off, int len) throws IOException {
        int remaining = this.buffer.length - this.pos;
        int n = remaining < len ? remaining : len;
        System.arraycopy(this.buffer, this.pos, cbuf, off, n);
        this.pos += n;
        return n;
    }

    private int readFromSource(char[] cbuf, int off, int len) throws IOException {
        int n = super.read(cbuf, off, len);
        if (n <= 0) {
            return n;
        }
        int index = this.indexOfEmptyElement(cbuf, off, n);
        if (index == -1) {
            int next;
            if (cbuf[off + n - 1] == '/' && (next = super.read()) != -1) {
                if (next == 62) {
                    this.buffer = EMPTY_SUFFIX;
                    this.pos = 0;
                    --n;
                } else {
                    this.buffer = new char[]{(char)next};
                    this.pos = 0;
                }
            }
            return n;
        }
        if (index == 0) {
            this.initBuffer(cbuf, off, n, index);
            System.arraycopy(this.buffer, 0, cbuf, off, n);
            this.pos = n;
            return n;
        }
        this.initBuffer(cbuf, off, n, index);
        return index - off;
    }

    private void initBuffer(char[] cbuf, int off, int n, int index) throws IOException {
        int offset;
        int count;
        char[] emptySuffix = EMPTY_SUFFIX;
        int lastIndex = off + n;
        int emptyIndex = index;
        int bufferSize = lastIndex - index + emptySuffix.length * 4;
        CharArrayWriter out = new CharArrayWriter(bufferSize);
        out.write(emptySuffix);
        while ((count = lastIndex - (offset = emptyIndex + 2)) != 0) {
            emptyIndex = this.indexOfEmptyElement(cbuf, offset, count);
            if (emptyIndex == -1) {
                char last = cbuf[offset + count - 1];
                if (last == '/') {
                    int next = super.read();
                    if (next == -1) {
                        out.write(cbuf, offset, count);
                        break;
                    }
                    if (next == 62) {
                        out.write(cbuf, offset, count - 1);
                        out.write(emptySuffix);
                        break;
                    }
                    out.write(cbuf, offset, count);
                    out.write(next);
                    break;
                }
                out.write(cbuf, offset, count);
                break;
            }
            out.write(cbuf, offset, emptyIndex - offset);
            out.write(emptySuffix);
        }
        out.close();
        this.buffer = out.toCharArray();
        this.pos = 0;
    }

    private int indexOfEmptyElement(char[] buffer, int offset, int count) {
        int last = offset + count - 1;
        for (int i = offset; i < last; ++i) {
            if (buffer[i] != '/' || buffer[i + 1] != '>') continue;
            return i;
        }
        return -1;
    }
}

