/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MiBinaryDataDeserializer
implements DataDeserializer {
    private Log log = LogFactory.getLog((Class)MiBinaryDataDeserializer.class);
    private static final String CHARSET = "UTF-8";
    private static final double HALF_SECOND = 5.787037037037037E-6;
    private static final long MIN_DATE = 0L;
    private static final long MAX_DATE = 3652424L;
    private static final int[] MONTH_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int BUFFER_SIZE = 4096;
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    private byte[] buffer;

    public void setProperty(String key, Object value) {
    }

    public PlatformData readData(InputStream in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this + ", charset=" + charset));
        }
        try {
            return this.read(in, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "MiBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    public PlatformData readData(Reader in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        String contentType = "MiBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + contentType);
    }

    private PlatformData read(InputStream in, DataTypeChanger dataTypeChanger) throws IOException {
        DataInputStream stream = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        PlatformData data = new PlatformData();
        short count = stream.readShort();
        this.readVariableList(stream, data, dataTypeChanger);
        for (int i = 0; i < count - 1; ++i) {
            this.readDataSet(stream, data, dataTypeChanger, i);
        }
        this.readUnknown(stream);
        return data;
    }

    private void readVariableList(DataInputStream in, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        short mark = in.readShort();
        short version = in.readShort();
        int size = this.readLength(in);
        int count = in.readShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading VariableList: mark=0x" + Integer.toHexString(mark) + ", version=" + version + ", size=" + size + ", count=" + count));
        }
        if (mark != -496) {
            throw new IOException("Invalid VariableList mark: 0x" + Integer.toHexString(mark));
        }
        if (version != 4000) {
            throw new IOException("Invalid version: " + version);
        }
        for (int i = 0; i < count; ++i) {
            this.readVariable(in, data, dataTypeChanger, i);
        }
    }

    private void readVariable(DataInputStream in, PlatformData data, DataTypeChanger dataTypeChanger, int index) throws IOException {
        short length = in.readShort();
        String name = new String(this.readBytes(in, length), CHARSET);
        short type = in.readShort();
        int dataType = this.variantTypeToDataType(type);
        Object value = this.readValue(in, type);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Variable: index=" + index + ", length=" + length + ", name=" + name + ", type=" + type + ", dataType=" + dataType));
        }
        Variable var = new Variable(name, dataType);
        var.set(value);
        data.addVariable(var);
    }

    private void readDataSet(DataInputStream in, PlatformData data, DataTypeChanger dataTypeChanger, int index) throws IOException {
        short mark = this.readShort(in);
        if (mark == -1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Reading DataSet: mark=-1");
            }
            return;
        }
        short version = in.readShort();
        int size = this.readLength(in);
        short length = in.readShort();
        String name = new String(this.readBytes(in, length), CHARSET);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading DataSet: index=" + index + ", mark=0x" + Integer.toHexString(mark) + ", version=" + version + ", size=" + size + ", name=" + name));
        }
        if (mark != -511) {
            throw new IOException("Invalid DataSet mark: 0x" + Integer.toHexString(mark));
        }
        if (version != 4000) {
            throw new IOException("Invalid version: " + version);
        }
        DataSet ds = new DataSet(name);
        boolean isStoreDataChanges = ds.isStoreDataChanges();
        boolean isCheckingSetterDataIndex = ds.isCheckingSetterDataIndex();
        if (isStoreDataChanges) {
            ds.stopStoreDataChanges();
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(false);
        }
        this.readConstantColumnHeaders(in, ds);
        this.readDefaultColumnHeaders(in, ds);
        int[] dataTypes = this.getSourceDataTypes(ds, dataTypeChanger);
        this.readDataRows(in, ds, dataTypes);
        if (isStoreDataChanges) {
            ds.startStoreDataChanges(true);
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(true);
        }
        data.addDataSet(ds);
    }

    private void readDefaultColumnHeaders(DataInputStream in, DataSet ds) throws IOException {
        int count = in.readShort();
        for (int i = 0; i < count; ++i) {
            short length = in.readShort();
            String name = new String(this.readBytes(in, length), CHARSET);
            short type = in.readShort();
            int dataType = this.columnTypeToDataType(type);
            short dataSize = in.readShort();
            short attr = in.readShort();
            if ((attr & 0xF0) == 96) {
                short sumLength = in.readShort();
                String sumStr = new String(this.readBytes(in, sumLength), CHARSET);
                ds.addColumn(name, dataType, (int)dataSize);
                continue;
            }
            ds.addColumn(name, dataType, (int)dataSize);
        }
    }

    private void readConstantColumnHeaders(DataInputStream in, DataSet ds) throws IOException {
        short mark = in.readShort();
        short version = in.readShort();
        int size = this.readLength(in);
        int count = in.readShort();
        if (mark != -496) {
            throw new IOException("Invalid ConstantColumnHeader mark: 0x" + Integer.toHexString(mark));
        }
        if (version != 4000) {
            throw new IOException("Invalid version: " + version);
        }
        for (int i = 0; i < count; ++i) {
            short length = in.readShort();
            String name = new String(this.readBytes(in, length), CHARSET);
            short type = in.readShort();
            int dataType = this.variantTypeToDataType(type);
            int dataSize = DataTypes.getDefaultSize(dataType);
            Object value = this.readValue(in, type);
            ds.addConstantColumn(name, dataType, dataSize, value);
        }
    }

    private void readDataRows(DataInputStream in, DataSet ds, int[] dataTypes) throws IOException {
        int i;
        int[] indexes = this.getColumnIndexes(ds);
        int[] targetDataTypes = new int[indexes.length];
        for (i = 0; i < targetDataTypes.length; ++i) {
            targetDataTypes[i] = ds.getColumn(indexes[i]).getDataType();
        }
        i = 0;
        while (true) {
            File file;
            int dataType;
            int targetDataType;
            int index;
            int j;
            int size = this.readLength(in);
            short rowType = in.readShort();
            if (size == 0 && rowType == 0) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("Finish reading rows: i=" + i + ", size=" + size + ", rowType=0x" + Integer.toHexString(rowType)));
                break;
            }
            int count = in.readShort();
            if (rowType == 8) {
                int removedRow = ds.newRemovedRow();
                for (j = 0; j < count; ++j) {
                    index = indexes[j];
                    targetDataType = targetDataTypes[j];
                    dataType = dataTypes[index];
                    Object value = null;
                    if (targetDataType == 13) {
                        if (dataType == 2 || dataType == 12) {
                            file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                            this.readValueToFile(in, file);
                            value = file.getAbsolutePath();
                        }
                    } else {
                        value = this.readValue(in);
                    }
                    ds.setRemovedData(removedRow, index, value);
                }
            } else {
                int row = ds.newRow();
                for (j = 0; j < count; ++j) {
                    index = indexes[j];
                    targetDataType = targetDataTypes[j];
                    dataType = dataTypes[index];
                    Object value = null;
                    if (targetDataType == 13) {
                        if (dataType == 2 || dataType == 12) {
                            file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                            this.readValueToFile(in, file);
                            value = file.getAbsolutePath();
                        }
                    } else {
                        value = this.readValue(in);
                    }
                    ds.set(row, index, value);
                }
                if (rowType != 0 && rowType != 1) {
                    if (rowType == 2) {
                        ds.setRowType(row, 1);
                    } else if (rowType == 4) {
                        ds.setRowType(row, 2);
                        short rowIndex = in.readShort();
                        if (rowIndex >= 0) {
                            for (int j2 = 0; j2 < count; ++j2) {
                                int index2 = indexes[j2];
                                int targetDataType2 = targetDataTypes[j2];
                                int dataType2 = dataTypes[index2];
                                Object value = null;
                                if (targetDataType2 == 13) {
                                    if (dataType2 == 2 || dataType2 == 12) {
                                        File file2 = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                        this.readValueToFile(in, file2);
                                        value = file2.getAbsolutePath();
                                    }
                                } else {
                                    value = this.readValue(in);
                                }
                                ds.setSavedData(row, index2, value);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private Object readValue(DataInputStream in) throws IOException {
        return this.readValue(in, in.readShort());
    }

    private Object readValue(DataInputStream in, short type) throws IOException {
        switch (type) {
            case 0: {
                return null;
            }
            case 3: {
                int intValue = in.readInt();
                return new Integer(intValue);
            }
            case 5: {
                double doubleValue = in.readDouble();
                return new Double(doubleValue);
            }
            case 6: {
                int hiValue = in.readInt();
                int lowValue = in.readInt();
                return new BigDecimal(this.toDecimalStr(hiValue, lowValue));
            }
            case 7: {
                double dateValue = in.readDouble();
                return this.toDate(dateValue);
            }
            case 8: {
                int strLength = this.readLength(in);
                String strValue = new String(this.readBytes(in, strLength), CHARSET);
                return strValue;
            }
            case 13: {
                int binLength = this.readLength(in);
                byte[] binValue = this.readBytes(in, binLength);
                return binValue;
            }
        }
        throw new IOException("Invalid data type: 0x" + Integer.toHexString(type));
    }

    private void readValueToFile(DataInputStream in, File file) throws IOException {
        this.readValueToFile(in, in.readShort(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readValueToFile(DataInputStream in, short type, File file) throws IOException {
        if (type != 8 && type != 13) throw new IOException("Invalid data type: 0x" + Integer.toHexString(type));
        int length = this.readLength(in);
        byte[] buffer = this.getBuffer();
        int bufferLength = buffer.length;
        int offset = 0;
        FileOutputStream out = new FileOutputStream(file);
        try {
            int n;
            do {
                int count;
                if ((count = length - offset) > bufferLength) {
                    count = bufferLength;
                }
                if ((n = in.read(buffer, 0, count)) == -1) {
                    throw new EOFException();
                }
                out.write(buffer, 0, n);
            } while ((offset += n) != length);
            if (!this.log.isDebugEnabled()) return;
            this.log.debug((Object)("Saving data to file: type=" + type + ", file=" + file));
            return;
        }
        finally {
            out.close();
        }
    }

    private int readLength(DataInputStream in) throws IOException {
        int length = in.readShort();
        if ((length & 0x8000) == 0) {
            return length;
        }
        length = length << 16 & 0xFFFF0000 | in.readShort() & 0xFFFF;
        return length &= Integer.MAX_VALUE;
    }

    private byte[] readBytes(DataInputStream in, int count) throws IOException {
        int n;
        byte[] buffer = new byte[count];
        int offset = 0;
        while ((offset += (n = in.read(buffer, offset, count - offset))) != count) {
        }
        return buffer;
    }

    private int[] getSourceDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            String columnName;
            String dsName;
            int dataType;
            int sourceDataType;
            ColumnHeader header = ds.getColumn(i);
            dataTypes[i] = sourceDataType = header.getDataType();
            if (dataTypeChanger == null || (dataType = dataTypeChanger.getDataType(dsName = ds.getAlias(), columnName = header.getName(), sourceDataType)) == sourceDataType) continue;
            int dataSize = header.getDataSize();
            if (header.isConstant()) {
                Object value = ((ConstantColumnHeader)header).getValue();
                ConstantColumnHeader newHeader = new ConstantColumnHeader(columnName, value, dataType, dataSize);
                ds.setColumn(i, newHeader);
                continue;
            }
            ColumnHeader newHeader = new ColumnHeader(columnName, dataType, dataSize);
            ds.setColumn(i, newHeader);
        }
        return dataTypes;
    }

    private int[] getColumnIndexes(DataSet ds) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        int count = ds.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            ColumnHeader header = ds.getColumn(i2);
            if (header.isConstant()) continue;
            list.add(header.getName());
        }
        ArrayList<String> sorted = new ArrayList<String>();
        Iterator iter = list.iterator();
        block1: while (iter.hasNext()) {
            String name = (String)iter.next();
            int size = sorted.size();
            for (i = 0; i < size; ++i) {
                String str = (String)sorted.get(i);
                if (name.compareToIgnoreCase(str) >= 0) continue;
                sorted.add(i, name);
                continue block1;
            }
            sorted.add(name);
        }
        int len = sorted.size();
        int[] indexes = new int[len];
        for (i = 0; i < len; ++i) {
            indexes[i] = ds.indexOfColumn(sorted.get(i).toString());
        }
        return indexes;
    }

    private int variantTypeToDataType(short type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 2;
            }
            case 13: {
                return 12;
            }
        }
        return 0;
    }

    private int columnTypeToDataType(short type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 12;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
        }
        return 0;
    }

    private void readUnknown(DataInputStream in) throws IOException {
        int available = in.available();
        if (available > 0) {
            int i = 0;
            while (true) {
                int ch = in.read();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unknown data: ch[" + i + "]=0x" + Integer.toHexString(ch)));
                }
                if (ch == -1) break;
                ++i;
            }
        }
    }

    private short readShort(InputStream in) throws IOException {
        int second;
        int first = in.read();
        if ((first | (second = in.read())) < 0) {
            return -1;
        }
        return (short)((first << 8) + (second << 0));
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private String toDecimalStr(int hiValue, int lowValue) {
        long hiLong = 0xFFFFFFFFL & (long)hiValue;
        long loLong = 0xFFFFFFFFL & (long)lowValue;
        long value = hiLong << 32 | loLong;
        String str = String.valueOf(value);
        int length = str.length();
        str = length < 4 ? "0" : (length == 4 ? "0." + str : str.substring(0, length - 4) + '.' + str.substring(length - 4));
        return str;
    }

    private Date toDate(double value) {
        int Thour;
        int Tmin;
        int Tsec;
        long n4Yr;
        long n4Day;
        long n4Years;
        if (value > 3652424.0 || value < 0.0) {
            return null;
        }
        boolean bLeap4 = true;
        double dblDate = value;
        long nDaysAbsolute = (long)(dblDate += value > 0.0 ? 5.787037037037037E-6 : -5.787037037037037E-6);
        dblDate = Math.abs(dblDate);
        long nSecsInDay = (long)((dblDate - Math.floor(dblDate)) * 86400.0);
        long n400Years = nDaysAbsolute / 146097L;
        long n400Century = ((nDaysAbsolute %= 146097L) - 1L) / 36524L;
        if (n400Century != 0L) {
            n4Years = ((nDaysAbsolute = (nDaysAbsolute - 1L) % 36524L) + 1L) / 1461L;
            if (n4Years != 0L) {
                n4Day = (nDaysAbsolute + 1L) % 1461L;
            } else {
                bLeap4 = false;
                n4Day = nDaysAbsolute;
            }
        } else {
            n4Years = nDaysAbsolute / 1461L;
            n4Day = nDaysAbsolute % 1461L;
        }
        if (bLeap4) {
            n4Yr = (n4Day - 1L) / 365L;
            if (n4Yr != 0L) {
                n4Day = (n4Day - 1L) % 365L;
            }
        } else {
            n4Yr = n4Day / 365L;
            n4Day %= 365L;
        }
        int Tyear = (int)(n400Years * 400L + n400Century * 100L + n4Years * 4L + n4Yr);
        Calendar calendar = Calendar.getInstance();
        if (n4Yr == 0L && bLeap4) {
            if (n4Day == 59L) {
                int Thour2;
                int Tmin2;
                int Tsec2;
                int Tmon = 2;
                int Tmday = 29;
                if (nSecsInDay == 0L) {
                    Tsec2 = 0;
                    Tmin2 = 0;
                    Thour2 = 0;
                } else {
                    Tsec2 = (int)nSecsInDay % 60;
                    long nMinutesInDay = nSecsInDay / 60L;
                    Tmin2 = (int)nMinutesInDay % 60;
                    Thour2 = (int)nMinutesInDay / 60;
                }
                calendar.set(1, Tyear);
                calendar.set(2, Tmon - 1);
                calendar.set(5, Tmday);
                calendar.set(11, Thour2);
                calendar.set(12, Tmin2);
                calendar.set(13, Tsec2);
                return calendar.getTime();
            }
            if (n4Day >= 60L) {
                --n4Day;
            }
        }
        int Tmon = (int)(++n4Day >> 5) + 1;
        while (n4Day > (long)MONTH_DAYS[Tmon]) {
            ++Tmon;
        }
        int Tmday = (int)(n4Day - (long)MONTH_DAYS[Tmon - 1]);
        if (nSecsInDay == 0L) {
            Tsec = 0;
            Tmin = 0;
            Thour = 0;
        } else {
            Tsec = (int)nSecsInDay % 60;
            long nMinutesInDay = nSecsInDay / 60L;
            Tmin = (int)nMinutesInDay % 60;
            Thour = (int)nMinutesInDay / 60;
        }
        calendar.set(1, Tyear);
        calendar.set(2, Tmon - 1);
        calendar.set(5, Tmday);
        calendar.set(11, Thour);
        calendar.set(12, Tmin);
        calendar.set(13, Tsec);
        return calendar.getTime();
    }
}

