/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.EmptyElementInputStream;
import com.nexacro.xapi.tx.impl.EmptyElementReader;
import com.nexacro.xapi.util.SequenceReader;
import com.nexacro.xapi.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MiXmlDataDeserializer
extends DefaultHandler
implements DataDeserializer {
    private Log log = LogFactory.getLog((Class)MiXmlDataDeserializer.class);
    private static final boolean CHECK_EMPTY_ELEMENT = true;
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    private static final int INDEX_UNDEFINED = 0;
    private static final int INDEX_VARIABLE = 1;
    private static final int INDEX_COLUMN_HEADER = 2;
    private static final int INDEX_CONSTANT_COLUMN_HEADER = 3;
    private static final int INDEX_DATA_ROW = 4;
    private static final int INDEX_DATA_CELL = 5;
    private static final int INDEX_SAVED_DATA_ROW = 6;
    private static final int INDEX_SAVED_DATA_CELL = 7;
    private int index;
    private PlatformData data;
    private Variable var;
    private DataSet ds;
    private int[] dataTypes;
    private boolean isStoreDataChanges;
    private boolean isCheckingSetterDataIndex;
    private ColumnHeader header;
    private String rowType;
    private String name;
    private StringBuffer value = new StringBuffer();
    private boolean isEmpty;
    private DataTypeChanger dataTypeChanger;

    public void setProperty(String key, Object value) {
    }

    public PlatformData readData(InputStream in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this + ", charset=" + charset));
        }
        try {
            byte[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            if (encoding == null) {
                encoding = charset;
            }
            InputStream ein = in;
            ein = new EmptyElementInputStream(in);
            ein = new BufferedInputStream(ein);
            SequenceInputStream sin = new SequenceInputStream(new ByteArrayInputStream(header), ein);
            InputStreamReader reader = new InputStreamReader((InputStream)sin, encoding);
            InputSource source = new InputSource(reader);
            source.setEncoding(encoding);
            return this.read(source, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    public PlatformData readData(Reader in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this + ", charset=" + charset));
        }
        try {
            char[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            Reader ein = in;
            ein = new EmptyElementReader(in);
            ein = new BufferedReader(ein);
            SequenceReader sin = new SequenceReader(new CharArrayReader(header), ein);
            InputSource source = new InputSource(sin);
            if (encoding == null) {
                source.setEncoding(charset);
            } else {
                source.setEncoding(encoding);
            }
            return this.read(source, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    private PlatformData read(InputSource source, DataTypeChanger dataTypeChanger) throws IOException, PlatformException {
        try {
            this.dataTypeChanger = dataTypeChanger;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(source, (DefaultHandler)this);
            return this.getData();
        }
        catch (ParserConfigurationException ex) {
            String contentType = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
        catch (SAXException ex) {
            String contentType = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    private byte[] readHeader(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        do {
            ch = in.read();
            out.write(ch);
        } while (ch != -1 && ch != 62);
        return out.toByteArray();
    }

    private char[] readHeader(Reader in) throws IOException {
        int ch;
        CharArrayWriter out = new CharArrayWriter();
        do {
            ch = in.read();
            out.write(ch);
        } while (ch != -1 && ch != 62);
        return out.toCharArray();
    }

    private String findEncoding(byte[] header) {
        return this.findEncoding(new String(header));
    }

    private String findEncoding(char[] header) {
        return this.findEncoding(new String(header));
    }

    private String findEncoding(String header) {
        String encoding;
        int end;
        int begin;
        int separator;
        int index = header.indexOf("encoding");
        if (index != -1 && (separator = header.indexOf(61, index + 8)) != -1 && (begin = header.indexOf(34, separator + 1)) != -1 && (end = header.indexOf(34, ++begin)) != -1 && (encoding = header.substring(begin, end).trim()).length() > 0) {
            return encoding;
        }
        return null;
    }

    PlatformData getData() {
        return this.data;
    }

    void setData(PlatformData data) {
        this.data = data;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("record".equals(qName)) {
            if (this.dataTypes == null) {
                this.dataTypes = this.getSourceDataTypes(this.ds, this.dataTypeChanger);
            }
            this.rowType = attributes.getValue("type");
            this.ds.newRow();
            this.index = 4;
        } else if ("org_record".equals(qName)) {
            this.index = 6;
        } else if ("colinfo".equals(qName)) {
            this.header = this.createColumnHeader(attributes);
            this.index = 2;
        } else if ("param".equals(qName)) {
            String name = attributes.getValue("id");
            int type = this.toDataType(attributes.getValue("type"));
            this.isEmpty = "true".equals(attributes.getValue("empty"));
            this.var = new Variable(name, type);
            this.index = 1;
        } else if ("column".equals(qName)) {
            this.header = this.createColumnHeader(attributes);
            this.isEmpty = "true".equals(attributes.getValue("empty"));
            this.index = 3;
        } else if ("dataset".equals(qName)) {
            String name = attributes.getValue("id");
            this.ds = new DataSet(name);
            this.isStoreDataChanges = this.ds.isStoreDataChanges();
            this.isCheckingSetterDataIndex = this.ds.isCheckingSetterDataIndex();
            if (this.isStoreDataChanges) {
                this.ds.stopStoreDataChanges();
            }
            if (this.isCheckingSetterDataIndex) {
                this.ds.setCheckingSetterDataIndex(false);
            }
        } else if (!"params".equals(qName)) {
            if ("root".equals(qName)) {
                this.data = new PlatformData();
            } else {
                if (this.index == 4) {
                    this.name = qName;
                    this.index = 5;
                } else if (this.index == 6) {
                    this.name = qName;
                    this.index = 7;
                }
                this.isEmpty = "true".equals(attributes.getValue("empty"));
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(this.name)) {
            if (this.index == 5) {
                if (!this.isEmpty) {
                    int columnIndex = this.ds.indexOfColumn(this.name);
                    int dataType = this.dataTypes[columnIndex];
                    int targetDataType = this.ds.getColumn(columnIndex).getDataType();
                    if (targetDataType == 13) {
                        if (dataType == 2 || dataType == 12) {
                            try {
                                File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                this.writeValueToFile(Base64.decode(this.value.toString()), file);
                                this.ds.set(this.ds.getRowCount() - 1, this.name, file.getAbsolutePath());
                            }
                            catch (IOException ex) {
                                int rowIndex = this.ds.getRowCount() - 1;
                                if (this.log.isErrorEnabled()) {
                                    this.log.error((Object)("Could not save: rowIndex=" + rowIndex + ", columnIndex=" + columnIndex), (Throwable)ex);
                                }
                            }
                        }
                    } else if (DataTypes.isBinary(dataType)) {
                        this.ds.set(this.ds.getRowCount() - 1, this.name, Base64.decode(this.value.toString()));
                    } else {
                        this.ds.set(this.ds.getRowCount() - 1, this.name, this.value.toString());
                    }
                }
                this.index = 4;
            } else if (this.index == 7) {
                if (!this.isEmpty) {
                    int columnIndex = this.ds.indexOfColumn(this.name);
                    int dataType = this.dataTypes[columnIndex];
                    int targetDataType = this.ds.getColumn(columnIndex).getDataType();
                    if (targetDataType == 13) {
                        if (dataType == 2 || dataType == 12) {
                            try {
                                File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                this.writeValueToFile(Base64.decode(this.value.toString()), file);
                                this.ds.setSavedData(this.ds.getRowCount() - 1, this.name, (Object)file.getAbsolutePath());
                            }
                            catch (IOException ex) {
                                int rowIndex = this.ds.getRowCount() - 1;
                                if (this.log.isErrorEnabled()) {
                                    this.log.error((Object)("Could not save: rowIndex=" + rowIndex + ", columnIndex=" + columnIndex), (Throwable)ex);
                                }
                            }
                        }
                    } else if (DataTypes.isBinary(dataType)) {
                        this.ds.setSavedData(this.ds.getRowCount() - 1, this.name, (Object)Base64.decode(this.value.toString()));
                    } else {
                        this.ds.setSavedData(this.ds.getRowCount() - 1, this.name, (Object)this.value.toString());
                    }
                }
                this.index = 6;
            }
            this.name = null;
            this.value.setLength(0);
            this.isEmpty = false;
        } else if ("record".equals(qName)) {
            if ("insert".equals(this.rowType)) {
                this.ds.setRowType(this.ds.getRowCount() - 1, 1);
            } else if ("update".equals(this.rowType)) {
                this.ds.setRowType(this.ds.getRowCount() - 1, 2);
            } else if ("delete".equals(this.rowType)) {
                this.ds.setRowType(this.ds.getRowCount() - 1, 3);
            } else {
                this.ds.setRowType(this.ds.getRowCount() - 1, 0);
            }
            this.index = 0;
        } else if ("org_record".equals(qName)) {
            this.index = 4;
        } else if ("colinfo".equals(qName)) {
            this.ds.addColumn(this.header);
            this.header = null;
            this.index = 0;
        } else if ("param".equals(qName)) {
            if (!this.isEmpty) {
                this.var.set(this.value.toString());
            }
            this.data.addVariable(this.var);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding Variable: " + this.var));
            }
            this.var = null;
            this.value.setLength(0);
            this.isEmpty = false;
            this.index = 0;
        } else if ("column".equals(qName)) {
            String name = this.header.getName();
            int dataType = this.header.getDataType();
            int dataSize = this.header.getDataSize();
            Object constant = null;
            if (!this.isEmpty) {
                constant = this.value.toString();
                if (DataTypes.isBinary(dataType)) {
                    constant = Base64.decode((String)constant);
                }
            }
            this.ds.addConstantColumn(name, dataType, dataSize, constant);
            this.header = null;
            this.value.setLength(0);
            this.isEmpty = false;
            this.index = 0;
        } else if ("dataset".equals(qName)) {
            if (this.isStoreDataChanges) {
                this.ds.startStoreDataChanges(true);
            }
            if (this.isCheckingSetterDataIndex) {
                this.ds.setCheckingSetterDataIndex(true);
            }
            this.data.addDataSet(this.ds);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding DataSet: " + this.ds));
            }
            this.dataTypes = null;
            this.ds = null;
            this.index = 0;
        } else if ("params".equals(qName)) {
            this.index = 0;
        } else if ("root".equals(qName)) {
            this.index = 0;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.index == 1 || this.index == 3 || this.index == 5 || this.index == 7) {
            this.value.append(ch, start, length);
        }
    }

    private ColumnHeader createColumnHeader(Attributes attributes) {
        String name = attributes.getValue("id");
        String dataTypeStr = attributes.getValue("type");
        String dataSizeStr = attributes.getValue("size");
        int dataType = this.toDataType(dataTypeStr);
        int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
        return new ColumnHeader(name, dataType, dataSize);
    }

    private int[] getSourceDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            String columnName;
            String dsName;
            int dataType;
            int sourceDataType;
            ColumnHeader header = ds.getColumn(i);
            dataTypes[i] = sourceDataType = header.getDataType();
            if (dataTypeChanger == null || (dataType = dataTypeChanger.getDataType(dsName = ds.getAlias(), columnName = header.getName(), sourceDataType)) == sourceDataType) continue;
            int dataSize = header.getDataSize();
            if (header.isConstant()) {
                if (dataType == 13) continue;
                Object value = ((ConstantColumnHeader)header).getValue();
                ConstantColumnHeader newHeader = new ConstantColumnHeader(columnName, value, dataType, dataSize);
                ds.setColumn(i, newHeader);
                continue;
            }
            ColumnHeader newHeader = new ColumnHeader(columnName, dataType, dataSize);
            ds.setColumn(i, newHeader);
        }
        return dataTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeValueToFile(byte[] value, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(value);
        }
        finally {
            out.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving data to file: file=" + file));
        }
    }

    private int toDataType(String type) {
        if (type == null) {
            return 2;
        }
        if ("STRING".equals(type)) {
            return 2;
        }
        if ("INT".equals(type)) {
            return 3;
        }
        if ("DECIMAL".equals(type)) {
            return 7;
        }
        if ("CURRENCY".equals(type)) {
            return 8;
        }
        if ("DATE".equals(type)) {
            return 11;
        }
        if ("BLOB".equals(type)) {
            return 12;
        }
        if ("URL".equals(type)) {
            return 2;
        }
        if ("LONG".equals(type)) {
            return 2;
        }
        if ("CHAR".equals(type)) {
            return 2;
        }
        if ("FILE".equals(type)) {
            return 12;
        }
        if ("UNKNOWN".equals(type)) {
            return 2;
        }
        if ("EMPTY".equals(type)) {
            return 2;
        }
        return 2;
    }
}

