/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.PlatformCodec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformSsvExtDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformSsvExtDataSerializer.class);
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private byte[] buffer;
    private char rs = (char)30;
    private char us = (char)31;
    private char etx = (char)3;

    public void setProperty(String key, Object value) {
    }

    public void writeData(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this + ", charset=" + charset));
        }
        try {
            this.writeData(new OutputStreamWriter(out, charset), data, dataTypeChanger, charset);
        }
        catch (UnsupportedEncodingException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Unsupported charset: " + charset), (Throwable)ex);
            }
            throw new PlatformException("Unsupported charset: " + charset, ex);
        }
    }

    public void writeData(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this + ", charset=" + charset));
        }
        try {
            this.write(out, data, dataTypeChanger, charset);
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    private void write(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws IOException {
        out.write("<!--[if lt IE 9]><comment><![endif]--><noscript>");
        this.writeHeader(out, data, charset);
        this.writeVariableList(out, data, dataTypeChanger);
        this.writeDataSetList(out, data, dataTypeChanger);
        out.write("</noscript></comment>");
        out.flush();
    }

    private void writeHeader(Writer out, PlatformData data, String charset) throws IOException {
        if (charset == null) {
            this.writeString(out, "SSV");
        } else {
            this.writeString(out, "SSV:" + charset);
        }
    }

    private void writeVariableList(Writer out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        VariableList varList = data.getVariableList();
        int count = varList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.writeVariable(out, varList.get(i), dataTypeChanger);
            }
        }
    }

    private void writeVariable(Writer out, Variable var, DataTypeChanger dataTypeChanger) throws IOException {
        if (DataTypes.isBinary(var.getType())) {
            this.writeBinaryVariable(out, var);
        } else {
            this.writeStringVariable(out, var);
        }
    }

    private void writeStringVariable(Writer out, Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        String value = this.getStringValue(var);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 32);
        if (value == null) {
            if (var.getType() == 2) {
                buffer.append(name).append(':').append(type).append('=').append(this.etx);
            } else {
                buffer.append(name).append(':').append(type).append('=');
            }
        } else {
            buffer.append(name).append(':').append(type).append('=').append(value);
        }
        this.writeString(out, buffer.toString());
    }

    private void writeBinaryVariable(Writer out, Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        byte[] value = this.getBinaryValue(var);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(32);
            buffer.append(name).append(':').append(type).append('=');
            this.writeString(out, buffer.toString());
        } else {
            String encoded = Base64.encodeBytes(value, 8);
            int length = encoded == null ? 0 : encoded.length();
            StringBuffer buffer = new StringBuffer(length + 32);
            buffer.append(name).append(':').append(type).append('=');
            if (encoded != null) {
                buffer.append(encoded);
            }
            this.writeString(out, buffer.toString());
        }
    }

    private String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    private void writeDataSetList(Writer out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        DataSetList dsList = data.getDataSetList();
        int count = dsList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.writeString(out, "");
            }
            this.writeDataSet(out, data, dsList.get(i), dataTypeChanger);
        }
    }

    private void writeDataSet(Writer out, PlatformData data, DataSet ds, DataTypeChanger dataTypeChanger) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + name + ", alias=" + alias + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
        }
        this.writeString(out, "Dataset:" + alias);
        int[] dataTypes = this.getTargetDataTypes(ds, dataTypeChanger);
        this.writeColumns(out, ds, dataTypes);
        this.writeRows(out, data, ds, dataTypes);
    }

    private void writeColumns(Writer out, DataSet ds, int[] dataTypes) throws IOException {
        int count = ds.getColumnCount();
        StringBuffer defaultBuffer = new StringBuffer();
        StringBuffer constantBuffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            int dataType = dataTypes[i];
            if (header.getType() == 0) {
                this.writeDefaultColumnHeader(defaultBuffer, header, dataType);
                continue;
            }
            if (header.getType() == 1) {
                this.writeConstantColumnHeader(constantBuffer, ds, header, dataType);
                continue;
            }
            throw new IOException("Invalid column type: " + header.getType());
        }
        if (constantBuffer.length() > 0) {
            this.writeString(out, "_Const_" + constantBuffer.toString());
        }
        if (defaultBuffer.length() > 0) {
            this.writeString(out, "_RowType_" + defaultBuffer.toString());
        }
    }

    private void writeDefaultColumnHeader(StringBuffer buffer, ColumnHeader header, int dataType) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        buffer.append(this.us);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
    }

    private void writeConstantColumnHeader(StringBuffer buffer, DataSet ds, ColumnHeader header, int dataType) throws IOException {
        if (DataTypes.isBinary(dataType)) {
            this.writeBinaryColumnHeader(buffer, ds, (ConstantColumnHeader)header, dataType);
        } else {
            this.writeStringColumnHeader(buffer, ds, (ConstantColumnHeader)header, dataType);
        }
    }

    private void writeStringColumnHeader(StringBuffer buffer, DataSet ds, ConstantColumnHeader header, int dataType) throws IOException {
        if (dataType == 13) {
            dataType = 2;
        }
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        String value = this.getStringValue(ds, header);
        buffer.append(this.us);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
        buffer.append('=');
        if (value != null) {
            buffer.append(value);
        }
    }

    private void writeBinaryColumnHeader(StringBuffer buffer, DataSet ds, ConstantColumnHeader header, int dataType) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        byte[] value = this.getBinaryValue(ds, header);
        buffer.append(this.us);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
        buffer.append('=');
        if (value != null) {
            String encoded = Base64.encodeBytes(value, 8);
            buffer.append(encoded);
        }
    }

    private String getStringValue(DataSet ds, ConstantColumnHeader header) {
        int dataType = header.getDataType();
        if (dataType == 4) {
            return header.getBooleanValue(ds) ? "1" : "0";
        }
        String value = header.getStringValue(ds);
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, ConstantColumnHeader header) {
        return header.getBlobValue(ds);
    }

    private void writeRows(Writer out, PlatformData data, DataSet ds, int[] dataTypes) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            this.writeRow(out, ds, dataTypes, i, saveType);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                this.writeRemovedRow(out, ds, dataTypes, i);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(Writer out, DataSet ds, int[] dataTypes, int row, int saveType) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (saveType == 2) {
            buffer.append('N');
        } else if (rowType == 1) {
            buffer.append('I');
        } else if (rowType == 2) {
            buffer.append('U');
        } else if (rowType == 3) {
            buffer.append('D');
        } else {
            buffer.append('N');
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getBinaryValueFromFile(ds, row, i, dataType) : this.getBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.us);
                    continue;
                }
                buffer.append(this.us);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getStringValueFromFile(ds, row, i, dataType) : this.getStringValue(ds, row, i);
            if (value == null) {
                if (dataType == 2) {
                    buffer.append(this.us).append(this.etx);
                    continue;
                }
                buffer.append(this.us);
                continue;
            }
            buffer.append(this.us);
            buffer.append((String)value);
        }
        this.writeString(out, buffer.toString());
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(out, ds, dataTypes, row);
        }
    }

    private void writeSavedRow(Writer out, DataSet ds, int[] dataTypes, int row) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('O');
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getSavedBinaryValueFromFile(ds, row, i, dataType) : this.getSavedBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.us);
                    continue;
                }
                buffer.append(this.us);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getSavedStringValueFromFile(ds, row, i, dataType) : this.getSavedStringValue(ds, row, i);
            if (value == null) {
                if (dataType == 2) {
                    buffer.append(this.us).append(this.etx);
                    continue;
                }
                buffer.append(this.us);
                continue;
            }
            buffer.append(this.us);
            buffer.append((String)value);
        }
        this.writeString(out, buffer.toString());
    }

    private void writeRemovedRow(Writer out, DataSet ds, int[] dataTypes, int row) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('D');
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getRemovedBinaryValueFromFile(ds, row, i, dataType) : this.getRemovedBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.us);
                    continue;
                }
                buffer.append(this.us);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getRemovedStringValueFromFile(ds, row, i, dataType) : this.getRemovedStringValue(ds, row, i);
            if (value == null) {
                if (dataType == 2) {
                    buffer.append(this.us).append(this.etx);
                    continue;
                }
                buffer.append(this.us);
                continue;
            }
            buffer.append(this.us);
            buffer.append((String)value);
        }
        this.writeString(out, buffer.toString());
    }

    private String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    private String getStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private String getSavedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getSavedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getSavedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getSavedBinaryValue(DataSet ds, int row, int column) {
        return ds.getSavedBlobData(row, column);
    }

    private String getSavedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getSavedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private String getRemovedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getRemovedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getRemovedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getRemovedBinaryValue(DataSet ds, int row, int column) {
        return ds.getRemovedBlobData(row, column);
    }

    private String getRemovedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getRemovedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private void writeString(Writer out, String str) throws IOException {
        out.write(str);
        out.write(this.rs);
    }

    private int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    private String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType(3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType(8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType(6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(dataType);
    }

    private String encode(String str) {
        if (str == null) {
            return str;
        }
        return this.platformCodec.encode(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

