/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.util.TypeConverter;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.EmptyElementInputStream;
import com.nexacro.xapi.tx.impl.EmptyElementReader;
import com.nexacro.xapi.util.PlatformGlobals;
import com.nexacro.xapi.util.SequenceReader;
import com.nexacro.xapi.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PlatformXmlDataDeserializer
extends DefaultHandler
implements DataDeserializer {
    private Log log = LogFactory.getLog((Class)PlatformXmlDataDeserializer.class);
    private static final boolean REMOVE_ENCODING_TAG = false;
    private static final String PARSER_FACTORY_KEY = "platform.tx.DataDeserializer.platformxml.parserfactory";
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    protected static final int INDEX_UNDEFINED = 0;
    protected static final int INDEX_VARIABLE = 1;
    protected static final int INDEX_DATA_ROW = 2;
    protected static final int INDEX_DATA_CELL = 3;
    protected static final int INDEX_SAVED_DATA_ROW = 4;
    protected static final int INDEX_SAVED_DATA_CELL = 5;
    private static ThreadLocal parserThreadLocal;
    private Map properties;
    private boolean isEmptyToNull;
    private int index;
    private PlatformData data;
    private Variable var;
    private DataSet ds;
    private int[] dataTypes;
    private boolean isStoreDataChanges;
    private boolean isCheckingSetterDataIndex;
    private String rowType;
    private String columnName;
    private StringBuffer value = new StringBuffer();
    private boolean isEmpty;
    private DataTypeChanger dataTypeChanger;

    private Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    public PlatformData readData(InputStream in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this + ", charset=" + charset));
        }
        this.init();
        try {
            byte[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            if (encoding == null) {
                encoding = charset;
            }
            InputStream ein = in;
            if (this.isEmptyToNull()) {
                ein = new EmptyElementInputStream(in);
                ein = new BufferedInputStream(ein);
            }
            byte[] newHeader = header;
            SequenceInputStream sin = new SequenceInputStream(new ByteArrayInputStream(newHeader), ein);
            InputStreamReader reader = new InputStreamReader((InputStream)sin, encoding);
            InputSource source = new InputSource(reader);
            source.setEncoding(encoding);
            return this.read(source, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    public PlatformData readData(Reader in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this + ", charset=" + charset));
        }
        this.init();
        try {
            char[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            Reader ein = in;
            if (this.isEmptyToNull()) {
                ein = new EmptyElementReader(in);
                ein = new BufferedReader(ein);
            }
            SequenceReader sin = new SequenceReader(new CharArrayReader(header), ein);
            InputSource source = new InputSource(sin);
            if (encoding == null) {
                source.setEncoding(charset);
            } else {
                source.setEncoding(encoding);
            }
            return this.read(source, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    protected int getCurrentIndex() {
        return this.index;
    }

    protected void setCurrentIndex(int index) {
        this.index = index;
    }

    protected Variable getCurrentVariable() {
        return this.var;
    }

    protected void setCurrentVariable(Variable var) {
        this.var = var;
    }

    protected DataSet getCurrentDataSet() {
        return this.ds;
    }

    protected void setCurrentDataSet(DataSet ds) {
        this.ds = ds;
    }

    protected int[] getCurrentDataTypes() {
        return this.dataTypes;
    }

    protected void setCurrentDataTypes(int[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    protected String getCurrentRowType() {
        return this.rowType;
    }

    protected void setCurrentRowType(String rowType) {
        this.rowType = rowType;
    }

    protected String getCurrentColumnName() {
        return this.columnName;
    }

    protected void setCurrentColumnName(String columnName) {
        this.columnName = columnName;
    }

    protected boolean getCurrentIsEmpty() {
        return this.isEmpty;
    }

    protected void setCurrentIsEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    protected String getCurrentValue() {
        return this.value.toString();
    }

    protected void addCurrentValue(char[] ch, int start, int length) {
        this.value.append(ch, start, length);
    }

    protected void clearCurrentValue() {
        this.value.setLength(0);
    }

    protected PlatformData getData() {
        return this.data;
    }

    protected void setData(PlatformData data) {
        this.data = data;
    }

    protected DataTypeChanger getDataTypeChanger() {
        return this.dataTypeChanger;
    }

    protected void setDataTypeChanger(DataTypeChanger dataTypeChanger) {
        this.dataTypeChanger = dataTypeChanger;
    }

    protected PlatformData read(InputSource source, DataTypeChanger dataTypeChanger) throws PlatformException {
        try {
            this.setDataTypeChanger(dataTypeChanger);
            SAXParser parser = this.getSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parser.parse(source, (DefaultHandler)this);
            return this.getData();
        }
        catch (ParserConfigurationException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
        catch (SAXException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    private byte[] readHeader(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        do {
            ch = in.read();
            out.write(ch);
        } while (ch != -1 && ch != 62);
        out.close();
        return out.toByteArray();
    }

    private char[] readHeader(Reader in) throws IOException {
        int ch;
        CharArrayWriter out = new CharArrayWriter();
        do {
            ch = in.read();
            out.write(ch);
        } while (ch != -1 && ch != 62);
        out.close();
        return out.toCharArray();
    }

    private String findEncoding(byte[] header) {
        return this.findEncoding(new String(header));
    }

    private String findEncoding(char[] header) {
        return this.findEncoding(new String(header));
    }

    private String findEncoding(String header) {
        String encoding;
        int end;
        int begin;
        int separator;
        int index = header.indexOf("encoding");
        if (index != -1 && (separator = header.indexOf(61, index + 8)) != -1 && (begin = header.indexOf(34, separator + 1)) != -1 && (end = header.indexOf(34, ++begin)) != -1 && (encoding = header.substring(begin, end).trim()).length() > 0) {
            return encoding;
        }
        return null;
    }

    private byte[] removeEncoding(byte[] b) {
        int end;
        int begin;
        int separator;
        String header = new String(b);
        int index = header.indexOf("encoding");
        if (index != -1 && (separator = header.indexOf(61, index + 8)) != -1 && (begin = header.indexOf(34, separator + 1)) != -1 && (end = header.indexOf(34, ++begin)) != -1) {
            String pre = header.substring(0, index).trim();
            String post = header.substring(end + 1).trim();
            if ("?>".equals(post)) {
                return (pre + post).getBytes();
            }
            return (pre + ' ' + post).getBytes();
        }
        return b;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("Col".equals(qName)) {
            this.startDataSetCell(attributes);
        } else if ("Row".equals(qName)) {
            this.startDataSetRow(attributes);
        } else if ("OrgRow".equals(qName)) {
            this.startDataSetSavedRow(attributes);
        } else if ("Column".equals(qName)) {
            this.startDataSetDefaultColumn(attributes);
        } else if ("Parameter".equals(qName)) {
            this.startVariable(attributes);
        } else if ("ConstColumn".equals(qName)) {
            this.startDataSetConstantColumn(attributes);
        } else if ("Rows".equals(qName)) {
            this.startDataSetRowList(attributes);
        } else if (!"ColumnInfo".equals(qName)) {
            if ("Dataset".equals(qName)) {
                this.startDataSet(attributes);
            } else if (!"Parameters".equals(qName) && "Root".equals(qName)) {
                this.startData();
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("Col".equals(qName)) {
            this.endDataSetCell();
        } else if ("Row".equals(qName)) {
            this.endDataSetRow();
        } else if ("OrgRow".equals(qName)) {
            this.endDataSetSavedRow();
        } else if ("Column".equals(qName)) {
            this.endDataSetDefaultColumn();
        } else if ("Parameter".equals(qName)) {
            this.endVariable();
        } else if ("ConstColumn".equals(qName)) {
            this.endDataSetConstantColumn();
        } else if ("Rows".equals(qName)) {
            this.endDataSetRowList();
        } else if ("ColumnInfo".equals(qName)) {
            this.endDataSetColumnList();
        } else if ("Dataset".equals(qName)) {
            this.endDataSet();
        } else if ("Parameters".equals(qName)) {
            this.endVariableList();
        } else if ("Root".equals(qName)) {
            this.endData();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int index = this.getCurrentIndex();
        if (index == 1 || index == 3 || index == 5) {
            this.addCurrentValue(ch, start, length);
        }
    }

    protected void startData() {
        this.setData(new PlatformData());
    }

    protected void endData() {
        this.setCurrentIndex(0);
    }

    protected void endVariableList() {
        this.setCurrentIndex(0);
    }

    protected void startVariable(Attributes attributes) {
        String name = attributes.getValue("id");
        String typeStr = attributes.getValue("type");
        int type = this.getDataType(typeStr);
        boolean isEmpty = "true".equals(attributes.getValue("empty"));
        if (this.isEmptyToNull()) {
            this.setCurrentIsEmpty(isEmpty);
        }
        Variable var = new Variable(name, type);
        this.setCurrentVariable(var);
        this.setCurrentIndex(1);
    }

    protected void endVariable() {
        Variable var = this.getCurrentVariable();
        int dataType = var.getType();
        String value = this.getCurrentValue();
        if (!this.isNull(value, dataType)) {
            var.set(value);
        }
        this.getData().addVariable(var);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding Variable: " + var));
        }
        this.setCurrentVariable(null);
        this.clearCurrentValue();
        this.setCurrentIsEmpty(false);
        this.setCurrentIndex(0);
    }

    protected void startDataSet(Attributes attributes) {
        String name = attributes.getValue("id");
        DataSet ds = new DataSet(name);
        this.isStoreDataChanges = ds.isStoreDataChanges();
        this.isCheckingSetterDataIndex = ds.isCheckingSetterDataIndex();
        if (this.isStoreDataChanges) {
            ds.stopStoreDataChanges();
        }
        if (this.isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(false);
        }
        this.setCurrentDataSet(ds);
    }

    protected void endDataSet() {
        DataSet ds = this.getCurrentDataSet();
        if (this.isStoreDataChanges) {
            ds.startStoreDataChanges(true);
        }
        if (this.isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(true);
        }
        this.getData().addDataSet(ds);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding DataSet: " + ds));
        }
        this.setCurrentDataSet(null);
        this.setCurrentIndex(0);
    }

    protected void endDataSetColumnList() {
        this.setCurrentIndex(0);
    }

    protected void startDataSetDefaultColumn(Attributes attributes) {
        DataSet ds = this.getCurrentDataSet();
        String name = attributes.getValue("id");
        String dataTypeStr = attributes.getValue("type");
        String dataSizeStr = attributes.getValue("size");
        int dataType = this.getDataType(dataTypeStr);
        int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
        ds.addColumn(name, dataType, dataSize);
    }

    protected void endDataSetDefaultColumn() {
        this.setCurrentIndex(0);
    }

    protected void startDataSetConstantColumn(Attributes attributes) {
        DataSet ds = this.getCurrentDataSet();
        String name = attributes.getValue("id");
        String dataTypeStr = attributes.getValue("type");
        String dataSizeStr = attributes.getValue("size");
        String valueStr = attributes.getValue("value");
        int dataType = this.getDataType(dataTypeStr);
        int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
        Object value = DataTypes.isBinary(dataType) ? Base64.decode(valueStr) : (Object)TypeConverter.convert(valueStr, dataType);
        ds.addConstantColumn(name, dataType, dataSize, value);
    }

    protected void endDataSetConstantColumn() {
        this.setCurrentIndex(0);
    }

    protected void startDataSetRowList(Attributes attributes) {
        int[] dataTypes = this.getSourceDataTypes(this.getCurrentDataSet(), this.getDataTypeChanger());
        this.setCurrentDataTypes(dataTypes);
    }

    protected void endDataSetRowList() {
        this.setCurrentDataTypes(null);
        this.setCurrentIndex(0);
    }

    protected void startDataSetRow(Attributes attributes) {
        DataSet ds = this.getCurrentDataSet();
        this.setCurrentRowType(attributes.getValue("type"));
        ds.newRow();
        this.setCurrentIndex(2);
    }

    protected void endDataSetRow() {
        DataSet ds = this.getCurrentDataSet();
        String rowType = this.getCurrentRowType();
        if ("insert".equals(rowType)) {
            ds.setRowType(ds.getRowCount() - 1, 1);
        } else if ("update".equals(rowType)) {
            ds.setRowType(ds.getRowCount() - 1, 2);
        } else if ("delete".equals(rowType)) {
            ds.setRowType(ds.getRowCount() - 1, 3);
        } else {
            ds.setRowType(ds.getRowCount() - 1, 0);
        }
        this.setCurrentIndex(0);
    }

    protected void startDataSetSavedRow(Attributes attributes) {
        this.setCurrentIndex(4);
    }

    protected void endDataSetSavedRow() {
        this.setCurrentIndex(2);
        DataSet ds = this.getCurrentDataSet();
        int row = ds.getRowCount() - 1;
        if (!ds.hasSavedRow(row) && ds.getColumnCount() > 0) {
            ds.setSavedData(row, 0, null);
        }
    }

    protected void startDataSetCell(Attributes attributes) {
        String columnName = attributes.getValue("id");
        boolean isEmpty = "true".equals(attributes.getValue("empty"));
        if (this.isEmptyToNull()) {
            this.setCurrentIsEmpty(isEmpty);
        }
        this.setCurrentColumnName(columnName);
        if (this.getCurrentIndex() == 2) {
            this.setCurrentIndex(3);
        } else if (this.getCurrentIndex() == 4) {
            this.setCurrentIndex(5);
        }
    }

    protected void endDataSetCell() {
        int index = this.getCurrentIndex();
        DataSet ds = this.getCurrentDataSet();
        int[] dataTypes = this.getCurrentDataTypes();
        String columnName = this.getCurrentColumnName();
        String value = this.getCurrentValue();
        int columnIndex = ds.indexOfColumn(columnName);
        int dataType = dataTypes[columnIndex];
        int targetDataType = ds.getColumn(columnIndex).getDataType();
        boolean isNull = this.isNull(value, dataType);
        if (index == 3) {
            if (targetDataType == 13) {
                if (dataType == 2 || dataType == 12) {
                    try {
                        File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                        if (!isNull) {
                            this.writeValueToFile(Base64.decode(value), file);
                        }
                        ds.set(ds.getRowCount() - 1, columnName, file.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        int rowIndex = ds.getRowCount() - 1;
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("Could not save: rowIndex=" + rowIndex + ", columnIndex=" + columnIndex), (Throwable)ex);
                        }
                    }
                }
            } else if (!isNull) {
                if (DataTypes.isBinary(dataType)) {
                    ds.set(ds.getRowCount() - 1, columnName, Base64.decode(value));
                } else {
                    ds.set(ds.getRowCount() - 1, columnName, value);
                }
            }
            this.setCurrentIndex(2);
        } else if (index == 5) {
            if (targetDataType == 13) {
                if (dataType == 2 || dataType == 12) {
                    try {
                        File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                        if (!isNull) {
                            this.writeValueToFile(Base64.decode(value), file);
                        }
                        ds.setSavedData(ds.getRowCount() - 1, columnName, (Object)file.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        int rowIndex = ds.getRowCount() - 1;
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("Could not save: rowIndex=" + rowIndex + ", columnIndex=" + columnIndex), (Throwable)ex);
                        }
                    }
                }
            } else if (!isNull) {
                if (DataTypes.isBinary(dataType)) {
                    ds.setSavedData(ds.getRowCount() - 1, columnName, (Object)Base64.decode(value));
                } else {
                    ds.setSavedData(ds.getRowCount() - 1, columnName, (Object)value);
                }
            }
            this.setCurrentIndex(4);
        }
        this.setCurrentColumnName(null);
        this.clearCurrentValue();
        this.setCurrentIsEmpty(false);
    }

    protected int[] getSourceDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            String columnName;
            String dsName;
            int dataType;
            int sourceDataType;
            ColumnHeader header = ds.getColumn(i);
            dataTypes[i] = sourceDataType = header.getDataType();
            if (dataTypeChanger == null || (dataType = dataTypeChanger.getDataType(dsName = ds.getAlias(), columnName = header.getName(), sourceDataType)) == sourceDataType) continue;
            int dataSize = header.getDataSize();
            if (header.isConstant()) {
                if (dataType == 13) continue;
                Object value = ((ConstantColumnHeader)header).getValue();
                ConstantColumnHeader newHeader = new ConstantColumnHeader(columnName, value, dataType, dataSize);
                ds.setColumn(i, newHeader);
                continue;
            }
            ColumnHeader newHeader = new ColumnHeader(columnName, dataType, dataSize);
            ds.setColumn(i, newHeader);
        }
        return dataTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeValueToFile(byte[] value, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(value);
        }
        finally {
            out.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving data to file: file=" + file));
        }
    }

    private boolean isNull(String value, int dataType) {
        if (this.getCurrentIsEmpty()) {
            return true;
        }
        return this.isEmptyToNull() && dataType == 2 && "".equals(value);
    }

    private void init() {
        this.isEmptyToNull = this.getEmptyToNull();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("init: isEmptyToNull=" + this.isEmptyToNull));
        }
    }

    private boolean isEmptyToNull() {
        return this.isEmptyToNull;
    }

    private boolean getEmptyToNull() {
        Object emptyToNull = this.getProperty("deserializer.data.emptytonull");
        if ("true".equals(emptyToNull)) {
            return true;
        }
        if ("false".equals(emptyToNull)) {
            return false;
        }
        String systemEmptyToNull = System.getProperty("xapi.deserializer.data.emptytonull");
        return "true".equals(systemEmptyToNull);
    }

    private int getDataType(String str) {
        if ("binary".equalsIgnoreCase(str)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(str)) {
            return 7;
        }
        return DataTypes.toIntType(str);
    }

    private SAXParser getSAXParser() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        String parserFactory = PlatformGlobals.getStringProperty(PARSER_FACTORY_KEY);
        if ("threadlocal".equals(parserFactory)) {
            return this.getSAXParserFromThreadLocal();
        }
        return this.createSAXParser();
    }

    private SAXParser createSAXParser() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory.newSAXParser();
    }

    private SAXParser getSAXParserFromThreadLocal() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        if (parserThreadLocal == null) {
            parserThreadLocal = new ThreadLocal();
        }
        SAXParser parser = (SAXParser)parserThreadLocal.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting SAXParser: thread=" + Thread.currentThread().getName() + ", parser=" + parser));
        }
        if (parser == null) {
            parser = this.createSAXParser();
            parserThreadLocal.set(parser);
        }
        return parser;
    }
}

