/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.PlatformCodec;
import com.nexacro.xapi.tx.impl.XmlCodec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformXmlDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformXmlDataSerializer.class);
    private static final boolean NULL_IS_SINGLE_TAG = true;
    private static final boolean WRITE_NULL_VALUE = false;
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String XML_NS = "http://www.nexacroplatform.com/platform/dataset";
    private static final String VERSION = "5000";
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private XmlCodec xmlCodec = new XmlCodec();
    private byte[] buffer;

    public void setProperty(String key, Object value) {
    }

    public void writeData(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this + ", charset=" + charset));
        }
        try {
            this.writeData(new OutputStreamWriter(out, charset), data, dataTypeChanger, charset);
        }
        catch (UnsupportedEncodingException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Unsupported charset: " + charset), (Throwable)ex);
            }
            throw new PlatformException("Unsupported charset: " + charset, ex);
        }
    }

    public void writeData(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this + ", charset=" + charset));
        }
        try {
            this.write(out, data, dataTypeChanger, charset);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    protected void write(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws IOException {
        int depth = 0;
        this.writeHeader(out, data, charset, depth);
        this.writeBeginRoot(out, depth);
        this.writeVariableList(out, data, dataTypeChanger, ++depth);
        this.writeDataSetList(out, data, dataTypeChanger, depth--);
        this.writeEndRoot(out, depth);
        out.flush();
    }

    protected void writeHeader(Writer out, PlatformData data, String charset, int depth) throws IOException {
        if (charset == null) {
            this.writeString(out, "<?xml version=\"1.0\"?>", depth);
        } else {
            this.writeString(out, "<?xml version=\"1.0\" encoding=\"" + charset + "\"?>", depth);
        }
    }

    protected void writeBeginRoot(Writer out, int depth) throws IOException {
        this.writeString(out, "<Root xmlns=\"http://www.nexacroplatform.com/platform/dataset\">", depth);
    }

    protected void writeEndRoot(Writer out, int depth) throws IOException {
        this.writeString(out, "</Root>", depth);
    }

    protected void writeVariableList(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, int depth) throws IOException {
        VariableList varList = data.getVariableList();
        int count = varList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        if (count == 0) {
            this.writeString(out, "<Parameters/>", depth);
        } else {
            this.writeString(out, "<Parameters>", depth++);
            for (int i = 0; i < count; ++i) {
                this.writeVariable(out, varList.get(i), dataTypeChanger, depth);
            }
            this.writeString(out, "</Parameters>", --depth);
        }
    }

    protected void writeVariable(Writer out, Variable var, DataTypeChanger dataTypeChanger, int depth) throws IOException {
        if (DataTypes.isBinary(var.getType())) {
            this.writeBinaryVariable(out, var, depth);
        } else {
            this.writeStringVariable(out, var, depth);
        }
    }

    protected void writeStringVariable(Writer out, Variable var, int depth) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        String value = this.getStringValue(var);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<Parameter id=\"").append(name);
        buffer.append("\" type=\"").append(type);
        if (value == null) {
            buffer.append("\"/>");
        } else {
            buffer.append("\">").append(value);
            buffer.append("</Parameter>");
        }
        this.writeString(out, buffer.toString(), depth);
    }

    protected void writeBinaryVariable(Writer out, Variable var, int depth) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        byte[] value = this.getBinaryValue(var);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<Parameter id=\"").append(name);
            buffer.append("\" type=\"").append(type);
            buffer.append("\"/>");
            this.writeString(out, buffer.toString(), depth);
        } else {
            String prefix = "<Parameter id=\"" + name + "\" type=\"" + type + "\" encrypt=\"base64\">";
            String suffix = "</Parameter>";
            this.writeBinary(out, value, prefix, suffix, depth);
        }
    }

    protected String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    protected byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    protected void writeDataSetList(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, int depth) throws IOException {
        DataSetList dsList = data.getDataSetList();
        int count = dsList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        for (int i = 0; i < count; ++i) {
            this.writeDataSet(out, data, dsList.get(i), dataTypeChanger, depth);
        }
    }

    protected void writeDataSet(Writer out, PlatformData data, DataSet ds, DataTypeChanger dataTypeChanger, int depth) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + name + ", alias=" + alias + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
        }
        this.writeString(out, "<Dataset id=\"" + alias + "\">", depth);
        int[] dataTypes = this.getTargetDataTypes(ds, dataTypeChanger);
        this.writeColumns(out, ds, dataTypes, ++depth);
        this.writeRows(out, data, ds, dataTypes, depth--);
        this.writeString(out, "</Dataset>", depth);
    }

    protected void writeColumns(Writer out, DataSet ds, int[] dataTypes, int depth) throws IOException {
        this.writeString(out, "<ColumnInfo>", depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            int dataType = dataTypes[i];
            if (header.getType() == 0) {
                this.writeDefaultColumnHeader(out, header, dataType, depth);
                continue;
            }
            if (header.getType() == 1) {
                this.writeConstantColumnHeader(out, ds, header, dataType, depth);
                continue;
            }
            throw new IOException("Invalid column type: " + header.getType());
        }
        this.writeString(out, "</ColumnInfo>", --depth);
    }

    protected void writeDefaultColumnHeader(Writer out, ColumnHeader header, int dataType, int depth) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("<Column id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (dataType == 13 || DataTypes.isBinary(dataType)) {
            buffer.append("\" encrypt=\"").append("base64");
        }
        buffer.append("\"/>");
        this.writeString(out, buffer.toString(), depth);
    }

    protected void writeConstantColumnHeader(Writer out, DataSet ds, ColumnHeader header, int dataType, int depth) throws IOException {
        if (DataTypes.isBinary(dataType)) {
            this.writeBinaryColumnHeader(out, ds, (ConstantColumnHeader)header, dataType, depth);
        } else {
            this.writeStringColumnHeader(out, ds, (ConstantColumnHeader)header, dataType, depth);
        }
    }

    protected void writeStringColumnHeader(Writer out, DataSet ds, ConstantColumnHeader header, int dataType, int depth) throws IOException {
        if (dataType == 13) {
            dataType = 2;
        }
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        String value = this.getStringValue(ds, header);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<ConstColumn id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (value != null) {
            buffer.append("\" value=\"").append(value);
        }
        buffer.append("\"/>");
        this.writeString(out, buffer.toString(), depth);
    }

    protected void writeBinaryColumnHeader(Writer out, DataSet ds, ConstantColumnHeader header, int dataType, int depth) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        byte[] value = this.getBinaryValue(ds, header);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<ConstColumn id=\"").append(name);
            buffer.append("\" type=\"").append(dataTypeStr);
            buffer.append("\" size=\"").append(dataSize);
            buffer.append("\"/>");
            this.writeString(out, buffer.toString(), depth);
        } else {
            String prefix = "<ConstColumn id=\"" + name + "\" type=\"" + dataTypeStr + "\" size=\"" + dataSize + "\" encrypt=\"base64" + "\" value=\"";
            String suffix = "\"></ConstColumn>";
            this.writeBinary(out, value, prefix, suffix, depth);
        }
    }

    protected String getStringValue(DataSet ds, ConstantColumnHeader header) {
        int dataType = header.getDataType();
        if (dataType == 4) {
            return header.getBooleanValue(ds) ? "1" : "0";
        }
        String value = header.getStringValue(ds);
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    protected byte[] getBinaryValue(DataSet ds, ConstantColumnHeader header) {
        return header.getBlobValue(ds);
    }

    protected void writeRows(Writer out, PlatformData data, DataSet ds, int[] dataTypes, int depth) throws IOException {
        boolean isCheckingGetterDataIndex;
        this.writeString(out, "<Rows>", depth++);
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            this.writeRow(out, ds, dataTypes, i, saveType, depth);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                this.writeRemovedRow(out, ds, dataTypes, i, depth);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
        this.writeString(out, "</Rows>", --depth);
    }

    protected void writeRow(Writer out, DataSet ds, int[] dataTypes, int row, int saveType, int depth) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        if (saveType == 2) {
            this.writeString(out, "<Row>", depth++);
        } else if (rowType == 1) {
            this.writeString(out, "<Row type=\"insert\">", depth++);
        } else if (rowType == 2) {
            this.writeString(out, "<Row type=\"update\">", depth++);
        } else if (rowType == 3) {
            this.writeString(out, "<Row type=\"delete\">", depth++);
        } else {
            this.writeString(out, "<Row>", depth++);
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getBinaryValueFromFile(ds, row, i, dataType) : this.getBinaryValue(ds, row, i);
                if (value == null) continue;
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getStringValueFromFile(ds, row, i, dataType) : this.getStringValue(ds, row, i);
            if (value == null) continue;
            this.writeString(out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", depth);
        }
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(out, ds, dataTypes, row, depth);
        }
        this.writeString(out, "</Row>", --depth);
    }

    protected void writeSavedRow(Writer out, DataSet ds, int[] dataTypes, int row, int depth) throws IOException {
        this.writeString(out, "<OrgRow>", depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getSavedBinaryValueFromFile(ds, row, i, dataType) : this.getSavedBinaryValue(ds, row, i);
                if (value == null) continue;
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getSavedStringValueFromFile(ds, row, i, dataType) : this.getSavedStringValue(ds, row, i);
            if (value == null) continue;
            this.writeString(out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", depth);
        }
        this.writeString(out, "</OrgRow>", --depth);
    }

    protected void writeRemovedRow(Writer out, DataSet ds, int[] dataTypes, int row, int depth) throws IOException {
        this.writeString(out, "<Row type=\"delete\">", depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getRemovedBinaryValueFromFile(ds, row, i, dataType) : this.getRemovedBinaryValue(ds, row, i);
                if (value == null) continue;
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getRemovedStringValueFromFile(ds, row, i, dataType) : this.getRemovedStringValue(ds, row, i);
            if (value == null) continue;
            this.writeString(out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", depth);
        }
        this.writeString(out, "</Row>", --depth);
    }

    protected String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    protected byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    protected String getStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    protected byte[] getBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    protected String getSavedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getSavedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getSavedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    protected byte[] getSavedBinaryValue(DataSet ds, int row, int column) {
        return ds.getSavedBlobData(row, column);
    }

    protected String getSavedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    protected byte[] getSavedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    protected String getRemovedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getRemovedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getRemovedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    protected byte[] getRemovedBinaryValue(DataSet ds, int row, int column) {
        return ds.getRemovedBlobData(row, column);
    }

    protected String getRemovedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    protected byte[] getRemovedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    protected void writeString(Writer out, String str, int depth) throws IOException {
        if (depth == 0) {
            out.write(str);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            out.write(str);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[1]);
            }
            out.write(str);
            out.write(NL);
        }
    }

    protected void writeBinary(Writer out, byte[] value, String prefix, String suffix, int depth) throws IOException {
        if (depth == 0) {
            out.write(prefix);
            String encoded = Base64.encodeBytes(value, 8);
            out.write(encoded);
            out.write(suffix);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            out.write(prefix);
            String encoded = Base64.encodeBytes(value, 8);
            out.write(encoded);
            out.write(suffix);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[1]);
            }
            out.write(prefix);
            String encoded = Base64.encodeBytes(value, 8);
            out.write(encoded);
            out.write(suffix);
            out.write(NL);
        }
    }

    protected int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    protected String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType(3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType(8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType(6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(dataType);
    }

    protected String encode(String str) {
        if (str == null) {
            return str;
        }
        return this.xmlCodec.encode(this.platformCodec.encode(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

