/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class XmlCodec {
    public String encode(String str) {
        if (this.needToEncode(str)) {
            int count = str.length();
            int maybeEncodingCount = 3;
            StringBuffer buffer = new StringBuffer(count + maybeEncodingCount * 5);
            for (int i = 0; i < count; ++i) {
                char ch = str.charAt(i);
                if (this.needToEncode(ch)) {
                    buffer.append(this.encode(ch));
                    continue;
                }
                buffer.append(ch);
            }
            return buffer.toString();
        }
        return str;
    }

    public String encode(char ch) {
        if (ch < ' ') {
            return "&#" + ch + ";";
        }
        if (ch == ' ') {
            return "&#32;";
        }
        if (ch == '<') {
            return "&lt;";
        }
        if (ch == '>') {
            return "&gt;";
        }
        if (ch == '&') {
            return "&amp;";
        }
        if (ch == '\"') {
            return "&quot;";
        }
        if (ch == '\'') {
            return "&apos;";
        }
        return String.valueOf(ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decode(String str) {
        if (this.needToDecode(str)) {
            StringReader in = new StringReader(str);
            try {
                String string = this.decode(in);
                return string;
            }
            catch (IOException ex) {
                Log log = LogFactory.getLog((Class)XmlCodec.class);
                if (log.isErrorEnabled()) {
                    if (str.length() < 512) {
                        log.error((Object)("Could not decode: " + str), (Throwable)ex);
                    } else {
                        log.error((Object)"Could not decode", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    ((Reader)in).close();
                }
                catch (IOException iOException) {}
            }
            return str;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decode(Reader in) throws IOException {
        CharArrayWriter out = new CharArrayWriter();
        int bufferLen = 5;
        char[] buffer = new char[bufferLen];
        try {
            int ch;
            while ((ch = in.read()) != -1) {
                if (ch == 38) {
                    int n = -1;
                    for (int i = 0; i < bufferLen; ++i) {
                        buffer[i] = (char)in.read();
                        if (buffer[i] != ';') continue;
                        n = i;
                        break;
                    }
                    if (n == -1) {
                        out.write(buffer);
                        continue;
                    }
                    if (n == 0) {
                        out.write(38);
                        out.write(59);
                        continue;
                    }
                    if (buffer[0] == '#') {
                        if (n == 3) {
                            int num = (buffer[1] - 48) * 10 + (buffer[2] - 48);
                            if (num == 9) {
                                out.write(9);
                                continue;
                            }
                            if (num == 10) {
                                out.write(10);
                                continue;
                            }
                            if (num == 13) {
                                out.write(13);
                                continue;
                            }
                            if (num == 32) {
                                out.write(32);
                                continue;
                            }
                            if (num < 32) {
                                out.write(num);
                                continue;
                            }
                            out.write(buffer, 0, n);
                            continue;
                        }
                        out.write(buffer, 0, n);
                        continue;
                    }
                    if (n == 3) {
                        if (buffer[0] == 'l' && buffer[1] == 't') {
                            out.write(60);
                            continue;
                        }
                        if (buffer[0] == 'g' && buffer[1] == 't') {
                            out.write(62);
                            continue;
                        }
                        out.write(buffer, 0, n);
                        continue;
                    }
                    if (n == 4) {
                        if (buffer[0] == 'a' && buffer[1] == 'm' && buffer[2] == 'p') {
                            out.write(38);
                            continue;
                        }
                        out.write(buffer, 0, n);
                        continue;
                    }
                    if (n != 5) continue;
                    if (buffer[0] == 'q' && buffer[1] == 'u' && buffer[2] == 'o' && buffer[3] == 't') {
                        out.write(34);
                        continue;
                    }
                    if (buffer[0] == 'a' && buffer[1] == 'p' && buffer[2] == 'o' && buffer[3] == 's') {
                        out.write(92);
                        continue;
                    }
                    out.write(buffer, 0, n);
                    continue;
                }
                out.write(ch);
            }
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    public boolean needToEncode(String str) {
        if (str == null || "".equals(str)) {
            return false;
        }
        int count = str.length();
        char[] chars = str.toCharArray();
        for (int i = 0; i < count; ++i) {
            if (!this.needToEncode(chars[i])) continue;
            return true;
        }
        return false;
    }

    public boolean needToDecode(String str) {
        if (str == null || "".equals(str)) {
            return false;
        }
        return str.indexOf("&#") != -1 || str.indexOf("&lt;") != -1 || str.indexOf("&gt;") != -1 || str.indexOf("&amp;") != -1 || str.indexOf("&quot;") != -1 || str.indexOf("&apos;") != -1;
    }

    public boolean needToEncode(char ch) {
        return ch < ' ' || ch == ' ' || ch == '<' || ch == '>' || ch == '&' || ch == '\"' || ch == '\'';
    }
}

