/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import java.util.Calendar;
import java.util.Date;

public class DatetimeFormat {
    public static final int FORMAT_FULL_DATE_TIME = 0;
    public static final int FORMAT_DATE_TIME = 1;
    public static final int FORMAT_DATE = 2;
    public static final int FORMAT_FULL_TIME = 3;
    public static final int FORMAT_TIME = 4;
    private static final int[] SIZES_FORMAT = new int[]{"yyyyMMddHHmmssSSS".length(), "yyyyMMddHHmmss".length(), "yyyyMMdd".length(), "HHmmssSSS".length(), "HHmmss".length()};
    private int format;

    public DatetimeFormat() {
    }

    public DatetimeFormat(int format) {
        this.format = format;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.checkFormat(format);
        this.format = format;
    }

    public String format(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer buffer = this.createStringBuffer(this.format);
        switch (this.format) {
            case 0: {
                this.appendFullDateTime(buffer, calendar);
                break;
            }
            case 1: {
                this.appendDateTime(buffer, calendar);
                break;
            }
            case 2: {
                this.appendDate(buffer, calendar);
                break;
            }
            case 3: {
                this.appendFullTime(buffer, calendar);
                break;
            }
            case 4: {
                this.appendTime(buffer, calendar);
            }
        }
        return buffer.toString();
    }

    public Date parse(String str) {
        if (str == null) {
            return null;
        }
        if (!this.isValidLength(this.format, str)) {
            return null;
        }
        switch (this.format) {
            case 0: {
                return this.parseFullDateTime(str);
            }
            case 1: {
                return this.parseDateTime(str);
            }
            case 2: {
                return this.parseDate(str);
            }
            case 3: {
                return this.parseFullTime(str);
            }
            case 4: {
                return this.parseTime(str);
            }
        }
        return this.parseFullDateTime(str);
    }

    private StringBuffer appendFullDateTime(StringBuffer buffer, Calendar calendar) {
        this.appendDate(buffer, calendar);
        this.appendFullTime(buffer, calendar);
        return buffer;
    }

    private StringBuffer appendDateTime(StringBuffer buffer, Calendar calendar) {
        this.appendDate(buffer, calendar);
        this.appendTime(buffer, calendar);
        return buffer;
    }

    private StringBuffer appendDate(StringBuffer buffer, Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        buffer.append(year);
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
        return buffer;
    }

    private StringBuffer appendFullTime(StringBuffer buffer, Calendar calendar) {
        this.appendTime(buffer, calendar);
        int millis = calendar.get(14);
        if (millis < 10) {
            buffer.append("00");
        } else if (millis < 100) {
            buffer.append('0');
        }
        buffer.append(millis);
        return buffer;
    }

    private StringBuffer appendTime(StringBuffer buffer, Calendar calendar) {
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if (hour < 10) {
            buffer.append('0');
        }
        buffer.append(hour);
        if (minute < 10) {
            buffer.append('0');
        }
        buffer.append(minute);
        if (second < 10) {
            buffer.append('0');
        }
        buffer.append(second);
        return buffer;
    }

    private Date parseFullDateTime(String str) {
        char[] chars = str.toCharArray();
        int year = this.toInt(chars, 0, 4);
        int month = this.toInt(chars, 4, 2);
        int day = this.toInt(chars, 6, 2);
        int hour = this.toInt(chars, 8, 2);
        int minute = this.toInt(chars, 10, 2);
        int second = this.toInt(chars, 12, 2);
        int millis = this.toInt(chars, 14, 3);
        Calendar calendar = Calendar.getInstance();
        this.applyDate(calendar, year, month, day);
        this.applyFullTime(calendar, hour, minute, second, millis);
        return calendar.getTime();
    }

    private Date parseDateTime(String str) {
        char[] chars = str.toCharArray();
        int year = this.toInt(chars, 0, 4);
        int month = this.toInt(chars, 4, 2);
        int day = this.toInt(chars, 6, 2);
        int hour = this.toInt(chars, 8, 2);
        int minute = this.toInt(chars, 10, 2);
        int second = this.toInt(chars, 12, 2);
        int millis = 0;
        Calendar calendar = Calendar.getInstance();
        this.applyDate(calendar, year, month, day);
        this.applyFullTime(calendar, hour, minute, second, millis);
        return calendar.getTime();
    }

    private Date parseDate(String str) {
        char[] chars = str.toCharArray();
        int year = this.toInt(chars, 0, 4);
        int month = this.toInt(chars, 4, 2);
        int day = this.toInt(chars, 6, 2);
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millis = 0;
        Calendar calendar = Calendar.getInstance();
        this.applyDate(calendar, year, month, day);
        this.applyFullTime(calendar, hour, minute, second, millis);
        return calendar.getTime();
    }

    private Date parseFullTime(String str) {
        char[] chars = str.toCharArray();
        int hour = this.toInt(chars, 0, 2);
        int minute = this.toInt(chars, 2, 2);
        int second = this.toInt(chars, 4, 2);
        int millis = this.toInt(chars, 6, 3);
        Calendar calendar = Calendar.getInstance();
        this.applyFullTime(calendar, hour, minute, second, millis);
        return calendar.getTime();
    }

    private Date parseTime(String str) {
        char[] chars = str.toCharArray();
        int hour = this.toInt(chars, 0, 2);
        int minute = this.toInt(chars, 2, 2);
        int second = this.toInt(chars, 4, 2);
        int millis = 0;
        Calendar calendar = Calendar.getInstance();
        this.applyFullTime(calendar, hour, minute, second, millis);
        return calendar.getTime();
    }

    private void applyDate(Calendar calendar, int year, int month, int day) {
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
    }

    private void applyFullTime(Calendar calendar, int hour, int minute, int second, int millis) {
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millis);
    }

    private int toInt(char[] chars, int offset, int count) {
        if (count == 2) {
            int v1 = chars[offset] - 48;
            int v2 = chars[offset + 1] - 48;
            return v1 * 10 + v2;
        }
        if (count == 4) {
            int v1 = chars[offset] - 48;
            int v2 = chars[offset + 1] - 48;
            int v3 = chars[offset + 2] - 48;
            int v4 = chars[offset + 3] - 48;
            return v1 * 1000 + v2 * 100 + v3 * 10 + v4;
        }
        if (count == 3) {
            int v1 = chars[offset] - 48;
            int v2 = chars[offset + 1] - 48;
            int v3 = chars[offset + 2] - 48;
            return v1 * 100 + v2 * 10 + v3;
        }
        if (count == 1) {
            int v1 = chars[offset] - 48;
            return v1;
        }
        return Integer.parseInt(new String(chars, offset, count));
    }

    private StringBuffer createStringBuffer(int format) {
        return new StringBuffer(SIZES_FORMAT[format]);
    }

    private boolean isValidLength(int format, String str) {
        return str.length() == SIZES_FORMAT[format];
    }

    private void checkFormat(int format) {
        if (format < 0 || format > 4) {
            throw new IllegalArgumentException();
        }
    }
}

