/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformGlobals {
    private static final String PROPERTIES_NAME = "x-api.properties";
    private static final String DEFAULT_VALUE_STRING = null;
    private static final char DEFAULT_VALUE_CHAR = ' ';
    private static final int DEFAULT_VALUE_INT = 0;
    private static final boolean DEFAULT_VALUE_BOOLEAN = false;
    private static Map map = new HashMap();

    private PlatformGlobals() {
    }

    public static Object getProperty(String key) {
        return map.get(key);
    }

    public static void setProperty(String key, Object value) {
        map.put(key, value);
    }

    public static void removeProperty(String key) {
        map.remove(key);
    }

    public static String getStringProperty(String key) {
        return PlatformGlobals.getStringProperty(key, DEFAULT_VALUE_STRING);
    }

    public static String getStringProperty(String key, String defaultValue) {
        Object value = PlatformGlobals.getProperty(key);
        return value == null ? defaultValue : value.toString();
    }

    public static char getCharProperty(String key) {
        return PlatformGlobals.getCharProperty(key, ' ');
    }

    public static char getCharProperty(String key, char defaultValue) {
        Object value = PlatformGlobals.getProperty(key);
        if (value instanceof String) {
            String str = value.toString();
            if (str.length() > 1) {
                str = str.trim();
            }
            if (str.length() == 1) {
                return str.charAt(0);
            }
        } else if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return defaultValue;
    }

    public static int getIntProperty(String key) {
        return PlatformGlobals.getIntProperty(key, 0);
    }

    public static int getIntProperty(String key, int defaultValue) {
        Object value = PlatformGlobals.getProperty(key);
        if (value instanceof String) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public static void setProperty(String key, int value) {
        PlatformGlobals.setProperty(key, new Integer(value));
    }

    public static boolean getBooleanProperty(String key) {
        return PlatformGlobals.getBooleanProperty(key, false);
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        Object value = PlatformGlobals.getProperty(key);
        if (value instanceof String) {
            String str = value.toString().toLowerCase();
            return "true".equals(str) || "on".equals(str) || "yes".equals(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static void setProperty(String key, boolean value) {
        PlatformGlobals.setProperty(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void load(URL resource) {
        if (resource == null) {
            return;
        }
        InputStream in = null;
        in = resource.openStream();
        Properties properties = new Properties();
        properties.load(in);
        map.putAll(properties);
        Object var5_4 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                Log log = LogFactory.getLog((Class)PlatformGlobals.class);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Could not load properties file", (Throwable)ex);
                }
                Object var5_5 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static URL getResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return loader.getResource(name);
        }
        catch (Throwable th) {
            Log log = LogFactory.getLog((Class)PlatformGlobals.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not find properties file", th);
            }
            return null;
        }
    }

    static {
        PlatformGlobals.load(PlatformGlobals.getResource(PROPERTIES_NAME));
    }
}

