/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;

public class SequenceReader
extends Reader {
    private Enumeration e;
    private Reader in;

    public SequenceReader(Enumeration e) {
        this.e = e;
        try {
            this.nextReader();
        }
        catch (IOException ex) {
            throw new Error("panic");
        }
    }

    public SequenceReader(Reader first, Reader second) {
        Vector<Reader> v = new Vector<Reader>(2);
        v.addElement(first);
        v.addElement(second);
        this.e = v.elements();
        try {
            this.nextReader();
        }
        catch (IOException ex) {
            throw new Error("panic");
        }
    }

    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int c = this.in.read();
        if (c == -1) {
            this.nextReader();
            return this.read();
        }
        return c;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this.in.read(cbuf, off, len);
        if (n <= 0) {
            this.nextReader();
            return this.read(cbuf, off, len);
        }
        return n;
    }

    public boolean ready() throws IOException {
        if (this.in == null) {
            return false;
        }
        return this.in.ready();
    }

    public void close() throws IOException {
        do {
            this.nextReader();
        } while (this.in != null);
    }

    private void nextReader() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.e.hasMoreElements()) {
            this.in = (Reader)this.e.nextElement();
            if (this.in == null) {
                throw new NullPointerException();
            }
        } else {
            this.in = null;
        }
    }
}

