/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringResource {
    private static final String DEFAULT_BUNDLE_NAME = "local-strings";
    private static Hashtable resources = new Hashtable();
    private ResourceBundle bundle;

    public static synchronized StringResource getResource(Class clazz) {
        return StringResource.getResource(clazz.getPackage().getName());
    }

    public static synchronized StringResource getResource(String packageName) {
        return StringResource.getResource(packageName, DEFAULT_BUNDLE_NAME);
    }

    static synchronized StringResource getResource(Class clazz, String resourceName) {
        return StringResource.getResource(clazz.getPackage().getName(), resourceName);
    }

    static synchronized StringResource getResource(String packageName, String resourceName) {
        String bundleName = packageName + '.' + resourceName;
        StringResource resource = (StringResource)resources.get(bundleName);
        if (resource == null) {
            resource = new StringResource(bundleName);
            resources.put(bundleName, resource);
        }
        return resource;
    }

    private StringResource(String bundleName) {
        block7: {
            try {
                this.bundle = ResourceBundle.getBundle(bundleName);
            }
            catch (MissingResourceException ex) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                } else {
                    try {
                        this.bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl);
                        return;
                    }
                    catch (MissingResourceException innerEx) {
                        // empty catch block
                    }
                }
                Log log = LogFactory.getLog((Class)StringResource.class);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot find resource " + bundleName + " " + cl));
                }
                if (!(cl instanceof URLClassLoader) || !log.isDebugEnabled()) break block7;
                log.debug((Object)((URLClassLoader)cl).getURLs());
            }
        }
    }

    public String getString(String key) {
        return MessageFormat.format(this.getStringInternal(key), null);
    }

    public String getString(String key, Object[] args) {
        String value = this.getStringInternal(key);
        try {
            Object[] nonNullArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                if (nonNullArgs == args) {
                    nonNullArgs = (Object[])args.clone();
                }
                nonNullArgs[i] = "null";
            }
            return MessageFormat.format(value, nonNullArgs);
        }
        catch (IllegalArgumentException ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(value);
            for (int i = 0; i < args.length; ++i) {
                buffer.append(" arg[" + i + "]=" + args[i]);
            }
            return buffer.toString();
        }
    }

    public String getString(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object firstArg, Object secondArg) {
        Object[] args = new Object[]{firstArg, secondArg};
        return this.getString(key, args);
    }

    public String getString(String key, Object firstArg, Object secondArg, Object thirdArg) {
        Object[] args = new Object[]{firstArg, secondArg, thirdArg};
        return this.getString(key, args);
    }

    public String getString(String key, Object firstArg, Object secondArg, Object thirdArg, Object fourthArg) {
        Object[] args = new Object[]{firstArg, secondArg, thirdArg, fourthArg};
        return this.getString(key, args);
    }

    private String getStringInternal(String key) {
        if (key == null) {
            String message = "key is null";
            throw new NullPointerException(message);
        }
        if (this.bundle == null) {
            return key;
        }
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return "Cannot find message associated with key '" + key + "'";
        }
    }
}

