/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringUtils {
    public static int toInt(String str) {
        return StringUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        block3: {
            if (!StringUtils.isEmpty(str)) {
                try {
                    return Integer.parseInt(str);
                }
                catch (NumberFormatException ex) {
                    Log log = LogFactory.getLog((Class)StringUtils.class);
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Converting to type int failed: str=" + str));
                }
            }
        }
        return defaultValue;
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isEmpty(str, true);
    }

    public static boolean isEmpty(String str, boolean isTrim) {
        if (str == null || str.length() == 0) {
            return true;
        }
        if (isTrim) {
            return str.trim().length() == 0;
        }
        return false;
    }

    public static List split(String str, char separator) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        ArrayList<String> list = new ArrayList<String>();
        if (len == 0) {
            return list;
        }
        if (str.indexOf(separator) == -1) {
            list.add(str);
        } else {
            int start = 0;
            while (true) {
                int end;
                if ((end = str.indexOf(separator, start)) == -1) {
                    list.add(str.substring(start, len));
                    break;
                }
                list.add(str.substring(start, end));
                start = end + 1;
            }
        }
        return list;
    }

    public static String leftPad(String str, int max, char ch) {
        int count = max - str.length();
        if (count > 0) {
            StringBuffer buffer = new StringBuffer(max);
            for (int i = 0; i < count; ++i) {
                buffer.append(ch);
            }
            str = buffer.append(str).toString();
        }
        return str;
    }

    private StringUtils() {
    }
}

