/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.datatype.DataType;
import com.nexacro.xapi.data.datatype.DataTypeFactory;
import com.nexacro.xapi.data.datatype.PlatformDataType;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnHeader
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8469749920381404050L;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_CONSTANT = 1;
    private String name;
    private int type;
    private int dataType;
    private int dataSize;
    private Object value;

    public ColumnHeader(String string) {
        this(string, 2, 32);
    }

    public ColumnHeader(String string, int n) {
        this(string, n, DataTypes.getDefaultSize(n));
    }

    public ColumnHeader(String string, int n, int n2) {
        this(string, 0, n, n2, null);
    }

    public ColumnHeader(String string, DataType dataType) {
        this(string, dataType, PlatformDataType.getDefaultSize(dataType));
    }

    public ColumnHeader(String string, DataType dataType, int n) {
        this(string, 0, PlatformDataType.getType(dataType), n, null);
    }

    protected ColumnHeader(String string, Object object) {
        this(string, DataTypes.findType(object), object);
    }

    protected ColumnHeader(String string, int n, Object object) {
        this(string, n, DataTypes.getDefaultSize(n), object);
    }

    protected ColumnHeader(String string, int n, int n2, Object object) {
        this(string, 1, n, n2, object);
    }

    protected ColumnHeader(String string, DataType dataType, Object object) {
        this(string, dataType, PlatformDataType.getDefaultSize(dataType), object);
    }

    protected ColumnHeader(String string, DataType dataType, int n, Object object) {
        this(string, 1, PlatformDataType.getType(dataType), n, object);
    }

    private ColumnHeader(String string, int n, int n2, int n3, Object object) {
        this.setName(string);
        this.setType(n);
        this.setDataType(n2);
        this.setDataSize(n3);
        this.setValue(object);
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.checkName(string);
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    void setType(int n) {
        this.type = n;
    }

    public boolean isConstant() {
        return this.getType() == 1;
    }

    public int getDataType() {
        return this.dataType;
    }

    void setDataType(int n) {
        this.checkDataType(n);
        this.dataType = n;
    }

    public DataType getPlatformDataType() {
        return DataTypeFactory.getPlatformDataType(this.dataType);
    }

    void setPlatformDataType(DataType dataType) {
        this.dataType = PlatformDataType.getType(dataType);
    }

    public int getDataSize() {
        return this.dataSize;
    }

    void setDataSize(int n) {
        this.checkDataSize(n);
        this.dataSize = n;
    }

    protected Object getValue() {
        return this.value;
    }

    protected void setValue(Object object) {
        this.value = object;
    }

    public ColumnHeader getClone() {
        try {
            return (ColumnHeader)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log log = LogFactory.getLog((Class)ColumnHeader.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not clone", (Throwable)cloneNotSupportedException);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object instanceof ColumnHeader) {
            ColumnHeader columnHeader = (ColumnHeader)object;
            return this.name.equals(columnHeader.name) && this.type == columnHeader.type && this.dataType == columnHeader.dataType && this.dataSize == columnHeader.dataSize && this.equalsValue(columnHeader);
        }
        return false;
    }

    private boolean equalsValue(ColumnHeader columnHeader) {
        if (this.value == null) {
            return columnHeader.value == null;
        }
        return this.value.equals(columnHeader.value);
    }

    private void checkName(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
    }

    private void checkDataType(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("Invalid data type: " + n);
        }
    }

    private void checkDataSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid data size: " + n);
        }
    }
}

