/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataRow;
import com.nexacro.xapi.data.DataSetDataConverter;
import com.nexacro.xapi.data.DataSetEvent;
import com.nexacro.xapi.data.DataSetListener;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.DefaultDataSetDataConverter;
import com.nexacro.xapi.data.PlatformSsvDataDeserializer;
import com.nexacro.xapi.data.PlatformSsvDataSerializer;
import com.nexacro.xapi.data.PlatformXmlDataDeserializer;
import com.nexacro.xapi.data.PlatformXmlDataSerializer;
import com.nexacro.xapi.data.datatype.DataType;
import com.nexacro.xapi.data.datatype.PlatformDataType;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.util.PlatformGlobals;
import com.nexacro.xapi.util.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8554107363861310920L;
    private transient Log log = null;
    public static final int SAVE_TYPE_NONE = 0;
    public static final int SAVE_TYPE_ALL = 1;
    public static final int SAVE_TYPE_NORMAL = 2;
    public static final int SAVE_TYPE_UPDATED = 3;
    public static final int SAVE_TYPE_DELETED = 4;
    public static final int SAVE_TYPE_CHANGED = 5;
    public static final int SAVE_TYPE_REMOVED = 4;
    public static final int ROW_TYPE_NORMAL = 0;
    public static final int ROW_TYPE_INSERTED = 1;
    public static final int ROW_TYPE_UPDATED = 2;
    public static final int ROW_TYPE_DELETED = 3;
    public static final int ROW_TYPE_REMOVED = 3;
    public static final String ROW_TYPE_NAME_NORMAL = "normal";
    public static final String ROW_TYPE_NAME_INSERTED = "inserted";
    public static final String ROW_TYPE_NAME_UPDATED = "updated";
    public static final String ROW_TYPE_NAME_DELETED = "deleted";
    public static final String ROW_TYPE_NAME_REMOVED = "removed";
    public static final int DEFAULT_SAVE_TYPE = 2;
    private static final String NAME_CHECK_KEY = "platform.data.DataSet.namecheck";
    private static final String DUPLICATED_COLUMN_NAME_CHECK_KEY = "platform.data.DataSet.duplicatedcolumnnamecheck";
    private static final String CONVERTING_TO_DATATYPE_KEY = "platform.data.DataSet.convertingtodatatype";
    private static final String DEFAULT_DATA_CONVERTER_KEY = "platform.data.DataSet.defaultdataconverter";
    private static final String GETTER_DATA_INDEX_CHECK_KEY = "platform.data.DataSet.getterdataindexcheck";
    private static final String SETTER_DATA_INDEX_CHECK_KEY = "platform.data.DataSet.setterdataindexcheck";
    protected List columnList;
    protected List rowList;
    private transient Map columnMap;
    private String name;
    private String alias;
    private String charset;
    private int saveType;
    private EventListenerList listenerList;
    private boolean isStoreDataChanges = true;
    private List savedRowList;
    private List removedRowList;
    private boolean isCheckingGetterDataIndex;
    private boolean isCheckingSetterDataIndex = true;
    private boolean changeStructureWithData;
    private boolean isConvertingToDataType;
    private DataSetDataConverter dataConverter;
    private DataSetDataConverter defaultDataConverter;

    public DataSet() {
        this(null);
    }

    public DataSet(String string) {
        this(string, null);
    }

    public DataSet(String string, String string2) {
        this.name = string;
        this.alias = string2;
        this.saveType = 0;
        this.isConvertingToDataType = PlatformGlobals.getBooleanProperty(CONVERTING_TO_DATATYPE_KEY, true);
        this.isCheckingGetterDataIndex = PlatformGlobals.getBooleanProperty(GETTER_DATA_INDEX_CHECK_KEY, false);
        this.isCheckingSetterDataIndex = PlatformGlobals.getBooleanProperty(SETTER_DATA_INDEX_CHECK_KEY, true);
        this.checkName(string, false);
        this.checkAlias(string2);
        this.columnMap = new HashMap();
        this.setColumnList(this.createColumnList());
        this.setRowList(this.createRowList());
        if (this.isStoreDataChanges()) {
            this.startStoreDataChanges();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.checkName(string, true);
        this.name = string;
    }

    public String getAlias() {
        return this.alias == null ? this.getName() : this.alias;
    }

    public void setAlias(String string) {
        this.checkAlias(string);
        this.alias = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public boolean isCheckingGetterDataIndex() {
        return this.isCheckingGetterDataIndex;
    }

    public void setCheckingGetterDataIndex(boolean bl) {
        this.isCheckingGetterDataIndex = bl;
    }

    public boolean isCheckingSetterDataIndex() {
        return this.isCheckingSetterDataIndex;
    }

    public void setCheckingSetterDataIndex(boolean bl) {
        this.isCheckingSetterDataIndex = bl;
    }

    public boolean canChangeStructureWithData() {
        return this.changeStructureWithData;
    }

    public void setChangeStructureWithData(boolean bl) {
        this.changeStructureWithData = bl;
    }

    public boolean isConvertingToDataType() {
        return this.isConvertingToDataType;
    }

    public void setConvertingToDataType(boolean bl) {
        this.isConvertingToDataType = bl;
    }

    public int getSaveType() {
        return this.saveType;
    }

    public void setSaveType(int n) {
        this.saveType = n;
    }

    public DataSetDataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(DataSetDataConverter dataSetDataConverter) {
        this.dataConverter = dataSetDataConverter;
    }

    public DataSetDataConverter getCurrentDataConverter() {
        if (this.dataConverter == null) {
            if (this.defaultDataConverter == null) {
                block9: {
                    String string = PlatformGlobals.getStringProperty(DEFAULT_DATA_CONVERTER_KEY);
                    if (!StringUtils.isEmpty(string)) {
                        try {
                            Class<?> clazz = Class.forName(string);
                            this.defaultDataConverter = (DataSetDataConverter)clazz.newInstance();
                            this.getLogger();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Creating DataSetDataConverter: type=" + URLEncoder.encode(string, "UTF-8") + ", defaultDataConverter=" + this.defaultDataConverter));
                            }
                        }
                        catch (Throwable throwable) {
                            this.getLogger();
                            if (!this.log.isErrorEnabled()) break block9;
                            try {
                                this.log.error((Object)("Creating DataSetDataConverter failed: type=" + URLEncoder.encode(string, "UTF-8")), throwable);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.defaultDataConverter == null) {
                    this.defaultDataConverter = new DefaultDataSetDataConverter();
                }
            }
            return this.defaultDataConverter;
        }
        return this.dataConverter;
    }

    public int getColumnDataType(String string) {
        ColumnHeader columnHeader = this.getColumn(string);
        return columnHeader == null ? 0 : columnHeader.getDataType();
    }

    public int getColumnDataType(int n) {
        ColumnHeader columnHeader = this.getColumn(n);
        return columnHeader == null ? 0 : columnHeader.getDataType();
    }

    public void setColumnDataType(String string, int n) {
        int n2 = this.indexOfColumn(string);
        if (n2 == -1) {
            throw new IllegalArgumentException("Unknown column header name: " + string);
        }
        this.setColumnDataType(n2, n);
    }

    public void setColumnDataType(int n, int n2) {
        ColumnHeader columnHeader = this.getColumn(n);
        if (columnHeader == null) {
            throw new IllegalArgumentException("Unknown column header index: " + n);
        }
        if (columnHeader.getDataType() == n2) {
            return;
        }
        columnHeader.setDataType(n2);
        if (this.isConvertingToDataType()) {
            this.changeColumnDataType(n, n2);
        }
    }

    private void changeColumnDataType(int n, int n2) {
        this.changeColumnDataType(this.rowList, n, n2, this.charset);
        this.changeColumnDataType(this.savedRowList, n, n2, this.charset);
        this.changeColumnDataType(this.removedRowList, n, n2, this.charset);
    }

    private void changeColumnDataType(List list, int n, int n2, String string) {
        DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
        int n3 = list == null ? -1 : list.size();
        for (int i = 0; i < n3; ++i) {
            DataRow dataRow = (DataRow)list.get(i);
            if (dataRow == null) continue;
            Object object = dataRow.get(n);
            Object object2 = dataSetDataConverter.convert(this, i, n, object, n2, string);
            dataRow.set(n, object2);
        }
    }

    public ColumnHeader getColumn(String string) {
        int n = this.indexOfColumn(string);
        ColumnHeader columnHeader = this.getColumn(n);
        if (columnHeader == null) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("getColumn(String): header=" + columnHeader + ", name=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", index=" + n));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return columnHeader;
    }

    public ColumnHeader getColumn(int n) {
        boolean bl = this.containsColumn(n);
        if (bl) {
            return (ColumnHeader)this.columnList.get(n);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getColumn(int): index=" + n + ", contains=" + bl));
        }
        return null;
    }

    public void addColumn(ColumnHeader columnHeader) {
        this.checkDuplicatedColumn(columnHeader, -1, "add");
        this.increaseColumn(-1, "add");
        int n = this.columnList.size();
        String string = columnHeader.getName();
        this.columnMap.put(string, new Integer(n));
        this.columnList.add(columnHeader);
        this.fireDataSetStructureChanged();
    }

    public void addColumn(String string, int n) {
        this.addColumn(string, n, DataTypes.getDefaultSize(n));
    }

    public void addColumn(String string, int n, int n2) {
        this.addColumn(this.createColumnHeader(string, n, n2));
    }

    public void addColumn(String string, DataType dataType) {
        this.addColumn(string, dataType, PlatformDataType.getDefaultSize(dataType));
    }

    public void addColumn(String string, DataType dataType, int n) {
        this.addColumn(this.createColumnHeader(string, dataType, n));
    }

    public void addConstantColumn(String string, Object object) {
        this.addConstantColumn(string, DataTypes.findType(object), object);
    }

    public void addConstantColumn(String string, int n, Object object) {
        this.addConstantColumn(string, n, DataTypes.getDefaultSize(n), object);
    }

    public void addConstantColumn(String string, int n, int n2, Object object) {
        this.addColumn(this.createConstantColumnHeader(string, n, n2, object));
    }

    public void addConstantColumn(String string, DataType dataType, Object object) {
        this.addConstantColumn(string, dataType, PlatformDataType.getDefaultSize(dataType), object);
    }

    public void addConstantColumn(String string, DataType dataType, int n, Object object) {
        this.addColumn(this.createConstantColumnHeader(string, dataType, n, object));
    }

    public void setColumn(int n, ColumnHeader columnHeader) {
        ColumnHeader columnHeader2 = (ColumnHeader)this.columnList.get(n);
        if (columnHeader2 == columnHeader) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Same header: " + columnHeader));
            }
            return;
        }
        this.checkDuplicatedColumn(columnHeader, n, "set");
        this.clearColumn(n, "set");
        String string = columnHeader2.getName();
        this.columnMap.remove(string);
        String string2 = columnHeader.getName();
        this.columnMap.put(string2, new Integer(n));
        this.columnList.set(n, columnHeader);
        this.fireDataSetStructureChanged();
    }

    public void insertColumn(int n, ColumnHeader columnHeader) {
        this.checkDuplicatedColumn(columnHeader, -1, "insert");
        this.increaseColumn(n, "insert");
        int n2 = this.columnList.size();
        if (n2 == 0 || n2 == n) {
            String string = columnHeader.getName();
            this.columnMap.put(string, new Integer(n));
        } else {
            this.columnMap.clear();
        }
        this.columnList.add(n, columnHeader);
        this.fireDataSetStructureChanged();
    }

    public ColumnHeader removeColumn(String string) {
        return this.removeColumn(this.indexOfColumn(string));
    }

    public ColumnHeader removeColumn(int n) {
        boolean bl = this.hasData();
        boolean bl2 = this.canChangeStructureWithData();
        if (bl && !bl2) {
            throw new IllegalStateException("Unable to remove column: hasData=true, changeStructureWithData=false, index=" + n);
        }
        boolean bl3 = this.containsColumn(n);
        if (bl3) {
            if (bl) {
                this.decreaseColumn(n);
            }
            ColumnHeader columnHeader = (ColumnHeader)this.columnList.remove(n);
            this.columnMap.clear();
            this.fireDataSetStructureChanged();
            return columnHeader;
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("removeColumn(int): index=" + n + ", contains=" + bl3));
        }
        return null;
    }

    public int indexOfColumn(String string) {
        if (string == null || "".equals(string)) {
            return -1;
        }
        this.checkColumnMap();
        Object v = this.columnMap.get(string);
        return v == null ? -1 : (Integer)v;
    }

    public boolean containsColumn(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        this.checkColumnMap();
        return this.columnMap.get(string) != null;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public void copyColumn(ColumnHeader columnHeader) {
        if (this.hasData() && !this.canChangeStructureWithData()) {
            throw new IllegalStateException("Unable to copy column: hasData=true, changeStructureWithData=false");
        }
        String string = columnHeader.getName();
        int n = columnHeader.getDataType();
        int n2 = columnHeader.getDataSize();
        Object object = columnHeader.getValue();
        ColumnHeader columnHeader2 = columnHeader.isConstant() ? this.createConstantColumnHeader(string, n, n2, object) : this.createColumnHeader(string, n, n2);
        this.addColumn(columnHeader2);
    }

    public void copyColumn(int n, ColumnHeader columnHeader) {
        if (this.hasData() && !this.canChangeStructureWithData()) {
            throw new IllegalStateException("Unable to copy column: hasData=true, changeStructureWithData=false, index=" + n);
        }
        String string = columnHeader.getName();
        int n2 = columnHeader.getDataType();
        int n3 = columnHeader.getDataSize();
        Object object = columnHeader.getValue();
        ColumnHeader columnHeader2 = columnHeader.isConstant() ? this.createConstantColumnHeader(string, n2, n3, object) : this.createColumnHeader(string, n2, n3);
        this.setColumn(n, columnHeader2);
    }

    private void increaseColumn(int n, String string) {
        if (this.hasData()) {
            if (this.canChangeStructureWithData()) {
                this.increaseColumn(n);
            } else {
                throw new IllegalStateException("Unable to " + string + " column: hasData=true, changeStructureWithData=false, index=" + n);
            }
        }
    }

    private void increaseColumn(int n) {
        int n2;
        int n3;
        int n4 = this.rowList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Object e = this.rowList.get(n3);
            if (e == null) continue;
            if (n == -1) {
                ((DataRow)e).increase();
                continue;
            }
            ((DataRow)e).increase(n);
        }
        n3 = this.savedRowList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object e = this.savedRowList.get(n2);
            if (e == null) continue;
            if (n == -1) {
                ((DataRow)e).increase();
                continue;
            }
            ((DataRow)e).increase(n);
        }
        n2 = this.removedRowList.size();
        for (int i = 0; i < n2; ++i) {
            Object e = this.removedRowList.get(i);
            if (e == null) continue;
            if (n == -1) {
                ((DataRow)e).increase();
                continue;
            }
            ((DataRow)e).increase(n);
        }
    }

    private void decreaseColumn(int n) {
        int n2;
        int n3;
        int n4 = this.rowList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Object e = this.rowList.get(n3);
            if (e == null) continue;
            if (n == -1) {
                ((DataRow)e).decrease();
                continue;
            }
            ((DataRow)e).decrease(n);
        }
        n3 = this.savedRowList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object e = this.savedRowList.get(n2);
            if (e == null) continue;
            if (n == -1) {
                ((DataRow)e).decrease();
                continue;
            }
            ((DataRow)e).decrease(n);
        }
        n2 = this.removedRowList.size();
        for (int i = 0; i < n2; ++i) {
            Object e = this.removedRowList.get(i);
            if (e == null) continue;
            if (n == -1) {
                ((DataRow)e).decrease();
                continue;
            }
            ((DataRow)e).decrease(n);
        }
    }

    private void clearColumn(int n, String string) {
        if (this.hasData()) {
            if (this.canChangeStructureWithData()) {
                this.clearColumn(n);
            } else {
                throw new IllegalStateException("Unable to " + string + " column: hasData=true, changeStructureWithData=false, index=" + n);
            }
        }
    }

    private void clearColumn(int n) {
        int n2;
        int n3;
        int n4 = this.rowList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Object e = this.rowList.get(n3);
            if (e == null) continue;
            ((DataRow)e).set(n, null);
        }
        n3 = this.savedRowList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object e = this.savedRowList.get(n2);
            if (e == null) continue;
            ((DataRow)e).set(n, null);
        }
        n2 = this.removedRowList.size();
        for (int i = 0; i < n2; ++i) {
            Object e = this.removedRowList.get(i);
            if (e == null) continue;
            ((DataRow)e).set(n, null);
        }
    }

    DataRow getRow(int n) {
        boolean bl = this.containsRow(n);
        if (bl) {
            return (DataRow)this.rowList.get(n);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getRow(int): index=" + n + ", contains=" + bl));
        }
        return null;
    }

    void setRow(int n, DataRow dataRow) {
        DataRow dataRow2 = (DataRow)this.rowList.get(n);
        if (dataRow2 == dataRow) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Same row: " + dataRow));
            }
            return;
        }
        if (this.isStoreDataChanges()) {
            int n2 = dataRow2.getType();
            if (n2 == 0) {
                dataRow.setType(2);
                this.setSavedRow(n, dataRow2);
            } else if (n2 == 1) {
                dataRow.setType(1);
            } else if (n2 == 2) {
                dataRow.setType(2);
            } else {
                this.getLogger();
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("Invalid row type: oldRowType=" + n2));
                }
            }
        } else {
            dataRow.setType(0);
        }
        this.rowList.set(n, dataRow);
        this.fireDataSetDataUpdated(n, n);
    }

    void addRow(DataRow dataRow) {
        if (this.isStoreDataChanges()) {
            dataRow.setType(1);
            this.rowList.add(dataRow);
        } else {
            dataRow.setType(0);
            this.rowList.add(dataRow);
        }
        this.fireDataSetRowInserted(this.rowList.size() - 1, this.rowList.size() - 1);
    }

    void insertRow(int n, DataRow dataRow) {
        if (this.isStoreDataChanges()) {
            dataRow.setType(1);
            this.rowList.add(n, dataRow);
            this.insertSavedRow(n, null);
        } else {
            dataRow.setType(0);
            this.rowList.add(n, dataRow);
        }
        this.fireDataSetRowInserted(n, n);
    }

    public void removeRow(int n) {
        this.removeRow(n, false);
    }

    private void removeRow(int n, boolean bl) {
        boolean bl2 = this.containsRow(n);
        if (bl2) {
            DataRow dataRow = (DataRow)this.rowList.remove(n);
            if (this.isStoreDataChanges() || bl) {
                int n2 = dataRow.getType();
                if (n2 == 0) {
                    this.addRemovedRow(dataRow);
                    this.removeSavedRow(n);
                } else if (n2 == 1) {
                    this.removeSavedRow(n);
                } else if (n2 == 2) {
                    DataRow dataRow2 = this.removeSavedRow(n);
                    this.addRemovedRow(dataRow2);
                } else {
                    this.getLogger();
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)("Invalid row type: " + n2));
                    }
                }
            }
            this.fireDataSetRowRemoved(n, n);
        } else {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("removeRow(int): index=" + n + ", contains=" + bl2));
            }
        }
    }

    public int newRow() {
        this.addRow(this.createRow());
        return this.getRowCount() - 1;
    }

    public int newRow(int n) {
        this.insertRow(n, this.createRow());
        return n;
    }

    DataRow createRow() {
        return new DataRow(this.getColumnCount());
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    void copyRow(DataRow dataRow) {
        DataRow dataRow2 = this.createRow();
        dataRow2.copyFrom(dataRow);
        dataRow2.setType(dataRow.getType());
        this.rowList.add(dataRow2);
    }

    void copyRow(int n, DataRow dataRow) {
        DataRow dataRow2 = this.createRow();
        dataRow2.copyFrom(dataRow);
        dataRow2.setType(dataRow.getType());
        this.rowList.set(n, dataRow2);
    }

    public int getRowType(int n) {
        return this.getRow(n).getType();
    }

    public void setRowType(int n, int n2) {
        DataRow dataRow = this.getRow(n);
        if (this.isStoreDataChanges()) {
            int n3 = dataRow.getType();
            if (n3 == 0) {
                if (n2 != 0) {
                    if (n2 == 1) {
                        dataRow.setType(1);
                    } else if (n2 == 2) {
                        dataRow.setType(2);
                        this.newSavedRow(n);
                    } else if (n2 == 3) {
                        this.removeRow(n);
                    }
                }
            } else if (n3 == 1) {
                if (n2 == 0) {
                    dataRow.setType(0);
                } else if (n2 != 1) {
                    if (n2 == 2) {
                        dataRow.setType(2);
                        this.newSavedRow(n);
                    } else if (n2 == 3) {
                        this.removeRow(n);
                    }
                }
            } else if (n3 == 2) {
                if (n2 == 0) {
                    dataRow.setType(0);
                    this.clearSavedRow(n);
                } else if (n2 == 1) {
                    dataRow.setType(1);
                    this.clearSavedRow(n);
                } else if (n2 != 2 && n2 == 3) {
                    this.removeRow(n);
                }
            }
        } else if (n2 == 0 || n2 == 1 || n2 == 2) {
            dataRow.setType(n2);
        } else if (n2 == 3) {
            this.removeRow(n, true);
        }
    }

    public String getRowTypeName(int n) {
        int n2 = this.getRowType(n);
        if (n2 == 0) {
            return ROW_TYPE_NAME_NORMAL;
        }
        if (n2 == 1) {
            return ROW_TYPE_NAME_INSERTED;
        }
        if (n2 == 2) {
            return ROW_TYPE_NAME_UPDATED;
        }
        if (n2 == 3) {
            return ROW_TYPE_NAME_DELETED;
        }
        if (n2 == 3) {
            return ROW_TYPE_NAME_REMOVED;
        }
        throw new IllegalArgumentException("Invalid row type: index=" + n + ", rowType=" + n2);
    }

    public void setRowTypeName(int n, String string) {
        if (ROW_TYPE_NAME_NORMAL.equals(string)) {
            this.setRowType(n, 0);
        } else if (ROW_TYPE_NAME_INSERTED.equals(string)) {
            this.setRowType(n, 1);
        } else if (ROW_TYPE_NAME_UPDATED.equals(string)) {
            this.setRowType(n, 2);
        } else if (ROW_TYPE_NAME_DELETED.equals(string)) {
            this.setRowType(n, 3);
        } else if (ROW_TYPE_NAME_REMOVED.equals(string)) {
            this.setRowType(n, 3);
        } else {
            throw new IllegalArgumentException("Invalid row type: index=" + n + ", rowType=" + string);
        }
    }

    public Object getObject(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getObject(n, this.indexOfColumn(string));
    }

    public String getString(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getString(n, this.indexOfColumn(string));
    }

    public String getString(int n, String string, String string2) {
        String string3 = this.getString(n, string);
        return string3 == null ? string2 : string3;
    }

    public int getInt(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getInt(n, this.indexOfColumn(string));
    }

    public boolean getBoolean(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getBoolean(n, this.indexOfColumn(string));
    }

    public long getLong(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getLong(n, this.indexOfColumn(string));
    }

    public float getFloat(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getFloat(n, this.indexOfColumn(string));
    }

    public double getDouble(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getDouble(n, this.indexOfColumn(string));
    }

    public BigDecimal getBigDecimal(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getBigDecimal(n, this.indexOfColumn(string));
    }

    public BigDecimal getDecimal(int n, String string) {
        return this.getBigDecimal(n, string);
    }

    public Date getDateTime(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getDateTime(n, this.indexOfColumn(string));
    }

    public byte[] getBlob(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getBlob(n, this.indexOfColumn(string));
    }

    public Object getObject(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toObject(this, n, n2, object);
    }

    public String getString(int n, int n2) {
        Object object = this.getValue(n, n2);
        ColumnHeader columnHeader = this.getColumn(n2);
        int n3 = columnHeader == null ? 0 : columnHeader.getDataType();
        String string = this.getCharset();
        return this.getCurrentDataConverter().toString(this, n, n2, object, n3, string);
    }

    public String getString(int n, int n2, String string) {
        String string2 = this.getString(n, n2);
        return string2 == null ? string : string2;
    }

    public int getInt(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toInt(this, n, n2, object);
    }

    public boolean getBoolean(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toBoolean(this, n, n2, object);
    }

    public long getLong(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toLong(this, n, n2, object);
    }

    public float getFloat(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toFloat(this, n, n2, object);
    }

    public double getDouble(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toDouble(this, n, n2, object);
    }

    public BigDecimal getBigDecimal(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toBigDecimal(this, n, n2, object);
    }

    public BigDecimal getDecimal(int n, int n2) {
        return this.getBigDecimal(n, n2);
    }

    public Date getDateTime(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toDateTime(this, n, n2, object);
    }

    public byte[] getBlob(int n, int n2) {
        Object object = this.getValue(n, n2);
        return this.getCurrentDataConverter().toBlob(this, n, n2, object, this.getCharset());
    }

    public void set(int n, String string, Object object) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), object);
    }

    public void set(int n, String string, String string2) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), string2);
    }

    public void set(int n, String string, int n2) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), n2);
    }

    public void set(int n, String string, boolean bl) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), bl);
    }

    public void set(int n, String string, long l) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), l);
    }

    public void set(int n, String string, float f) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), f);
    }

    public void set(int n, String string, double d) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), d);
    }

    public void set(int n, String string, BigDecimal bigDecimal) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), bigDecimal);
    }

    public void set(int n, String string, Date date) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), date);
    }

    public void set(int n, String string, byte[] byArray) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.set(n, this.indexOfColumn(string), byArray);
    }

    public void set(int n, int n2, Object object) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object2 = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            String string = this.getCharset();
            object2 = dataSetDataConverter.convert(this, n, n2, object, n3, string);
        } else {
            object2 = object;
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object2);
        } else {
            dataRow.set(n2, object2);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, String string) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            String string2 = this.getCharset();
            object = dataSetDataConverter.convert(this, n, n2, string, n3, string2);
        } else {
            object = string;
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, int n3) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n4 = columnHeader.getDataType();
            object = dataSetDataConverter.convert(this, n, n2, n3, n4);
        } else {
            object = new Integer(n3);
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, boolean bl) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            object = dataSetDataConverter.convert(this, n, n2, bl, n3);
        } else {
            Object object2 = object = bl ? Boolean.TRUE : Boolean.FALSE;
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, long l) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            object = dataSetDataConverter.convert(this, n, n2, l, n3);
        } else {
            object = new Long(l);
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, float f) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            object = dataSetDataConverter.convert(this, n, n2, f, n3);
        } else {
            object = new Float(f);
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, double d) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            object = dataSetDataConverter.convert(this, n, n2, d, n3);
        } else {
            object = new Double(d);
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, BigDecimal bigDecimal) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            object = dataSetDataConverter.convert(this, n, n2, bigDecimal, n3);
        } else {
            object = bigDecimal;
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, Date date) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            object = dataSetDataConverter.convert(this, n, n2, date, n3);
        } else {
            object = date;
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public void set(int n, int n2, byte[] byArray) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        ColumnHeader columnHeader = this.getColumn(n2);
        DataRow dataRow = this.getRow(n);
        if (columnHeader == null || dataRow == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(n);
        }
        Object object = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter dataSetDataConverter = this.getCurrentDataConverter();
            int n3 = columnHeader.getDataType();
            String string = this.getCharset();
            object = dataSetDataConverter.convert(this, n, n2, byArray, n3, string);
        } else {
            object = byArray;
        }
        if (columnHeader.isConstant()) {
            columnHeader.setValue(object);
        } else {
            dataRow.set(n2, object);
        }
        this.fireDataSetDataUpdated(n, n, n2);
    }

    public boolean hasData() {
        return this.hasData(true);
    }

    public boolean hasData(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.rowList.isEmpty();
        if (bl) {
            return bl2 || this.hasDataChanges();
        }
        return bl2;
    }

    public void clearData() {
        this.clearData(false);
    }

    public void clearData(boolean bl) {
        if (bl) {
            int n = this.getRowCount();
            if (n > 0) {
                if (this.isStoreDataChanges()) {
                    Iterator iterator = this.rowList.iterator();
                    while (iterator.hasNext()) {
                        DataRow dataRow = (DataRow)iterator.next();
                        dataRow.setType(3);
                    }
                    this.removedRowList.addAll(this.rowList);
                }
                this.rowList.clear();
                this.fireDataSetRowRemoved(0, n - 1);
            }
        } else {
            this.clearDataChanges();
            int n = this.getRowCount();
            if (n > 0) {
                this.rowList.clear();
                this.fireDataSetRowRemoved(0, n - 1);
            }
        }
    }

    public void clear() {
        this.clearData();
        int n = this.columnList.size();
        if (n == 0) {
            return;
        }
        this.columnList.clear();
        this.columnMap.clear();
        this.fireDataSetStructureChanged();
    }

    public void copyTo(DataSet dataSet) {
        this.copyTo(dataSet, true);
    }

    public void copyTo(DataSet dataSet, boolean bl) {
        this.copy(this, dataSet, bl);
    }

    public void copyFrom(DataSet dataSet) {
        this.copyFrom(dataSet, true);
    }

    public void copyFrom(DataSet dataSet, boolean bl) {
        this.copy(dataSet, this, bl);
    }

    public void copyDataTo(DataSet dataSet) {
        this.copyDataTo(dataSet, false);
    }

    public void copyDataTo(DataSet dataSet, boolean bl) {
        this.copyData(this, dataSet, bl);
    }

    public void copyDataFrom(DataSet dataSet) {
        this.copyDataFrom(dataSet, false);
    }

    public void copyDataFrom(DataSet dataSet, boolean bl) {
        this.copyData(dataSet, this, bl);
    }

    public void startStoreDataChanges() {
        this.startStoreDataChanges(false);
    }

    public void startStoreDataChanges(boolean bl) {
        this.isStoreDataChanges = true;
        if (this.savedRowList == null) {
            this.savedRowList = this.createRowList();
        }
        if (this.removedRowList == null) {
            this.removedRowList = this.createRowList();
        }
        if (!bl) {
            this.clearDataChanges();
        }
    }

    public void stopStoreDataChanges() {
        this.stopStoreDataChanges(true);
    }

    public void stopStoreDataChanges(boolean bl) {
        if (this.isStoreDataChanges) {
            this.isStoreDataChanges = false;
        }
        if (!bl) {
            this.clearDataChanges();
        }
    }

    public boolean isStoreDataChanges() {
        return this.isStoreDataChanges;
    }

    public boolean hasDataChanges() {
        return this.hasSavedData() || this.hasRemovedData();
    }

    public void clearDataChanges() {
        this.clearSavedData();
        this.clearRemovedData();
    }

    public void setSavepoint() {
        this.startStoreDataChanges();
    }

    public void setSavepoint(boolean bl) {
        this.startStoreDataChanges(bl);
    }

    public void releaseSavepoint() {
        this.stopStoreDataChanges();
    }

    public void releaseSavepoint(boolean bl) {
        this.stopStoreDataChanges(bl);
    }

    public boolean hasSavepoint() {
        return this.isStoreDataChanges();
    }

    void rollback() {
        throw new UnsupportedOperationException();
    }

    public boolean hasChangedData() {
        return this.hasDataChanges();
    }

    public void clearChangedData() {
        this.clearDataChanges();
    }

    DataRow getSavedRow(int n) {
        if (this.savedRowList == null || n >= this.savedRowList.size()) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                int n2 = this.savedRowList == null ? -1 : this.savedRowList.size();
                this.log.debug((Object)("getSavedRow(int): index=" + n + ", savedRowCount=" + n2));
            }
            return null;
        }
        return (DataRow)this.savedRowList.get(n);
    }

    void setSavedRow(int n, DataRow dataRow) {
        this.checkSavedRowList();
        int n2 = n - this.savedRowList.size();
        if (n2 < 0) {
            this.savedRowList.set(n, dataRow);
        } else if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                this.savedRowList.add(null);
            }
            this.savedRowList.add(dataRow);
        } else {
            this.savedRowList.add(dataRow);
        }
    }

    void insertSavedRow(int n, DataRow dataRow) {
        this.checkSavedRowList();
        int n2 = n - this.savedRowList.size();
        if (dataRow == null) {
            if (n2 < 0) {
                this.savedRowList.add(n, null);
            }
        } else if (n2 < 0) {
            this.savedRowList.add(n, dataRow);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.savedRowList.add(null);
            }
            this.savedRowList.add(dataRow);
        }
    }

    DataRow removeSavedRow(int n) {
        if (this.savedRowList == null || n >= this.savedRowList.size()) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                int n2 = this.savedRowList == null ? -1 : this.savedRowList.size();
                this.log.debug((Object)("removeSavedRow(int): index=" + n + ", savedRowCount=" + n2));
            }
            return null;
        }
        return (DataRow)this.savedRowList.remove(n);
    }

    DataRow clearSavedRow(int n) {
        if (this.savedRowList == null || n >= this.savedRowList.size()) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                int n2 = this.savedRowList == null ? -1 : this.savedRowList.size();
                this.log.debug((Object)("clearSavedRow(int): index=" + n + ", savedRowCount=" + n2));
            }
            return null;
        }
        return this.savedRowList.set(n, null);
    }

    DataRow newSavedRow(int n) {
        DataRow dataRow = this.createRow();
        this.setSavedRow(n, dataRow);
        return dataRow;
    }

    public boolean hasSavedRow(int n) {
        if (this.savedRowList == null || n >= this.savedRowList.size()) {
            return false;
        }
        return this.savedRowList.get(n) != null;
    }

    public int getSavedRowCount() {
        int n;
        int n2 = n = this.savedRowList == null ? 0 : this.savedRowList.size();
        if (n == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.savedRowList.get(i) == null) continue;
            ++n3;
        }
        return n3;
    }

    void copySavedRow(int n, DataRow dataRow) {
        DataRow dataRow2 = this.createRow();
        dataRow2.copyFrom(dataRow);
        dataRow2.setType(dataRow.getType());
        this.setSavedRow(n, dataRow2);
    }

    public void clearSavedData() {
        if (this.savedRowList != null) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                this.getRow(i).setType(0);
            }
            this.savedRowList.clear();
        }
    }

    public boolean hasSavedData() {
        return this.getSavedRowCount() > 0;
    }

    public Object getSavedData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedData(n, this.indexOfColumn(string));
    }

    public String getSavedStringData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedStringData(n, this.indexOfColumn(string));
    }

    public String getSavedStringData(int n, String string, String string2) {
        String string3 = this.getSavedStringData(n, string);
        return string3 == null ? string2 : string3;
    }

    public int getSavedIntData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedIntData(n, this.indexOfColumn(string));
    }

    public boolean getSavedBooleanData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedBooleanData(n, this.indexOfColumn(string));
    }

    public long getSavedLongData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedLongData(n, this.indexOfColumn(string));
    }

    public float getSavedFloatData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedFloatData(n, this.indexOfColumn(string));
    }

    public double getSavedDoubleData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedDoubleData(n, this.indexOfColumn(string));
    }

    public BigDecimal getSavedBigDecimalData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedBigDecimalData(n, this.indexOfColumn(string));
    }

    public BigDecimal getSavedDecimalData(int n, String string) {
        return this.getSavedBigDecimalData(n, string);
    }

    public Date getSavedDateTimeData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedDateTimeData(n, this.indexOfColumn(string));
    }

    public byte[] getSavedBlobData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getSavedBlobData(n, this.indexOfColumn(string));
    }

    public Object getSavedData(int n, int n2) {
        ColumnHeader columnHeader;
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        if ((columnHeader = this.getColumn(n2)) == null) {
            return null;
        }
        if (columnHeader.isConstant()) {
            return columnHeader.getValue();
        }
        DataRow dataRow = this.getSavedRow(n);
        return dataRow == null ? null : dataRow.get(n2);
    }

    public String getSavedStringData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        ColumnHeader columnHeader = this.getColumn(n2);
        int n3 = columnHeader == null ? 0 : columnHeader.getDataType();
        String string = this.getCharset();
        return this.getCurrentDataConverter().toString(this, n, n2, object, n3, string);
    }

    public String getSavedStringData(int n, int n2, String string) {
        String string2 = this.getSavedStringData(n, n2);
        return string2 == null ? string : string2;
    }

    public int getSavedIntData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        return this.getCurrentDataConverter().toInt(this, n, n2, object);
    }

    public boolean getSavedBooleanData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        return this.getCurrentDataConverter().toBoolean(this, n, n2, object);
    }

    public long getSavedLongData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        return this.getCurrentDataConverter().toLong(this, n, n2, object);
    }

    public float getSavedFloatData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        return this.getCurrentDataConverter().toFloat(this, n, n2, object);
    }

    public double getSavedDoubleData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        return this.getCurrentDataConverter().toDouble(this, n, n2, object);
    }

    public BigDecimal getSavedBigDecimalData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        return this.getCurrentDataConverter().toBigDecimal(this, n, n2, object);
    }

    public BigDecimal getSavedDecimalData(int n, int n2) {
        return this.getSavedBigDecimalData(n, n2);
    }

    public Date getSavedDateTimeData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        return this.getCurrentDataConverter().toDateTime(this, n, n2, object);
    }

    public byte[] getSavedBlobData(int n, int n2) {
        Object object = this.getSavedData(n, n2);
        return this.getCurrentDataConverter().toBlob(this, n, n2, object);
    }

    public void setSavedData(int n, String string, Object object) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.setSavedData(n, this.indexOfColumn(string), object);
    }

    public void setSavedData(int n, int n2, Object object) {
        DataRow dataRow;
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        if ((dataRow = this.getSavedRow(n)) == null) {
            dataRow = this.newSavedRow(n);
        }
        dataRow.set(n2, object);
    }

    DataRow getRemovedRow(int n) {
        if (this.removedRowList == null || n >= this.removedRowList.size()) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                int n2 = this.removedRowList == null ? -1 : this.removedRowList.size();
                this.log.debug((Object)("getRemovedRow(int): index=" + n + ", removedRowCount=" + n2));
            }
            return null;
        }
        return (DataRow)this.removedRowList.get(n);
    }

    void addRemovedRow(DataRow dataRow) {
        this.checkRemovedRowList();
        dataRow.setType(3);
        this.removedRowList.add(dataRow);
    }

    public int newRemovedRow() {
        this.checkRemovedRowList();
        DataRow dataRow = this.createRow();
        this.removedRowList.add(dataRow);
        return this.removedRowList.size() - 1;
    }

    public int getRemovedRowCount() {
        return this.removedRowList == null ? 0 : this.removedRowList.size();
    }

    void copyRemovedRow(DataRow dataRow) {
        DataRow dataRow2 = this.createRow();
        dataRow2.copyFrom(dataRow);
        dataRow2.setType(dataRow.getType());
        this.addRemovedRow(dataRow2);
    }

    public void clearRemovedData() {
        if (this.removedRowList != null) {
            this.removedRowList.clear();
        }
    }

    public boolean hasRemovedData() {
        return this.getRemovedRowCount() > 0;
    }

    public Object getRemovedData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedData(n, this.indexOfColumn(string));
    }

    public String getRemovedStringData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedStringData(n, this.indexOfColumn(string));
    }

    public String getRemovedStringData(int n, String string, String string2) {
        String string3 = this.getRemovedStringData(n, string);
        return string3 == null ? string2 : string3;
    }

    public int getRemovedIntData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedIntData(n, this.indexOfColumn(string));
    }

    public boolean getRemovedBooleanData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedBooleanData(n, this.indexOfColumn(string));
    }

    public long getRemovedLongData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedLongData(n, this.indexOfColumn(string));
    }

    public float getRemovedFloatData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedFloatData(n, this.indexOfColumn(string));
    }

    public double getRemovedDoubleData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedDoubleData(n, this.indexOfColumn(string));
    }

    public BigDecimal getRemovedBigDecimalData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedBigDecimalData(n, this.indexOfColumn(string));
    }

    public BigDecimal getRemovedDecimalData(int n, String string) {
        return this.getRemovedBigDecimalData(n, string);
    }

    public Date getRemovedDateTimeData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedDateTimeData(n, this.indexOfColumn(string));
    }

    public byte[] getRemovedBlobData(int n, String string) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(string);
        }
        return this.getRemovedBlobData(n, this.indexOfColumn(string));
    }

    public Object getRemovedData(int n, int n2) {
        ColumnHeader columnHeader;
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRemovedRowIndex(n);
        }
        if ((columnHeader = this.getColumn(n2)) == null) {
            return null;
        }
        if (columnHeader.isConstant()) {
            return columnHeader.getValue();
        }
        DataRow dataRow = this.getRemovedRow(n);
        return dataRow == null ? null : dataRow.get(n2);
    }

    public String getRemovedStringData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        ColumnHeader columnHeader = this.getColumn(n2);
        int n3 = columnHeader == null ? 0 : columnHeader.getDataType();
        String string = this.getCharset();
        return this.getCurrentDataConverter().toString(this, n, n2, object, n3, string);
    }

    public String getRemovedStringData(int n, int n2, String string) {
        String string2 = this.getRemovedStringData(n, n2);
        return string2 == null ? string : string2;
    }

    public int getRemovedIntData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        return this.getCurrentDataConverter().toInt(this, n, n2, object);
    }

    public boolean getRemovedBooleanData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        return this.getCurrentDataConverter().toBoolean(this, n, n2, object);
    }

    public long getRemovedLongData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        return this.getCurrentDataConverter().toLong(this, n, n2, object);
    }

    public float getRemovedFloatData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        return this.getCurrentDataConverter().toFloat(this, n, n2, object);
    }

    public double getRemovedDoubleData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        return this.getCurrentDataConverter().toDouble(this, n, n2, object);
    }

    public BigDecimal getRemovedBigDecimalData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        return this.getCurrentDataConverter().toBigDecimal(this, n, n2, object);
    }

    public BigDecimal getRemovedDecimalData(int n, int n2) {
        return this.getRemovedBigDecimalData(n, n2);
    }

    public Date getRemovedDateTimeData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        return this.getCurrentDataConverter().toDateTime(this, n, n2, object);
    }

    public byte[] getRemovedBlobData(int n, int n2) {
        Object object = this.getRemovedData(n, n2);
        return this.getCurrentDataConverter().toBlob(this, n, n2, object);
    }

    public void setRemovedData(int n, String string, Object object) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(string);
        }
        this.setRemovedData(n, this.indexOfColumn(string), object);
    }

    public void setRemovedData(int n, int n2, Object object) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRemovedRowIndex(n);
        }
        DataRow dataRow = this.getRemovedRow(n);
        dataRow.set(n2, object);
    }

    public void addDataSetListener(DataSetListener dataSetListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("addDataSetListener: " + dataSetListener));
        }
        this.listenerList.add(DataSetListener.class, dataSetListener);
    }

    public void removeDataSetListener(DataSetListener dataSetListener) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            int n = this.listenerList == null ? -1 : this.listenerList.getListenerCount();
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("removeDataSetListener: listenerCount=" + n + ", listener=" + dataSetListener));
            }
            return;
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("removeDataSetListener=" + dataSetListener));
        }
        this.listenerList.remove(DataSetListener.class, dataSetListener);
    }

    public DataSet getClone() {
        try {
            return (DataSet)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not clone", (Throwable)cloneNotSupportedException);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataSet dataSet = (DataSet)super.clone();
        dataSet.columnList = (List)((ArrayList)this.columnList).clone();
        dataSet.rowList = (List)((ArrayList)this.rowList).clone();
        dataSet.savedRowList = this.savedRowList == null ? null : (List)((ArrayList)this.savedRowList).clone();
        dataSet.removedRowList = this.removedRowList == null ? null : (List)((ArrayList)this.removedRowList).clone();
        return dataSet;
    }

    public boolean equals(Object object) {
        DataSet dataSet;
        if (object instanceof DataSet && this.equalsName(dataSet = (DataSet)object) && this.equalsAlias(dataSet) && this.equalsCharset(dataSet) && this.saveType == dataSet.saveType && this.isStoreDataChanges == dataSet.isStoreDataChanges && this.isCheckingGetterDataIndex == dataSet.isCheckingGetterDataIndex && this.isCheckingSetterDataIndex == dataSet.isCheckingSetterDataIndex && this.changeStructureWithData == dataSet.changeStructureWithData && this.isConvertingToDataType == dataSet.isConvertingToDataType && this.equalsDataConverter(dataSet) && this.equalsDefaultDataConverter(dataSet)) {
            return this.equalsStructure(dataSet) && this.equalsData(dataSet);
        }
        return false;
    }

    public boolean equalsStructure(DataSet dataSet) {
        if (dataSet == null) {
            return false;
        }
        if (this.getColumnCount() != dataSet.getColumnCount()) {
            return false;
        }
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (this.getColumn(i).equals(dataSet.getColumn(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsData(DataSet dataSet) {
        return this.equalsData(dataSet, true);
    }

    public boolean hasSameSchemaWith(DataSet dataSet) {
        return this.equalsStructure(dataSet);
    }

    public boolean hasSameDataWith(DataSet dataSet) {
        if (dataSet == null) {
            return false;
        }
        if (this.getColumnCount() != dataSet.getColumnCount()) {
            return false;
        }
        if (this.getRowCount() != dataSet.getRowCount()) {
            return false;
        }
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = this.getValue(i, j);
                Object object2 = dataSet.getValue(i, j);
                if (!(object == null || object2 == null ? object != object2 : !object.toString().equals(object2.toString()))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadXml(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            PlatformXmlDataDeserializer platformXmlDataDeserializer = new PlatformXmlDataDeserializer();
            platformXmlDataDeserializer.readData((Reader)stringReader, this);
            boolean bl = true;
            return bl;
        }
        catch (PlatformException platformException) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not load xml", (Throwable)platformException);
            }
        }
        finally {
            stringReader.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveXml() {
        StringWriter stringWriter = new StringWriter();
        try {
            PlatformXmlDataSerializer platformXmlDataSerializer = new PlatformXmlDataSerializer();
            platformXmlDataSerializer.writeData((Writer)stringWriter, this);
            String string = stringWriter.toString();
            return string;
        }
        catch (PlatformException platformException) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not save xml", (Throwable)platformException);
            }
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSsv(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            PlatformSsvDataDeserializer platformSsvDataDeserializer = new PlatformSsvDataDeserializer();
            platformSsvDataDeserializer.readData((Reader)stringReader, this);
            boolean bl = true;
            return bl;
        }
        catch (PlatformException platformException) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not load ssv", (Throwable)platformException);
            }
        }
        finally {
            stringReader.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveSsv() {
        StringWriter stringWriter = new StringWriter();
        try {
            PlatformSsvDataSerializer platformSsvDataSerializer = new PlatformSsvDataSerializer();
            platformSsvDataSerializer.writeData((Writer)stringWriter, this);
            String string = stringWriter.toString();
            return string;
        }
        catch (PlatformException platformException) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not save ssv", (Throwable)platformException);
            }
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    protected void fireDataSetStructureChanged() {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        DataSetEvent dataSetEvent = new DataSetEvent(this);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$nexacro$xapi$data$DataSetListener == null ? DataSet.class$("com.nexacro.xapi.data.DataSetListener") : class$com$nexacro$xapi$data$DataSetListener)) continue;
            ((DataSetListener)objectArray[i + 1]).structureChanged(dataSetEvent);
        }
    }

    protected void fireDataSetDataUpdated(int n, int n2) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        this.fireDataSetDataUpdated(n, n2, -1);
    }

    protected void fireDataSetDataUpdated(int n, int n2, int n3) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        DataSetEvent dataSetEvent = new DataSetEvent(this, n, n2, n3);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$nexacro$xapi$data$DataSetListener == null ? DataSet.class$("com.nexacro.xapi.data.DataSetListener") : class$com$nexacro$xapi$data$DataSetListener)) continue;
            ((DataSetListener)objectArray[i + 1]).dataUpdated(dataSetEvent);
        }
    }

    protected void fireDataSetRowInserted(int n, int n2) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        DataSetEvent dataSetEvent = new DataSetEvent(this, n, n2);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$nexacro$xapi$data$DataSetListener == null ? DataSet.class$("com.nexacro.xapi.data.DataSetListener") : class$com$nexacro$xapi$data$DataSetListener)) continue;
            ((DataSetListener)objectArray[i + 1]).rowInserted(dataSetEvent);
        }
    }

    protected void fireDataSetRowRemoved(int n, int n2) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        DataSetEvent dataSetEvent = new DataSetEvent(this, n, n2);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$nexacro$xapi$data$DataSetListener == null ? DataSet.class$("com.nexacro.xapi.data.DataSetListener") : class$com$nexacro$xapi$data$DataSetListener)) continue;
            ((DataSetListener)objectArray[i + 1]).rowRemoved(dataSetEvent);
        }
    }

    protected List getColumnList() {
        return this.columnList;
    }

    protected void setColumnList(List list) {
        this.columnList = list;
        this.columnMap.clear();
    }

    List getRowList() {
        return this.rowList;
    }

    void setRowList(List list) {
        this.rowList = list;
    }

    List getSavedRowList() {
        return this.savedRowList;
    }

    void setSavedRowList(List list) {
        this.savedRowList = list;
    }

    List getRemovedRowList() {
        return this.removedRowList;
    }

    void setRemovedRowList(List list) {
        this.removedRowList = list;
    }

    protected List createColumnList() {
        return new ArrayList();
    }

    List createRowList() {
        return new ArrayList();
    }

    protected ColumnHeader createColumnHeader(String string, int n, int n2) {
        return new ColumnHeader(string, n, n2);
    }

    protected ColumnHeader createColumnHeader(String string, DataType dataType, int n) {
        return new ColumnHeader(string, dataType, n);
    }

    protected ConstantColumnHeader createConstantColumnHeader(String string, int n, int n2, Object object) {
        return new ConstantColumnHeader(string, object, n, n2);
    }

    protected ConstantColumnHeader createConstantColumnHeader(String string, DataType dataType, int n, Object object) {
        return new ConstantColumnHeader(string, object, dataType, n);
    }

    private Object getValue(int n, int n2) {
        ColumnHeader columnHeader;
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnIndex(n2);
            this.checkRowIndex(n);
        }
        if ((columnHeader = this.getColumn(n2)) == null) {
            return null;
        }
        if (columnHeader.isConstant()) {
            return columnHeader.getValue();
        }
        DataRow dataRow = this.getRow(n);
        return dataRow == null ? null : dataRow.get(n2);
    }

    private void saveRow(int n) {
        DataRow dataRow = this.getRow(n);
        int n2 = dataRow.getType();
        if (n2 == 0) {
            try {
                DataRow dataRow2 = (DataRow)dataRow.clone();
                dataRow.setType(2);
                this.setSavedRow(n, dataRow2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.getLogger();
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("Could not clone: row=" + dataRow), (Throwable)cloneNotSupportedException);
                }
                DataRow dataRow3 = new DataRow(dataRow.size());
                dataRow.copyTo(dataRow3);
                dataRow.setType(2);
                this.setSavedRow(n, dataRow3);
            }
        } else if (n2 != 1 && n2 != 2) {
            this.getLogger();
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("saveRow(int): rowIndex=" + n + ", rowType=" + n2));
            }
        }
    }

    private void copy(DataSet dataSet, DataSet dataSet2, boolean bl) {
        dataSet2.clear();
        int n = dataSet.getColumnCount();
        for (int i = 0; i < n; ++i) {
            dataSet2.copyColumn(dataSet.getColumn(i));
        }
        if (bl) {
            this.copyData(dataSet, dataSet2, true);
        }
    }

    private void copyData(DataSet dataSet, DataSet dataSet2, boolean bl) {
        int n;
        if (!bl) {
            dataSet2.clearData();
        }
        int n2 = dataSet.getRowCount();
        for (n = 0; n < n2; ++n) {
            dataSet2.copyRow(dataSet.getRow(n));
            DataRow dataRow = dataSet.getSavedRow(n);
            if (dataRow == null) continue;
            dataSet2.copySavedRow(n, dataRow);
        }
        n = dataSet.getRemovedRowCount();
        for (int i = 0; i < n; ++i) {
            dataSet2.copyRemovedRow(dataSet.getRemovedRow(i));
        }
    }

    private boolean equalsName(DataSet dataSet) {
        if (this.name == null) {
            return dataSet.name == null;
        }
        return this.name.equals(dataSet.name);
    }

    private boolean equalsAlias(DataSet dataSet) {
        if (this.alias == null) {
            return dataSet.alias == null;
        }
        return this.alias.equals(dataSet.alias);
    }

    private boolean equalsCharset(DataSet dataSet) {
        if (this.charset == null) {
            return dataSet.charset == null;
        }
        return this.charset.equals(dataSet.charset);
    }

    private boolean equalsDataConverter(DataSet dataSet) {
        if (this.dataConverter == null) {
            return dataSet.dataConverter == null;
        }
        return this.dataConverter.equals(dataSet.dataConverter);
    }

    private boolean equalsDefaultDataConverter(DataSet dataSet) {
        if (this.defaultDataConverter == null) {
            return dataSet.defaultDataConverter == null;
        }
        return this.defaultDataConverter.equals(dataSet.defaultDataConverter);
    }

    private boolean equalsData(DataSet dataSet, boolean bl) {
        int n;
        if (dataSet == null) {
            return false;
        }
        if (this.getColumnCount() != dataSet.getColumnCount()) {
            return false;
        }
        if (this.getRowCount() != dataSet.getRowCount()) {
            return false;
        }
        if (bl && this.getRemovedRowCount() != dataSet.getRemovedRowCount()) {
            return false;
        }
        int n2 = this.getRowCount();
        for (n = 0; n < n2; ++n) {
            if (!this.getRow(n).equals(dataSet.getRow(n))) {
                return false;
            }
            if (!bl || this.getRow(n).getType() != 2 || this.getSavedRow(n).equals(dataSet.getSavedRow(n))) continue;
            return false;
        }
        if (bl) {
            n = this.getRemovedRowCount();
            for (int i = 0; i < n; ++i) {
                if (this.getRemovedRow(i).equals(dataSet.getRemovedRow(i))) continue;
                return false;
            }
        }
        return true;
    }

    private void checkName(String string, boolean bl) {
        if (string == null) {
            if (bl) {
                throw new IllegalArgumentException("No name specified");
            }
            return;
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
        if (PlatformGlobals.getBooleanProperty(NAME_CHECK_KEY, false)) {
            this.checkNaming(string);
        }
    }

    private void checkAlias(String string) {
        if (string == null) {
            return;
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException("No alias specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid alias: \"" + string + "\"");
        }
        if (PlatformGlobals.getBooleanProperty(NAME_CHECK_KEY, false)) {
            this.checkNaming(string);
        }
    }

    private void checkNaming(String string) {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char c = cArray[0];
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$')) {
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
        for (int i = 1; i < n; ++i) {
            c = cArray[i];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$' || c == '-') continue;
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
    }

    private void checkSavedRowList() {
        if (this.savedRowList == null) {
            this.savedRowList = this.createRowList();
        }
    }

    private void checkRemovedRowList() {
        if (this.removedRowList == null) {
            this.removedRowList = this.createRowList();
        }
    }

    private void checkColumnMap() {
        if (!this.columnList.isEmpty() && this.columnMap.isEmpty()) {
            Iterator iterator = this.columnList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ColumnHeader columnHeader = (ColumnHeader)iterator.next();
                String string = columnHeader.getName();
                this.columnMap.put(string, new Integer(n));
                ++n;
            }
        }
    }

    private boolean containsColumn(int n) {
        return this.containsColumn(n, false);
    }

    private boolean containsColumn(int n, boolean bl) {
        int n2 = bl ? this.columnList.size() : this.columnList.size() - 1;
        return n >= 0 && n <= n2;
    }

    private boolean containsRow(int n) {
        return n >= 0 && n < this.rowList.size();
    }

    private boolean containsRemovedRow(int n) {
        return n >= 0 && n < this.getRemovedRowCount();
    }

    private void checkColumnName(String string) {
        if (!this.containsColumn(string)) {
            throw new IllegalArgumentException("Invalid column name: " + string);
        }
    }

    private void checkColumnIndex(int n) {
        if (!this.containsColumn(n)) {
            throw new IndexOutOfBoundsException("Invalid column index value: columnIndex=" + n + ", columnCount=" + this.getColumnCount());
        }
    }

    private void checkDuplicatedColumn(ColumnHeader columnHeader, int n, String string) {
        String string2;
        int n2;
        if (PlatformGlobals.getBooleanProperty(DUPLICATED_COLUMN_NAME_CHECK_KEY, true) && (n2 = this.indexOfColumn(string2 = columnHeader.getName())) != -1 && n2 != n) {
            throw new IllegalStateException("Unable to " + string + " column: duplicatedName=" + string2 + ", duplicatedIndex=" + n2);
        }
    }

    private void checkRowIndex(int n) {
        if (!this.containsRow(n)) {
            throw new IndexOutOfBoundsException("Invalid row index value: rowIndex=" + n + ", rowCount=" + this.getRowCount());
        }
    }

    private void checkRemovedRowIndex(int n) {
        if (!this.containsRemovedRow(n)) {
            throw new IndexOutOfBoundsException("Invalid removed row index value: removedRowIndex=" + n + ", removedRowCount=" + this.getRemovedRowCount());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws Exception {
        objectInputStream.defaultReadObject();
        this.log = LogFactory.getLog((Class)DataSet.class);
        this.columnMap = new HashMap();
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)DataSet.class);
        }
    }
}

