/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.util.PlatformGlobals;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSetList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9146369671625180745L;
    private transient Log log = null;
    private List values = new ArrayList();
    private static final String DUPLICATED_DATASET_NAME_CHECK_KEY = "platform.data.DataSet.duplicateddatasetnamecheck";

    public DataSet get(String string) {
        return this.get(this.indexOf(string));
    }

    public DataSet get(int n) {
        boolean bl = this.contains(n);
        if (bl) {
            return (DataSet)this.values.get(n);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting:index=" + n + ", contains=" + bl + ", values.size()=" + this.values.size()));
        }
        return null;
    }

    public void set(int n, DataSet dataSet) {
        this.checkNameExcludeIndex(dataSet.getName(), n);
        this.values.set(n, dataSet);
    }

    public void add(DataSet dataSet) {
        this.checkName(dataSet.getName());
        this.values.add(dataSet);
    }

    public void insert(int n, DataSet dataSet) {
        this.checkName(dataSet.getName());
        this.values.add(n, dataSet);
    }

    public DataSet remove(String string) {
        return this.remove(this.indexOf(string));
    }

    public DataSet remove(int n) {
        boolean bl = this.contains(n);
        if (bl) {
            return (DataSet)this.values.remove(n);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing: index=" + n + ", contains=" + bl + ", values.size()=" + this.values.size()));
        }
        return null;
    }

    public void clear() {
        this.values.clear();
    }

    public int size() {
        return this.values.size();
    }

    public int indexOf(String string) {
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            DataSet dataSet = (DataSet)this.values.get(i);
            if (!dataSet.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String string) {
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            DataSet dataSet = (DataSet)this.values.get(i);
            if (!dataSet.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public DataSetList getClone() {
        try {
            return (DataSetList)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not clone", (Throwable)cloneNotSupportedException);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataSetList dataSetList = (DataSetList)super.clone();
        dataSetList.values = (List)((ArrayList)this.values).clone();
        int n = dataSetList.values.size();
        for (int i = 0; i < n; ++i) {
            dataSetList.values.set(i, ((DataSet)dataSetList.values.get(i)).clone());
        }
        return dataSetList;
    }

    private boolean contains(int n) {
        return this.contains(n, false);
    }

    private boolean contains(int n, boolean bl) {
        int n2 = bl ? this.values.size() : this.values.size() - 1;
        return n >= 0 && n <= n2;
    }

    private void checkName(String string) {
        this.checkNameExcludeIndex(string, -1);
    }

    private void checkNameExcludeIndex(String string, int n) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
        int n2 = this.values.size();
        for (int i = 0; i < n2; ++i) {
            DataSet dataSet;
            if (i == n || !(dataSet = (DataSet)this.values.get(i)).getName().equals(string)) continue;
            if (PlatformGlobals.getBooleanProperty(DUPLICATED_DATASET_NAME_CHECK_KEY, true)) {
                throw new IllegalArgumentException("Duplicate name: " + string);
            }
            this.values.remove(i);
            break;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws Exception {
        objectInputStream.defaultReadObject();
        this.log = LogFactory.getLog((Class)DataSetList.class);
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)DataSetList.class);
        }
    }
}

