/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;

public class Debugger {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String[] ROW_TYPE_NAMES = new String[]{"normal", "inserted", "updated", "removed"};
    private static final int MAX_LENGTH = 1024;

    public String info(Variable variable) {
        return this.detail(variable);
    }

    public String detail(Variable variable) {
        if (variable == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        String string = variable.getName();
        String string2 = DataTypes.toStringType(variable.getType());
        if (string == null) {
            stringBuffer.append("name=null");
        } else {
            stringBuffer.append("name=").append(string);
        }
        stringBuffer.append(", type=").append(string2);
        stringBuffer.append(", value=");
        if (DataTypes.isBinary(variable.getType())) {
            byte[] byArray = variable.getBlob();
            if (byArray == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append("blob[").append(byArray.length).append(']');
            }
        } else {
            String string3 = variable.getString();
            if (string3 == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append('\"').append(string3).append('\"');
            }
        }
        return stringBuffer.toString();
    }

    public String info(VariableList variableList) {
        return this.detail(variableList);
    }

    public String detail(VariableList variableList) {
        if (variableList == null) {
            return "null";
        }
        int n = variableList.size();
        if (n == 0) {
            return "variable=[]";
        }
        int n2 = 32 + n * 16;
        if (n2 > 1024) {
            n2 = 1024;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append("variable=[").append(NEW_LINE);
        for (int i = 0; i < n; ++i) {
            Object object;
            Variable variable = variableList.get(i);
            String string = variable.getName();
            String string2 = DataTypes.toStringType(variable.getType());
            stringBuffer.append("\t");
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("index=").append(i);
            stringBuffer.append(" (").append(string);
            stringBuffer.append(", ").append(string2);
            if (DataTypes.isBinary(variable.getType())) {
                object = variable.getBlob();
                if (object == null) {
                    stringBuffer.append(", null");
                } else {
                    stringBuffer.append(", blob[").append(((byte[])object).length).append(']');
                }
            } else {
                object = variable.getString();
                if (object == null) {
                    stringBuffer.append(", null");
                } else {
                    stringBuffer.append(", \"").append((String)object).append('\"');
                }
            }
            stringBuffer.append(')').append(NEW_LINE);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String info(DataSet dataSet) {
        if (dataSet == null) {
            return "null";
        }
        int n = dataSet.getColumnCount();
        int n2 = dataSet.getRowCount();
        StringBuffer stringBuffer = new StringBuffer(128);
        String string = dataSet.getName();
        String string2 = dataSet.getAlias();
        String string3 = dataSet.getCharset();
        boolean bl = dataSet.isStoreDataChanges();
        stringBuffer.append("name=").append(string);
        stringBuffer.append(", alias=").append(string2);
        stringBuffer.append(", columnCount=").append(n);
        stringBuffer.append(", rowCount=").append(n2);
        stringBuffer.append(", charset=").append(string3);
        stringBuffer.append(", isStoreDataChanges=").append(bl);
        return stringBuffer.toString();
    }

    public String detail(DataSet dataSet) {
        int n;
        if (dataSet == null) {
            return "null";
        }
        int n2 = dataSet.getColumnCount();
        int n3 = 128 + n2 * 32 + (n = dataSet.getRowCount()) * n2 * 16;
        if (n3 > 1024) {
            n3 = 1024;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        stringBuffer.append(this.info(dataSet));
        this.detailColumnHeaders(dataSet, stringBuffer);
        this.detailDataRows(dataSet, stringBuffer);
        this.detailRemovedDataRows(dataSet, stringBuffer);
        return stringBuffer.toString();
    }

    public String info(DataSetList dataSetList) {
        if (dataSetList == null) {
            return "null";
        }
        int n = dataSetList.size();
        if (n == 0) {
            return "dataset=[]";
        }
        int n2 = n * 128;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append("dataset=[").append(NEW_LINE);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("index=").append(i);
            stringBuffer.append(" (");
            stringBuffer.append(this.info(dataSetList.get(i)));
            stringBuffer.append(')').append(NEW_LINE);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String detail(DataSetList dataSetList) {
        if (dataSetList == null) {
            return "null";
        }
        int n = dataSetList.size();
        int n2 = n * 256;
        if (n2 > 4096) {
            n2 = 4096;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(NEW_LINE);
            }
            stringBuffer.append("---------- ").append("index=").append(this.leftPad(i, 3)).append(" ----------");
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(this.detail(dataSetList.get(i)));
        }
        return stringBuffer.toString();
    }

    public String info(PlatformData platformData) {
        int n;
        if (platformData == null) {
            return "null";
        }
        VariableList variableList = platformData.getVariableList();
        DataSetList dataSetList = platformData.getDataSetList();
        int n2 = variableList.size();
        int n3 = 32 + n2 * 16 + (n = dataSetList.size()) * 128;
        if (n3 > 4096) {
            n3 = 4096;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        stringBuffer.append(this.info(variableList));
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(this.info(dataSetList));
        return stringBuffer.toString();
    }

    public String detail(PlatformData platformData) {
        int n;
        if (platformData == null) {
            return "null";
        }
        VariableList variableList = platformData.getVariableList();
        DataSetList dataSetList = platformData.getDataSetList();
        int n2 = variableList.size();
        int n3 = 32 + n2 * 16 + (n = dataSetList.size()) * 256;
        if (n3 > 4096) {
            n3 = 4096;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        stringBuffer.append(this.detail(variableList));
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(this.detail(dataSetList));
        return stringBuffer.toString();
    }

    private void detailColumnHeaders(DataSet dataSet, StringBuffer stringBuffer) {
        stringBuffer.append(NEW_LINE);
        int n = dataSet.getColumnCount();
        if (n == 0) {
            stringBuffer.append(", column=[]");
            return;
        }
        stringBuffer.append(", column=[").append(NEW_LINE);
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            String string = columnHeader.getName();
            String string2 = DataTypes.toStringType(columnHeader.getDataType());
            int n2 = columnHeader.getDataSize();
            stringBuffer.append("\t");
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("index=").append(i);
            stringBuffer.append(" (").append(string);
            stringBuffer.append(", ").append(string2);
            stringBuffer.append(", ").append(n2);
            if (columnHeader.isConstant()) {
                Object object = ((ConstantColumnHeader)columnHeader).getValue();
                if (object == null) {
                    stringBuffer.append(", null");
                } else {
                    stringBuffer.append(", \"").append(object).append('\"');
                }
            }
            stringBuffer.append(')').append(NEW_LINE);
        }
        stringBuffer.append(']');
    }

    private void detailDataRows(DataSet dataSet, StringBuffer stringBuffer) {
        stringBuffer.append(NEW_LINE);
        int n = dataSet.getColumnCount();
        int n2 = dataSet.getRowCount();
        if (n2 == 0) {
            stringBuffer.append(", row=[]");
            return;
        }
        stringBuffer.append(", row=[").append(NEW_LINE);
        for (int i = 0; i < n2; ++i) {
            int n3;
            Object object;
            int n4;
            int n5 = dataSet.getRowType(i);
            String string = ROW_TYPE_NAMES[n5];
            stringBuffer.append("\t");
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("index=").append(i);
            stringBuffer.append(' ').append(string).append(" (");
            for (n4 = 0; n4 < n; ++n4) {
                if (n4 > 0) {
                    stringBuffer.append(", ");
                }
                if (DataTypes.isBinary(dataSet.getColumn(n4).getDataType())) {
                    object = dataSet.getBlob(i, n4);
                    if (object == null) {
                        stringBuffer.append("null");
                        continue;
                    }
                    stringBuffer.append("blob[").append(((Object)object).length).append(']');
                    continue;
                }
                object = dataSet.getString(i, n4);
                if (object == null) {
                    stringBuffer.append("null");
                    continue;
                }
                n3 = object.length();
                if (n3 > 1024) {
                    stringBuffer.append("string[").append(n3).append("]");
                    continue;
                }
                stringBuffer.append('\"').append((String)object).append('\"');
            }
            stringBuffer.append(')').append(NEW_LINE);
            if (n5 != 2 || !dataSet.hasSavedRow(i)) continue;
            stringBuffer.append("\t\t");
            stringBuffer.append(", index=").append(i);
            stringBuffer.append(" saved (");
            for (n4 = 0; n4 < n; ++n4) {
                if (n4 > 0) {
                    stringBuffer.append(", ");
                }
                if (DataTypes.isBinary(dataSet.getColumn(n4).getDataType())) {
                    object = (byte[])dataSet.getSavedData(i, n4);
                    if (object == null) {
                        stringBuffer.append("null");
                        continue;
                    }
                    stringBuffer.append("blob[").append(((Object)object).length).append(']');
                    continue;
                }
                object = dataSet.getSavedStringData(i, n4);
                if (object == null) {
                    stringBuffer.append("null");
                    continue;
                }
                n3 = object.length();
                if (n3 > 1024) {
                    stringBuffer.append("string[").append(n3).append("]");
                    continue;
                }
                stringBuffer.append('\"').append((String)object).append('\"');
            }
            stringBuffer.append(')').append(NEW_LINE);
        }
        stringBuffer.append(']');
    }

    private void detailRemovedDataRows(DataSet dataSet, StringBuffer stringBuffer) {
        int n = dataSet.getColumnCount();
        int n2 = dataSet.getRemovedRowCount();
        if (n2 == 0) {
            return;
        }
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(", removed row=[").append(NEW_LINE);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("\t");
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("index=").append(i);
            stringBuffer.append(" removed (");
            for (int j = 0; j < n; ++j) {
                Object object;
                if (j > 0) {
                    stringBuffer.append(", ");
                }
                if (DataTypes.isBinary(dataSet.getColumn(j).getDataType())) {
                    object = (byte[])dataSet.getRemovedData(i, j);
                    if (object == null) {
                        stringBuffer.append("null");
                        continue;
                    }
                    stringBuffer.append("blob[").append(((Object)object).length).append(']');
                    continue;
                }
                object = dataSet.getRemovedStringData(i, j);
                if (object == null) {
                    stringBuffer.append("null");
                    continue;
                }
                int n3 = ((String)object).length();
                if (n3 > 1024) {
                    stringBuffer.append("string[").append(n3).append("]");
                    continue;
                }
                stringBuffer.append('\"').append((String)object).append('\"');
            }
            stringBuffer.append(')').append(NEW_LINE);
        }
        stringBuffer.append(']');
    }

    private String leftPad(int n, int n2) {
        String string = String.valueOf(n);
        char c = '0';
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 - string.length();
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

