/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.Base64;
import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.SeperatorReader;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.util.StringUtils;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PlatformSsvDataDeserializer {
    private Log log = LogFactory.getLog((Class)PlatformSsvDataDeserializer.class);
    private char rs = (char)30;
    private char us = (char)31;
    private PlatformData data = null;
    private DataSet ds = null;

    public void readData(Reader reader, PlatformData platformData) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this));
        }
        this.setData(platformData);
        try {
            char[] cArray = this.readHeader(reader);
            String string = this.findEncoding(cArray);
            this.read(reader);
        }
        catch (IOException iOException) {
            String string = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, iOException);
        }
    }

    public void readData(Reader reader, DataSet dataSet) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this));
        }
        this.setDataSet(dataSet);
        this.read(reader);
    }

    void read(Reader reader) throws PlatformException {
        SeperatorReader seperatorReader = new SeperatorReader(reader, this.rs);
        try {
            String string = null;
            while ((string = seperatorReader.readLine()) != null) {
                if (string.length() == 0) continue;
                if (this.isDataSetHeader(string)) {
                    this.readDataSet(seperatorReader, string);
                    continue;
                }
                this.readVariable(seperatorReader, string);
            }
        }
        catch (IOException iOException) {
            String string = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, iOException);
        }
    }

    void setData(PlatformData platformData) {
        this.data = platformData;
    }

    PlatformData getData() {
        return this.data;
    }

    void setDataSet(DataSet dataSet) {
        this.ds = dataSet;
    }

    DataSet getDataSet() {
        return this.ds;
    }

    void readVariable(SeperatorReader seperatorReader, String string) {
        if (this.getData() == null) {
            return;
        }
        List list = this.split(string, this.us);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            int n = string3.indexOf(61);
            if (n <= 0) continue;
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            int n2 = string4.indexOf(58);
            if (n2 > 0) {
                Variable variable;
                int n3;
                String string6;
                string2 = string4.substring(0, n2);
                String string7 = string4.substring(n2 + 1);
                int n4 = string7.indexOf(40);
                int n5 = string7.indexOf(41, n4 + 1);
                if (n4 > 0 && n5 > 0) {
                    string6 = string7.substring(0, n4);
                    n3 = this.getDataType(string6);
                    if (n3 == 2 && this.isNullString(string5)) {
                        string5 = null;
                    }
                    variable = new Variable(string2, n3, (Object)string5);
                    this.getData().addVariable(variable);
                    continue;
                }
                string6 = string7;
                n3 = this.getDataType(string6);
                if (n3 == 2 && this.isNullString(string5)) {
                    string5 = null;
                }
                variable = new Variable(string2, n3, (Object)string5);
                this.getData().addVariable(variable);
                continue;
            }
            string2 = string4;
            int n6 = 2;
            if (this.isNullString(string5)) {
                string5 = null;
            }
            Variable variable = new Variable(string2, n6, (Object)string5);
            this.getData().addVariable(variable);
        }
    }

    void readDataSet(SeperatorReader seperatorReader, String string) throws IOException {
        int n = string.indexOf(58);
        String string2 = string.substring(n + 1);
        DataSet dataSet = this.getDataSet();
        if (dataSet == null) {
            dataSet = new DataSet(string2);
        }
        int n2 = dataSet.getColumnCount();
        boolean bl = dataSet.isStoreDataChanges();
        boolean bl2 = dataSet.isCheckingSetterDataIndex();
        if (bl) {
            dataSet.stopStoreDataChanges();
        }
        if (bl2) {
            dataSet.setCheckingSetterDataIndex(false);
        }
        String string3 = null;
        while ((string3 = seperatorReader.readLine()) != null && string3.length() != 0) {
            if (this.isConstantColumnHeader(string3)) {
                this.readConstantColumnHeader(string3, dataSet);
                continue;
            }
            if (this.isDefaultColumnHeader(string3)) {
                this.readDefaultColumnHeader(string3, dataSet, n2);
                continue;
            }
            this.readDataRow(string3, dataSet, n2);
        }
        if (bl) {
            dataSet.startStoreDataChanges(true);
        }
        if (bl2) {
            dataSet.setCheckingSetterDataIndex(true);
        }
        if (this.getData() != null) {
            this.getData().addDataSet(dataSet);
        }
    }

    private void readConstantColumnHeader(String string, DataSet dataSet) {
        List list = this.split(string, this.us);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            int n = string3.indexOf(61);
            if (n <= 0) continue;
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            int n2 = string4.indexOf(58);
            if (n2 > 0) {
                String string6;
                string2 = string4.substring(0, n2);
                String string7 = string4.substring(n2 + 1);
                int n3 = string7.indexOf(40);
                int n4 = string7.indexOf(41, n3 + 1);
                if (n3 > 0 && n4 > 0) {
                    string6 = string7.substring(0, n3);
                    String string8 = string7.substring(n3 + 1, n4);
                    int n5 = this.getDataType(string6);
                    int n6 = StringUtils.toInt(string8, DataTypes.getDefaultSize(n5));
                    dataSet.addConstantColumn(string2, n5, n6, (Object)string5);
                    continue;
                }
                string6 = string7;
                int n7 = this.getDataType(string6);
                dataSet.addConstantColumn(string2, n7, (Object)string5);
                continue;
            }
            string2 = string4;
            int n8 = 2;
            dataSet.addConstantColumn(string2, n8, (Object)string5);
        }
    }

    private void readDefaultColumnHeader(String string, DataSet dataSet, int n) {
        List list = this.split(string, this.us);
        Iterator iterator = list.iterator();
        iterator.next();
        int n2 = n;
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            int n3 = string3.indexOf(58);
            if (n3 > 0) {
                String string4;
                string2 = string3.substring(0, n3);
                String string5 = string3.substring(n3 + 1);
                int n4 = string5.indexOf(40);
                int n5 = string5.indexOf(41, n4 + 1);
                if (n4 > 0 && n5 > 0) {
                    string4 = string5.substring(0, n4);
                    String string6 = string5.substring(n4 + 1, n5);
                    int n6 = this.getDataType(string4);
                    int n7 = StringUtils.toInt(string6, DataTypes.getDefaultSize(n6));
                    dataSet.insertColumn(n2, new ColumnHeader(string2, n6, n7));
                } else {
                    string4 = string5;
                    int n8 = this.getDataType(string4);
                    dataSet.insertColumn(n2, new ColumnHeader(string2, n8));
                }
            } else {
                string2 = string3;
                int n9 = 2;
                dataSet.insertColumn(n2, new ColumnHeader(string2, n9));
            }
            ++n2;
        }
    }

    private void readDataRow(String string, DataSet dataSet, int n) {
        List list = this.split(string, this.us);
        Iterator iterator = list.iterator();
        String string2 = (String)iterator.next();
        if (string2.length() == 1) {
            char c = string2.charAt(0);
            if (c == 'O') {
                int n2 = dataSet.getRowCount() - 1;
                int n3 = dataSet.getColumnCount();
                for (int i = n; iterator.hasNext() && i < n3; ++i) {
                    Object e = iterator.next();
                    if (this.isNullString(e)) {
                        e = null;
                    }
                    if (DataTypes.isBinary(dataSet.getColumnDataType(i)) && e != null) {
                        dataSet.setSavedData(n2, i, (Object)Base64.decode(e.toString()));
                        continue;
                    }
                    dataSet.setSavedData(n2, i, e);
                }
            } else if (c == 'N' || c == 'I' || c == 'U' || c == 'D') {
                int n4 = dataSet.newRow();
                int n5 = dataSet.getColumnCount();
                for (int i = n; iterator.hasNext() && i < n5; ++i) {
                    Object e = iterator.next();
                    if (this.isNullString(e)) {
                        e = null;
                    }
                    if (DataTypes.isBinary(dataSet.getColumnDataType(i)) && e != null) {
                        dataSet.set(n4, i, Base64.decode(e.toString()));
                        continue;
                    }
                    dataSet.set(n4, i, e);
                }
                if (c == 'N') {
                    dataSet.setRowType(n4, 0);
                } else if (c == 'I') {
                    dataSet.setRowType(n4, 1);
                } else if (c == 'U') {
                    dataSet.setRowType(n4, 2);
                } else if (c == 'D') {
                    dataSet.setRowType(n4, 3);
                }
            }
        } else if (this.log.isWarnEnabled()) {
            int n6 = dataSet.getRowCount();
            this.log.warn((Object)("Invalid SSV row type: rowType=" + string2 + ", rowCount=" + n6));
            this.log.warn((Object)("Invalid SSV row type: str=" + string));
        }
    }

    private boolean isConstantColumnHeader(String string) {
        return string.startsWith("_Const_");
    }

    private boolean isDefaultColumnHeader(String string) {
        return string.startsWith("_RowType_");
    }

    private boolean isDataSetHeader(String string) {
        return string.startsWith("Dataset:");
    }

    private char[] readHeader(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        do {
            n = reader.read();
            charArrayWriter.write(n);
        } while (n != -1 && n != this.rs);
        charArrayWriter.close();
        return charArrayWriter.toCharArray();
    }

    private String findEncoding(char[] cArray) {
        return this.findEncoding(new String(cArray));
    }

    private String findEncoding(String string) {
        int n;
        int n2;
        String string2;
        String string3 = "SSV:";
        int n3 = string.indexOf(string3);
        if (n3 == 0 && (string2 = string.substring(n2 = n3 + string3.length(), n = string.length()).trim()).length() > 0) {
            return string2;
        }
        return null;
    }

    private List split(String string, char c) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n2;
            if ((n2 = string.indexOf(c, n)) == -1) break;
            int n3 = n2;
            arrayList.add(string.substring(n, n3));
            n = n3 + 1;
        }
        arrayList.add(string.substring(n));
        return arrayList;
    }

    private int getDataType(String string) {
        if ("binary".equalsIgnoreCase(string)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(string)) {
            return 7;
        }
        return DataTypes.toIntType(string);
    }

    private boolean isNullString(String string) {
        return string.length() == 1 && string.charAt(0) == '\u0003';
    }

    private boolean isNullString(Object object) {
        String string;
        if (object == null) {
            return true;
        }
        return object instanceof String && (string = (String)object).length() == 1 && string.charAt(0) == '\u0003';
    }
}

