/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.Base64;
import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformCodec;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.PlatformException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PlatformSsvDataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformSsvDataSerializer.class);
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private byte[] buffer;
    private char rs = (char)30;
    private char us = (char)31;
    private char etx = (char)3;

    public void writeData(Writer writer, PlatformData platformData) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this));
        }
        try {
            this.write(writer, platformData);
        }
        catch (IOException iOException) {
            String string = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    public void writeData(Writer writer, DataSet dataSet) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this));
        }
        try {
            this.write(writer, dataSet);
        }
        catch (IOException iOException) {
            String string = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    void write(Writer writer, PlatformData platformData) throws IOException {
        this.writeHeader(writer, platformData);
        this.writeVariableList(writer, platformData);
        this.writeDataSetList(writer, platformData);
        writer.flush();
    }

    void write(Writer writer, DataSet dataSet) throws IOException {
        this.writeDataSet(writer, null, dataSet);
        writer.flush();
    }

    void writeHeader(Writer writer, PlatformData platformData) throws IOException {
        this.writeString(writer, "SSV");
    }

    void writeVariableList(Writer writer, PlatformData platformData) throws IOException {
        VariableList variableList = platformData.getVariableList();
        int n = variableList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + n));
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.writeVariable(writer, variableList.get(i));
            }
        }
    }

    void writeVariable(Writer writer, Variable variable) throws IOException {
        if (DataTypes.isBinary(variable.getType())) {
            this.writeBinaryVariable(writer, variable);
        } else {
            this.writeStringVariable(writer, variable);
        }
    }

    void writeStringVariable(Writer writer, Variable variable) throws IOException {
        String string = variable.getName();
        String string2 = this.getDataType(variable.getType());
        String string3 = this.getStringValue(variable);
        int n = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n + 32);
        if (string3 == null) {
            if (variable.getType() == 2) {
                stringBuffer.append(string).append(':').append(string2).append('=').append(this.etx);
            } else {
                stringBuffer.append(string).append(':').append(string2).append('=');
            }
        } else {
            stringBuffer.append(string).append(':').append(string2).append('=').append(string3);
        }
        this.writeString(writer, stringBuffer.toString());
    }

    void writeBinaryVariable(Writer writer, Variable variable) throws IOException {
        String string = variable.getName();
        String string2 = this.getDataType(variable.getType());
        byte[] byArray = this.getBinaryValue(variable);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append(string).append(':').append(string2).append('=');
            this.writeString(writer, stringBuffer.toString());
        } else {
            String string3 = Base64.encodeBytes(byArray, 8);
            int n = string3 == null ? 0 : string3.length();
            StringBuffer stringBuffer = new StringBuffer(n + 32);
            stringBuffer.append(string).append(':').append(string2).append('=');
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            this.writeString(writer, stringBuffer.toString());
        }
    }

    String getStringValue(Variable variable) {
        int n = variable.getType();
        if (n == 4) {
            return variable.getBoolean() ? "1" : "0";
        }
        String string = variable.getString();
        if (string == null) {
            return string;
        }
        if (n == 2) {
            return this.encode(string);
        }
        return string;
    }

    byte[] getBinaryValue(Variable variable) {
        return variable.getBlob();
    }

    void writeDataSetList(Writer writer, PlatformData platformData) throws IOException {
        DataSetList dataSetList = platformData.getDataSetList();
        int n = dataSetList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + n));
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.writeString(writer, "");
            }
            this.writeDataSet(writer, platformData, dataSetList.get(i));
        }
    }

    void writeDataSet(Writer writer, PlatformData platformData, DataSet dataSet) throws IOException {
        String string = dataSet.getName();
        String string2 = dataSet.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + string + ", alias=" + string2 + ", columnCount=" + dataSet.getColumnCount() + ", rowCount=" + dataSet.getRowCount() + ", removedRowCount=" + dataSet.getRemovedRowCount()));
        }
        this.writeString(writer, "Dataset:" + string2);
        this.writeColumns(writer, dataSet);
        this.writeRows(writer, platformData, dataSet);
    }

    void writeColumns(Writer writer, DataSet dataSet) throws IOException {
        int n = dataSet.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.getType() == 0) {
                this.writeDefaultColumnHeader(stringBuffer, columnHeader);
                continue;
            }
            if (columnHeader.getType() == 1) {
                this.writeConstantColumnHeader(stringBuffer2, dataSet, columnHeader);
                continue;
            }
            throw new IOException("Invalid column type: " + columnHeader.getType());
        }
        if (stringBuffer2.length() > 0) {
            this.writeString(writer, "_Const_" + stringBuffer2.toString());
        }
        if (stringBuffer.length() > 0) {
            this.writeString(writer, "_RowType_" + stringBuffer.toString());
        }
    }

    void writeDefaultColumnHeader(StringBuffer stringBuffer, ColumnHeader columnHeader) throws IOException {
        String string = columnHeader.getName();
        int n = columnHeader.getDataType();
        String string2 = this.getDataType(n);
        int n2 = columnHeader.getDataSize();
        stringBuffer.append(this.us);
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        stringBuffer.append('(');
        stringBuffer.append(n2);
        stringBuffer.append(')');
    }

    void writeConstantColumnHeader(StringBuffer stringBuffer, DataSet dataSet, ColumnHeader columnHeader) throws IOException {
        if (DataTypes.isBinary(columnHeader.getDataType())) {
            this.writeBinaryColumnHeader(stringBuffer, dataSet, (ConstantColumnHeader)columnHeader);
        } else {
            this.writeStringColumnHeader(stringBuffer, dataSet, (ConstantColumnHeader)columnHeader);
        }
    }

    void writeStringColumnHeader(StringBuffer stringBuffer, DataSet dataSet, ConstantColumnHeader constantColumnHeader) throws IOException {
        String string = constantColumnHeader.getName();
        int n = constantColumnHeader.getDataType();
        String string2 = this.getDataType(n);
        int n2 = constantColumnHeader.getDataSize();
        String string3 = this.getStringValue(dataSet, constantColumnHeader);
        stringBuffer.append(this.us);
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        stringBuffer.append('(');
        stringBuffer.append(n2);
        stringBuffer.append(')');
        stringBuffer.append('=');
        if (string3 != null) {
            stringBuffer.append(string3);
        }
    }

    void writeBinaryColumnHeader(StringBuffer stringBuffer, DataSet dataSet, ConstantColumnHeader constantColumnHeader) throws IOException {
        String string = constantColumnHeader.getName();
        int n = constantColumnHeader.getDataType();
        String string2 = this.getDataType(n);
        int n2 = constantColumnHeader.getDataSize();
        byte[] byArray = this.getBinaryValue(dataSet, constantColumnHeader);
        stringBuffer.append(this.us);
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        stringBuffer.append('(');
        stringBuffer.append(n2);
        stringBuffer.append(')');
        stringBuffer.append('=');
        if (byArray != null) {
            String string3 = Base64.encodeBytes(byArray, 8);
            stringBuffer.append(string3);
        }
    }

    String getStringValue(DataSet dataSet, ConstantColumnHeader constantColumnHeader) {
        int n = constantColumnHeader.getDataType();
        if (n == 4) {
            return constantColumnHeader.getBooleanValue(dataSet) ? "1" : "0";
        }
        String string = constantColumnHeader.getStringValue(dataSet);
        if (string == null) {
            return string;
        }
        if (n == 2) {
            return this.encode(string);
        }
        return string;
    }

    byte[] getBinaryValue(DataSet dataSet, ConstantColumnHeader constantColumnHeader) {
        return constantColumnHeader.getBlobValue(dataSet);
    }

    void writeRows(Writer writer, PlatformData platformData, DataSet dataSet) throws IOException {
        int n;
        boolean bl;
        int n2 = dataSet.getSaveType();
        if (n2 == 0) {
            int n3 = n2 = platformData == null ? 2 : platformData.getSaveType();
        }
        if (n2 == 0) {
            n2 = 2;
        }
        int n4 = dataSet.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + n4));
        }
        if (bl = dataSet.isCheckingGetterDataIndex()) {
            dataSet.setCheckingGetterDataIndex(false);
        }
        for (n = 0; n < n4; ++n) {
            this.writeRow(writer, dataSet, n, n2);
        }
        if (n2 == 1 || n2 == 4 || n2 == 5) {
            n = dataSet.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + n));
            }
            for (int i = 0; i < n; ++i) {
                this.writeRemovedRow(writer, dataSet, i);
            }
        }
        if (bl) {
            dataSet.setCheckingGetterDataIndex(true);
        }
    }

    void writeRow(Writer writer, DataSet dataSet, int n, int n2) throws IOException {
        int n3 = dataSet.getRowType(n);
        if (n2 != 1 && (n2 == 2 ? n3 == 3 : (n2 == 3 ? n3 == 0 || n3 == 3 : (n2 == 4 ? n3 == 0 || n3 == 1 || n3 == 2 : n2 == 5 && n3 == 0)))) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 2) {
            stringBuffer.append('N');
        } else if (n3 == 1) {
            stringBuffer.append('I');
        } else if (n3 == 2) {
            stringBuffer.append('U');
        } else if (n3 == 3) {
            stringBuffer.append('D');
        } else {
            stringBuffer.append('N');
        }
        int n4 = dataSet.getColumnCount();
        for (int i = 0; i < n4; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            int n5 = columnHeader.getDataType();
            int n6 = columnHeader.getDataType();
            if (n6 == 13 || DataTypes.isBinary(n6)) {
                byte[] byArray = object = n5 == 13 ? this.getBinaryValueFromFile(dataSet, n, i, n6) : this.getBinaryValue(dataSet, n, i);
                if (object == null) {
                    stringBuffer.append(this.us);
                    continue;
                }
                stringBuffer.append(this.us);
                String string = Base64.encodeBytes(object, 8);
                stringBuffer.append(string);
                continue;
            }
            object = n5 == 13 ? this.getStringValueFromFile(dataSet, n, i, n6) : this.getStringValue(dataSet, n, i);
            if (object == null) {
                if (n6 == 2) {
                    stringBuffer.append(this.us).append(this.etx);
                    continue;
                }
                stringBuffer.append(this.us);
                continue;
            }
            stringBuffer.append(this.us);
            stringBuffer.append((String)object);
        }
        this.writeString(writer, stringBuffer.toString());
        if ((n2 == 1 || n2 == 3 || n2 == 5) && n3 == 2) {
            this.writeSavedRow(writer, dataSet, n);
        }
    }

    void writeSavedRow(Writer writer, DataSet dataSet, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('O');
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            int n3 = columnHeader.getDataType();
            int n4 = columnHeader.getDataType();
            if (n4 == 13 || DataTypes.isBinary(n4)) {
                byte[] byArray = object = n3 == 13 ? this.getSavedBinaryValueFromFile(dataSet, n, i, n4) : this.getSavedBinaryValue(dataSet, n, i);
                if (object == null) {
                    stringBuffer.append(this.us);
                    continue;
                }
                stringBuffer.append(this.us);
                String string = Base64.encodeBytes(object, 8);
                stringBuffer.append(string);
                continue;
            }
            object = n3 == 13 ? this.getSavedStringValueFromFile(dataSet, n, i, n4) : this.getSavedStringValue(dataSet, n, i);
            if (object == null) {
                if (n4 == 2) {
                    stringBuffer.append(this.us).append(this.etx);
                    continue;
                }
                stringBuffer.append(this.us);
                continue;
            }
            stringBuffer.append(this.us);
            stringBuffer.append((String)object);
        }
        this.writeString(writer, stringBuffer.toString());
    }

    void writeRemovedRow(Writer writer, DataSet dataSet, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('D');
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            int n3 = columnHeader.getDataType();
            int n4 = columnHeader.getDataType();
            if (n4 == 13 || DataTypes.isBinary(n4)) {
                byte[] byArray = object = n3 == 13 ? this.getRemovedBinaryValueFromFile(dataSet, n, i, n4) : this.getRemovedBinaryValue(dataSet, n, i);
                if (object == null) {
                    stringBuffer.append(this.us);
                    continue;
                }
                stringBuffer.append(this.us);
                String string = Base64.encodeBytes(object, 8);
                stringBuffer.append(string);
                continue;
            }
            object = n3 == 13 ? this.getRemovedStringValueFromFile(dataSet, n, i, n4) : this.getRemovedStringValue(dataSet, n, i);
            if (object == null) {
                if (n4 == 2) {
                    stringBuffer.append(this.us).append(this.etx);
                    continue;
                }
                stringBuffer.append(this.us);
                continue;
            }
            stringBuffer.append(this.us);
            stringBuffer.append((String)object);
        }
        this.writeString(writer, stringBuffer.toString());
    }

    String getStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getBoolean(n, n2) ? "1" : "0";
        }
        String string = dataSet.getString(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    byte[] getBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getBlob(n, n2);
    }

    String getStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getString(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + string + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    byte[] getBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getString(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + string + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    String getSavedStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getSavedBooleanData(n, n2) ? "1" : "0";
        }
        String string = dataSet.getSavedStringData(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    byte[] getSavedBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getSavedBlobData(n, n2);
    }

    String getSavedStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getSavedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + string + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    byte[] getSavedBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getSavedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + string + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    String getRemovedStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getRemovedBooleanData(n, n2) ? "1" : "0";
        }
        String string = dataSet.getRemovedStringData(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    byte[] getRemovedBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getRemovedBlobData(n, n2);
    }

    String getRemovedStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getRemovedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + string + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    byte[] getRemovedBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getRemovedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + string + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    void writeString(Writer writer, String string) throws IOException {
        writer.write(string);
        writer.write(this.rs);
    }

    String getDataType(int n) {
        if (n == 4) {
            return DataTypes.toStringType(3);
        }
        if (n == 5) {
            return DataTypes.toStringType(8);
        }
        if (n == 7) {
            return DataTypes.toStringType(6);
        }
        if (n == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(n);
    }

    String encode(String string) {
        if (string == null) {
            return string;
        }
        return this.platformCodec.encode(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String string) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.getBuffer();
            try {
                int n;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            finally {
                fileInputStream.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

