/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.Base64;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.util.TypeConverter;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.util.PlatformGlobals;
import com.nexacro.xapi.util.SequenceReader;
import com.nexacro.xapi.util.StringUtils;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class PlatformXmlDataDeserializer
extends DefaultHandler {
    private Log log = LogFactory.getLog((Class)PlatformXmlDataDeserializer.class);
    private static final String PARSER_FACTORY_KEY = "platform.tx.DataDeserializer.platformxml.parserfactory";
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    static final int INDEX_UNDEFINED = 0;
    static final int INDEX_VARIABLE = 1;
    static final int INDEX_DATA_ROW = 2;
    static final int INDEX_DATA_CELL = 3;
    static final int INDEX_SAVED_DATA_ROW = 4;
    static final int INDEX_SAVED_DATA_CELL = 5;
    private static ThreadLocal parserThreadLocal;
    private boolean isEmptyToNull;
    private int index;
    private PlatformData data;
    private Variable var;
    private DataSet ds;
    private boolean isStoreDataChanges;
    private boolean isCheckingSetterDataIndex;
    private String rowType;
    private String columnName;
    private StringBuffer value = new StringBuffer();

    public void readData(Reader reader, PlatformData platformData) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this));
        }
        this.setData(platformData);
        this.init();
        try {
            char[] cArray = this.readHeader(reader);
            String string = this.findEncoding(cArray);
            SequenceReader sequenceReader = new SequenceReader(new CharArrayReader(cArray), reader);
            InputSource inputSource = new InputSource(sequenceReader);
            if (string != null) {
                inputSource.setEncoding(string);
            }
            this.read(inputSource);
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, iOException);
        }
    }

    public void readData(Reader reader, DataSet dataSet) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this));
        }
        this.setCurrentDataSet(dataSet);
        this.init();
        try {
            char[] cArray = this.readHeader(reader);
            String string = this.findEncoding(cArray);
            SequenceReader sequenceReader = new SequenceReader(new CharArrayReader(cArray), reader);
            InputSource inputSource = new InputSource(sequenceReader);
            if (string != null) {
                inputSource.setEncoding(string);
            }
            this.read(inputSource);
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, iOException);
        }
    }

    int getCurrentIndex() {
        return this.index;
    }

    void setCurrentIndex(int n) {
        this.index = n;
    }

    Variable getCurrentVariable() {
        return this.var;
    }

    void setCurrentVariable(Variable variable) {
        this.var = variable;
    }

    DataSet getCurrentDataSet() {
        return this.ds;
    }

    void setCurrentDataSet(DataSet dataSet) {
        this.ds = dataSet;
    }

    String getCurrentRowType() {
        return this.rowType;
    }

    void setCurrentRowType(String string) {
        this.rowType = string;
    }

    String getCurrentColumnName() {
        return this.columnName;
    }

    void setCurrentColumnName(String string) {
        this.columnName = string;
    }

    String getCurrentValue() {
        return this.value.toString();
    }

    void addCurrentValue(char[] cArray, int n, int n2) {
        this.value.append(cArray, n, n2);
    }

    void clearCurrentValue() {
        this.value.setLength(0);
    }

    PlatformData getData() {
        return this.data;
    }

    void setData(PlatformData platformData) {
        this.data = platformData;
    }

    void read(InputSource inputSource) throws PlatformException {
        try {
            SAXParser sAXParser = this.getSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)parserConfigurationException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)sAXException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, sAXException);
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, iOException);
        }
    }

    private char[] readHeader(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        do {
            n = reader.read();
            charArrayWriter.write(n);
        } while (n != -1 && n != 62);
        charArrayWriter.close();
        return charArrayWriter.toCharArray();
    }

    private String findEncoding(char[] cArray) {
        return this.findEncoding(new String(cArray));
    }

    private String findEncoding(String string) {
        String string2;
        int n;
        int n2;
        int n3;
        int n4 = string.indexOf("encoding");
        if (n4 != -1 && (n3 = string.indexOf(61, n4 + 8)) != -1 && (n2 = string.indexOf(34, n3 + 1)) != -1 && (n = string.indexOf(34, ++n2)) != -1 && (string2 = string.substring(n2, n).trim()).length() > 0) {
            return string2;
        }
        return null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("Col".equals(string3)) {
            this.startDataSetCell(attributes);
        } else if ("Row".equals(string3)) {
            this.startDataSetRow(attributes);
        } else if ("OrgRow".equals(string3)) {
            this.startDataSetSavedRow(attributes);
        } else if ("Column".equals(string3)) {
            this.startDataSetDefaultColumn(attributes);
        } else if ("Parameter".equals(string3)) {
            this.startVariable(attributes);
        } else if ("ConstColumn".equals(string3)) {
            this.startDataSetConstantColumn(attributes);
        } else if (!"Rows".equals(string3) && !"ColumnInfo".equals(string3)) {
            if ("Dataset".equals(string3)) {
                this.startDataSet(attributes);
            } else if ("Parameters".equals(string3) || "Root".equals(string3)) {
                // empty if block
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("Col".equals(string3)) {
            this.endDataSetCell();
        } else if ("Row".equals(string3)) {
            this.endDataSetRow();
        } else if ("OrgRow".equals(string3)) {
            this.endDataSetSavedRow();
        } else if ("Column".equals(string3)) {
            this.endDataSetDefaultColumn();
        } else if ("Parameter".equals(string3)) {
            this.endVariable();
        } else if ("ConstColumn".equals(string3)) {
            this.endDataSetConstantColumn();
        } else if ("Rows".equals(string3)) {
            this.endDataSetRowList();
        } else if ("ColumnInfo".equals(string3)) {
            this.endDataSetColumnList();
        } else if ("Dataset".equals(string3)) {
            this.endDataSet();
        } else if ("Parameters".equals(string3)) {
            this.endVariableList();
        } else if ("Root".equals(string3)) {
            this.endData();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = this.getCurrentIndex();
        if (n3 == 1 || n3 == 3 || n3 == 5) {
            this.addCurrentValue(cArray, n, n2);
        }
    }

    void endData() {
        this.setCurrentIndex(0);
    }

    void endVariableList() {
        this.setCurrentIndex(0);
    }

    void startVariable(Attributes attributes) {
        if (this.getData() == null) {
            return;
        }
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("type");
        int n = "binary".equals(string2) ? 12 : DataTypes.toIntType(string2);
        Variable variable = new Variable(string, n);
        this.setCurrentVariable(variable);
        this.setCurrentIndex(1);
    }

    void endVariable() {
        if (this.getData() == null) {
            return;
        }
        Variable variable = this.getCurrentVariable();
        int n = variable.getType();
        String string = this.getCurrentValue();
        if (!this.isNull(string, n)) {
            variable.set(string);
        }
        this.getData().addVariable(variable);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding Variable: " + variable));
        }
        this.setCurrentVariable(null);
        this.clearCurrentValue();
        this.setCurrentIndex(0);
    }

    void startDataSet(Attributes attributes) {
        DataSet dataSet = null;
        if (this.getData() == null) {
            dataSet = this.getCurrentDataSet();
        } else {
            String string = attributes.getValue("id");
            dataSet = new DataSet(string);
            this.setCurrentDataSet(dataSet);
        }
        this.isStoreDataChanges = dataSet.isStoreDataChanges();
        this.isCheckingSetterDataIndex = dataSet.isCheckingSetterDataIndex();
        if (this.isStoreDataChanges) {
            dataSet.stopStoreDataChanges();
        }
        if (this.isCheckingSetterDataIndex) {
            dataSet.setCheckingSetterDataIndex(false);
        }
    }

    void endDataSet() {
        DataSet dataSet = this.getCurrentDataSet();
        if (this.isStoreDataChanges) {
            dataSet.startStoreDataChanges(true);
        }
        if (this.isCheckingSetterDataIndex) {
            dataSet.setCheckingSetterDataIndex(true);
        }
        if (this.getData() != null) {
            this.getData().addDataSet(dataSet);
            this.setCurrentDataSet(null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding DataSet: " + dataSet));
        }
        this.setCurrentIndex(0);
    }

    void endDataSetColumnList() {
        this.setCurrentIndex(0);
    }

    void startDataSetDefaultColumn(Attributes attributes) {
        String string;
        DataSet dataSet = this.getCurrentDataSet();
        if (dataSet.containsColumn(string = attributes.getValue("id"))) {
            return;
        }
        String string2 = attributes.getValue("type");
        String string3 = attributes.getValue("size");
        int n = "binary".equals(string2) ? 12 : DataTypes.toIntType(string2);
        int n2 = StringUtils.toInt(string3, DataTypes.getDefaultSize(n));
        dataSet.addColumn(string, n, n2);
    }

    void endDataSetDefaultColumn() {
        this.setCurrentIndex(0);
    }

    void startDataSetConstantColumn(Attributes attributes) {
        String string;
        DataSet dataSet = this.getCurrentDataSet();
        if (dataSet.containsColumn(string = attributes.getValue("id"))) {
            return;
        }
        String string2 = attributes.getValue("type");
        String string3 = attributes.getValue("size");
        String string4 = attributes.getValue("value");
        int n = "binary".equals(string2) ? 12 : DataTypes.toIntType(string2);
        int n2 = StringUtils.toInt(string3, DataTypes.getDefaultSize(n));
        Object object = DataTypes.isBinary(n) ? Base64.decode(string4) : (Object)TypeConverter.convert(string4, n);
        dataSet.addConstantColumn(string, n, n2, object);
    }

    void endDataSetConstantColumn() {
        this.setCurrentIndex(0);
    }

    void endDataSetRowList() {
        this.setCurrentIndex(0);
    }

    void startDataSetRow(Attributes attributes) {
        DataSet dataSet = this.getCurrentDataSet();
        this.setCurrentRowType(attributes.getValue("type"));
        dataSet.newRow();
        this.setCurrentIndex(2);
    }

    void endDataSetRow() {
        DataSet dataSet = this.getCurrentDataSet();
        String string = this.getCurrentRowType();
        if ("insert".equals(string)) {
            dataSet.setRowType(dataSet.getRowCount() - 1, 1);
        } else if ("update".equals(string)) {
            dataSet.setRowType(dataSet.getRowCount() - 1, 2);
        } else if ("delete".equals(string)) {
            dataSet.setRowType(dataSet.getRowCount() - 1, 3);
        } else {
            dataSet.setRowType(dataSet.getRowCount() - 1, 0);
        }
        this.setCurrentIndex(0);
    }

    void startDataSetSavedRow(Attributes attributes) {
        this.setCurrentIndex(4);
    }

    void endDataSetSavedRow() {
        this.setCurrentIndex(2);
        DataSet dataSet = this.getCurrentDataSet();
        int n = dataSet.getRowCount() - 1;
        if (!dataSet.hasSavedRow(n) && dataSet.getColumnCount() > 0) {
            dataSet.setSavedData(n, 0, null);
        }
    }

    void startDataSetCell(Attributes attributes) {
        String string = attributes.getValue("id");
        this.setCurrentColumnName(string);
        if (this.getCurrentIndex() == 2) {
            this.setCurrentIndex(3);
        } else if (this.getCurrentIndex() == 4) {
            this.setCurrentIndex(5);
        }
    }

    void endDataSetCell() {
        int n = this.getCurrentIndex();
        DataSet dataSet = this.getCurrentDataSet();
        String string = this.getCurrentColumnName();
        String string2 = this.getCurrentValue();
        int n2 = dataSet.getColumn(string).getDataType();
        boolean bl = this.isNull(string2, n2);
        if (n == 3) {
            if (n2 == 13) {
                try {
                    File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                    if (!bl) {
                        this.writeValueToFile(Base64.decode(string2), file);
                    }
                    dataSet.set(dataSet.getRowCount() - 1, string, file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    int n3 = dataSet.getRowCount() - 1;
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("Could not save: rowIndex=" + n3 + ", columnName=" + string), (Throwable)iOException);
                    }
                }
            } else if (!bl) {
                if (DataTypes.isBinary(n2)) {
                    dataSet.set(dataSet.getRowCount() - 1, string, Base64.decode(string2));
                } else {
                    dataSet.set(dataSet.getRowCount() - 1, string, string2);
                }
            }
            this.setCurrentIndex(2);
        } else if (n == 5) {
            if (n2 == 13) {
                try {
                    File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                    if (!bl) {
                        this.writeValueToFile(Base64.decode(string2), file);
                    }
                    dataSet.setSavedData(dataSet.getRowCount() - 1, string, (Object)file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    int n4 = dataSet.getRowCount() - 1;
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("Could not save: rowIndex=" + n4 + ", columnName=" + string), (Throwable)iOException);
                    }
                }
            } else if (!bl) {
                if (DataTypes.isBinary(n2)) {
                    dataSet.setSavedData(dataSet.getRowCount() - 1, string, (Object)Base64.decode(string2));
                } else {
                    dataSet.setSavedData(dataSet.getRowCount() - 1, string, (Object)string2);
                }
            }
            this.setCurrentIndex(4);
        }
        this.setCurrentColumnName(null);
        this.clearCurrentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeValueToFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            fileOutputStream.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving data to file: file=" + file));
        }
    }

    private boolean isNull(String string, int n) {
        return this.isEmptyToNull() && n == 2 && "".equals(string);
    }

    private void init() {
        this.isEmptyToNull = this.getEmptyToNull();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("init: isEmptyToNull=" + this.isEmptyToNull));
        }
    }

    private boolean isEmptyToNull() {
        return this.isEmptyToNull;
    }

    private boolean getEmptyToNull() {
        String string = System.getProperty("xapi.deserializer.data.emptytonull");
        return "true".equals(string);
    }

    private SAXParser getSAXParser() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        String string = PlatformGlobals.getStringProperty(PARSER_FACTORY_KEY);
        if ("threadlocal".equals(string)) {
            return this.getSAXParserFromThreadLocal();
        }
        return this.createSAXParser();
    }

    private SAXParser createSAXParser() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        return sAXParserFactory.newSAXParser();
    }

    private SAXParser getSAXParserFromThreadLocal() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        if (parserThreadLocal == null) {
            parserThreadLocal = new ThreadLocal();
        }
        SAXParser sAXParser = (SAXParser)parserThreadLocal.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting SAXParser: thread=" + Thread.currentThread().getName() + ", parser=" + sAXParser));
        }
        if (sAXParser == null) {
            sAXParser = this.createSAXParser();
            parserThreadLocal.set(sAXParser);
        }
        return sAXParser;
    }
}

