/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import java.math.BigDecimal;
import java.util.Date;

class DoubleTypeConverter {
    public Object toObject(double d) {
        return new Double(d);
    }

    public String toString(double d) {
        return String.valueOf(d);
    }

    public int toInt(double d) {
        return (int)d;
    }

    public boolean toBoolean(double d) {
        return false;
    }

    public long toLong(double d) {
        return (long)d;
    }

    public float toFloat(double d) {
        return (float)d;
    }

    public BigDecimal toBigDecimal(double d) {
        return new BigDecimal(String.valueOf(d));
    }

    public Date toDate(double d) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(double d) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(double d) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(double d) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(double d, int n) {
        switch (n) {
            case 2: {
                return this.toString(d);
            }
            case 3: {
                return new Integer(this.toInt(d));
            }
            case 4: {
                return this.toBoolean(d) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(d));
            }
            case 6: {
                return new Float(this.toFloat(d));
            }
            case 7: {
                return this.toObject(d);
            }
            case 8: {
                return this.toBigDecimal(d);
            }
            case 9: {
                return this.toDate(d);
            }
            case 10: {
                return this.toTime(d);
            }
            case 11: {
                return this.toDateTime(d);
            }
            case 12: {
                return this.toBlob(d);
            }
        }
        return this.toObject(d);
    }
}

