/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import java.math.BigDecimal;
import java.util.Date;

class FloatTypeConverter {
    public Object toObject(float f) {
        return new Float(f);
    }

    public String toString(float f) {
        return String.valueOf(f);
    }

    public int toInt(float f) {
        return (int)f;
    }

    public boolean toBoolean(float f) {
        return false;
    }

    public long toLong(float f) {
        return (long)f;
    }

    public double toDouble(float f) {
        return f;
    }

    public BigDecimal toBigDecimal(float f) {
        return new BigDecimal(String.valueOf(f));
    }

    public Date toDate(float f) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(float f) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(float f) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(float f) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(float f, int n) {
        switch (n) {
            case 2: {
                return this.toString(f);
            }
            case 3: {
                return new Integer(this.toInt(f));
            }
            case 4: {
                return this.toBoolean(f) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(f));
            }
            case 6: {
                return this.toObject(f);
            }
            case 7: {
                return new Double(this.toDouble(f));
            }
            case 8: {
                return this.toBigDecimal(f);
            }
            case 9: {
                return this.toDate(f);
            }
            case 10: {
                return this.toTime(f);
            }
            case 11: {
                return this.toDateTime(f);
            }
            case 12: {
                return this.toBlob(f);
            }
        }
        return this.toObject(f);
    }
}

