/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.util.DateTypeConverter;
import java.math.BigDecimal;
import java.util.Date;

class LongTypeConverter {
    private DateTypeConverter dateConverter = new DateTypeConverter();

    public Object toObject(long l) {
        return new Long(l);
    }

    public String toString(long l) {
        return String.valueOf(l);
    }

    public int toInt(long l) {
        return (int)l;
    }

    public boolean toBoolean(long l) {
        return l != 0L;
    }

    public float toFloat(long l) {
        return l;
    }

    public double toDouble(long l) {
        return l;
    }

    public BigDecimal toBigDecimal(long l) {
        return new BigDecimal(String.valueOf(l));
    }

    public Date toDate(long l) {
        return this.dateConverter.toDate(new Date(l));
    }

    public Date toTime(long l) {
        return this.dateConverter.toTime(new Date(l));
    }

    public Date toDateTime(long l) {
        return new Date(l);
    }

    public byte[] toBlob(long l) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(long l, int n) {
        switch (n) {
            case 2: {
                return this.toString(l);
            }
            case 3: {
                return new Integer(this.toInt(l));
            }
            case 4: {
                return this.toBoolean(l) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.toObject(l);
            }
            case 6: {
                return new Float(this.toFloat(l));
            }
            case 7: {
                return new Double(this.toDouble(l));
            }
            case 8: {
                return this.toBigDecimal(l);
            }
            case 9: {
                return this.toDate(l);
            }
            case 10: {
                return this.toTime(l);
            }
            case 11: {
                return this.toDateTime(l);
            }
            case 12: {
                return this.toBlob(l);
            }
        }
        return this.toObject(l);
    }
}

