/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.util.DateTypeConverter;
import com.nexacro.xapi.util.DatetimeFormat;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringTypeConverter {
    private Log log = null;
    private static String[] VALUES_TRUE = new String[]{"true", "True", "TRUE", "yes", "Yes", "YES", "y", "Y", "on", "On", "ON", "1"};
    private static String[] VALUES_FALSE = new String[]{"false", "false", "false", "no", "No", "NO", "n", "N", "off", "Off", "OFF", "0"};
    private DatetimeFormat datetimeParser = new DatetimeFormat();
    private DateTypeConverter dateConverter = new DateTypeConverter();

    public Object toObject(String string) {
        return string;
    }

    public int toInt(String string) {
        block8: {
            if (this.isValid(string)) {
                if (this.needTrim(string)) {
                    string = string.trim();
                }
                string = this.removeGroupingSeparator(string);
                try {
                    if (string.indexOf(46) == -1) {
                        if (string.startsWith("0x") || string.startsWith("0X")) {
                            return Integer.parseInt(string.substring(2), 16);
                        }
                        return Integer.parseInt(string);
                    }
                    return new BigDecimal(string).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block8;
                    try {
                        this.log.debug((Object)("Converting to type int failed: value=" + URLEncoder.encode(string, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
        }
        return 0;
    }

    public boolean toBoolean(String string) {
        if (this.isValid(string)) {
            String[] stringArray = VALUES_TRUE;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return true;
            }
            String[] stringArray2 = VALUES_FALSE;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals(string)) continue;
                return false;
            }
        }
        return false;
    }

    public long toLong(String string) {
        block7: {
            if (this.isValid(string)) {
                if (this.needTrim(string)) {
                    string = string.trim();
                }
                string = this.removeGroupingSeparator(string);
                try {
                    if (string.indexOf(46) == -1) {
                        return Long.parseLong(string);
                    }
                    return new BigDecimal(string).longValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block7;
                    try {
                        this.log.debug((Object)("Converting to type long failed: value=" + URLEncoder.encode(string, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
        }
        return 0L;
    }

    public float toFloat(String string) {
        block5: {
            if (this.isValid(string)) {
                string = this.removeGroupingSeparator(string);
                try {
                    return Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block5;
                    try {
                        this.log.debug((Object)("Converting to type float failed: value=" + URLEncoder.encode(string, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                }
            }
        }
        return 0.0f;
    }

    public double toDouble(String string) {
        block5: {
            if (this.isValid(string)) {
                string = this.removeGroupingSeparator(string);
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block5;
                    try {
                        this.log.debug((Object)("Converting to type double failed: value=" + URLEncoder.encode(string, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
        }
        return 0.0;
    }

    public BigDecimal toBigDecimal(String string) {
        block5: {
            if (this.isValid(string)) {
                string = this.removeGroupingSeparator(string);
                try {
                    return new BigDecimal(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block5;
                    try {
                        this.log.debug((Object)("Converting to type java.math.BigDecimal failed: value=" + URLEncoder.encode(string, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
        }
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public Date toDate(String string) {
        if (this.isValidDate(string)) {
            return this.dateConverter.toDate(this.parseDate(string));
        }
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(String string) {
        if (this.isValidDate(string)) {
            return this.dateConverter.toTime(this.parseDate(string));
        }
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(String string) {
        if (this.isValidDate(string)) {
            Date date = this.parseDate(string);
            return date;
        }
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(String string) {
        return this.toBlob(string, null);
    }

    public byte[] toBlob(String string, String string2) {
        try {
            if (string == null) {
                return DataTypes.DEFAULT_VALUE_BLOB;
            }
            if (string2 == null) {
                return string.getBytes();
            }
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("Converting to type byte[] failed: value=" + URLEncoder.encode(string, "UTF-8") + ", charset=" + URLEncoder.encode(string2, "UTF-8")), (Throwable)unsupportedEncodingException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    // empty catch block
                }
            }
            return string.getBytes();
        }
    }

    public Object convert(String string, int n) {
        return this.convert(string, n, null);
    }

    public Object convert(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        switch (n) {
            case 2: {
                return string;
            }
            case 3: {
                return new Integer(this.toInt(string));
            }
            case 4: {
                return this.toBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(string));
            }
            case 6: {
                return new Float(this.toFloat(string));
            }
            case 7: {
                return new Double(this.toDouble(string));
            }
            case 8: {
                return this.toBigDecimal(string);
            }
            case 9: {
                return this.toDate(string);
            }
            case 10: {
                return this.toTime(string);
            }
            case 11: {
                return this.toDateTime(string);
            }
            case 12: {
                return this.toBlob(string, string2);
            }
        }
        return string;
    }

    private Date parseDate(String string) {
        int n = string.length();
        if (n == 17) {
            this.datetimeParser.setFormat(0);
        } else if (n == 14) {
            this.datetimeParser.setFormat(1);
        } else if (n == 8) {
            this.datetimeParser.setFormat(2);
        } else if (n == 9) {
            this.datetimeParser.setFormat(3);
        } else {
            this.datetimeParser.setFormat(4);
        }
        Date date = this.datetimeParser.parse(string);
        if (date == null) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("Parsing date failed: value=" + URLEncoder.encode(string, "UTF-8")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            date = DataTypes.DEFAULT_VALUE_DATE_TIME;
        }
        return date;
    }

    private String removeGroupingSeparator(String string) {
        if (string == null || string.indexOf(44) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == ',') continue;
            cArray2[n2++] = cArray[i];
        }
        return new String(cArray2, 0, n2);
    }

    private boolean isValid(String string) {
        return string != null && !"".equals(string);
    }

    private boolean isValidDate(String string) {
        if (this.isValid(string)) {
            int n = string.length();
            return n == 17 || n == 14 || n == 8 || n == 9 || n == 6;
        }
        return false;
    }

    private boolean needTrim(String string) {
        if (string.charAt(0) == ' ') {
            return true;
        }
        int n = string.length();
        return n == 1 ? false : string.charAt(n - 1) == ' ';
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)StringTypeConverter.class);
        }
    }
}

