/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.license;

import com.nexacro.xapi.license.A.D;
import com.nexacro.xapi.license.InvalidLicenseException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class License {
    private Log log = LogFactory.getLog((Class)License.class);
    public static final int TYPE_SERVER = 0;
    public static final int TYPE_CLIENT = 1;
    public static final int TYPE_TOOL = 2;
    public static final int TYPE_NEXUP = 3;
    public static final String KEY_LICENSE_VERSION = "license.version";
    public static final String KEY_PRODUCT_NAME = "product.name";
    public static final String KEY_PRODUCT_VERSION = "product.version";
    public static final String KEY_PRODUCT_FUNCTION = "product.function";
    public static final String KEY_PRODUCT_FUNCTION_BINARY = "product.function.binary";
    public static final String KEY_PRODUCT_LICENSE_TYPE = "product.licenseType";
    public static final String KEY_CUSTOMER_NAME = "customer.name";
    public static final String KEY_CUSTOMER_DEVELOPER_COUNT = "customer.developerCount";
    public static final String KEY_CUSTOMER_DOMAIN = "customer.rootDomain";
    public static final String KEY_CUSTOMER_TARGET_PLATFORM = "customer.targetPlatform";
    public static final String KEY_DATE_ACTIVATION = "date.activation";
    public static final String KEY_DATE_TERM = "date.term";
    public static final String KEY_DATE_TERM_UNIT = "date.term.unit";
    public static final String KEY_SERVER_CPU_CORE_COUNT = "server.cpuCoreCount";
    public static final String KEY_SERVER_IP_ADDRESS = "server.ipAddress";
    public static final String KEY_SERIAL_KEY = "key";
    public static final String PRODUCT_NEXACRO_PLATFORM = "nexacro platform";
    public static final String PRODUCT_XPOP = "X-POP";
    public static final String PRODUCT_XPUSH = "X-PUSH";
    public static final String PRODUCT_XUP = "X-UP";
    public static final String PRODUCT_NEXUP = "Nex-UP";
    private static long defaultActivationTime = 0L;
    private static long defaultExpiredTime = 0L;
    private Map properties = new HashMap();
    private boolean initializedTime;
    private boolean isLimitByTime;
    private long activationTime;
    private long expireTime;
    private boolean initializedFunction;
    private String product;
    private int function;
    private boolean frozen;

    public static License getInstance() {
        return D.C();
    }

    public static License getInstance(int n) {
        return D.B(n);
    }

    public static License load(int n) throws InvalidLicenseException {
        return D.A(n);
    }

    public static License load(int n, URL uRL) throws InvalidLicenseException {
        return D.A(n, uRL);
    }

    public static License load(int n, String string) throws InvalidLicenseException {
        return D.A(n, string);
    }

    public static License load(int n, InputStream inputStream) throws InvalidLicenseException {
        return D.A(n, inputStream);
    }

    public static License load(int n, Properties properties) throws InvalidLicenseException {
        return D.A(n, properties);
    }

    public static boolean isLoaded() {
        return D.B();
    }

    public String getLicenseVersion() {
        return this.getFeature(KEY_LICENSE_VERSION);
    }

    public String getProductName() {
        return this.getFeature(KEY_PRODUCT_NAME);
    }

    public void setProductName(String string) {
        this.addFeature(KEY_PRODUCT_NAME, string);
    }

    public String getProductVersion() {
        return this.getFeature(KEY_PRODUCT_VERSION);
    }

    public void setProductVersion(String string) {
        this.addFeature(KEY_PRODUCT_VERSION, string);
    }

    public String getCustomerName() {
        return this.getFeature(KEY_CUSTOMER_NAME);
    }

    public void setCustomerName(String string) {
        this.addFeature(KEY_CUSTOMER_NAME, string);
    }

    public String getCustomerDomain() {
        return this.getFeature(KEY_CUSTOMER_DOMAIN);
    }

    public void setCustomerDomain(String string) {
        this.addFeature(KEY_CUSTOMER_DOMAIN, string);
    }

    public String getServerIpAddress() {
        return this.getFeature(KEY_SERVER_IP_ADDRESS);
    }

    public void setServerIpAddress(String string) {
        this.addFeature(KEY_SERVER_IP_ADDRESS, string);
    }

    public String getSerialKey() {
        return this.getFeature(KEY_SERIAL_KEY);
    }

    public void setSerialKey(String string) {
        this.addFeature(KEY_SERIAL_KEY, string);
    }

    public String getFeature(String string) {
        return (String)this.properties.get(string);
    }

    public void addFeature(String string, String string2) {
        this.checkFreeze();
        this.properties.put(string, string2);
    }

    public String removeFeature(String string) {
        this.checkFreeze();
        return (String)this.properties.remove(string);
    }

    public boolean isValidTime() {
        if (!this.frozen) {
            return false;
        }
        if (!this.initializedTime) {
            this.initializeTime();
            this.initializedTime = true;
        }
        if (this.isLimitByTime) {
            long l = this.getCurrentTime();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("isValidTime(): now=" + l + ", expireTime=" + this.expireTime));
            }
            return l >= this.activationTime && l < this.expireTime;
        }
        return true;
    }

    public boolean isFunctionSupported(String string, int n) {
        if (this.isValidTime()) {
            if (!this.initializedFunction) {
                this.initializeFunction();
                this.initializedFunction = true;
            }
            if (this.product.equals(string)) {
                if (this.function == 0) {
                    return true;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("isFunctionSupported(): function=" + Integer.toBinaryString(this.function) + ", functionCode=" + Integer.toBinaryString(n) + ", (function & functionCode)=" + Integer.toBinaryString(this.function & n)));
                }
                return (this.function & n) == n;
            }
        }
        return false;
    }

    public boolean isFunctionSupported(String string, BitSet bitSet) {
        int n = bitSet.size();
        if (n > 16) {
            n = 16;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            n2 += (int)Math.pow(2.0, i);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("isFunctionSupported(): functionBitSet=" + bitSet + ", functionCode=" + n2));
        }
        return this.isFunctionSupported(string, n2);
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isLimitByTime() {
        String string = this.getFeature(KEY_PRODUCT_LICENSE_TYPE);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("isLimitByTime(): licenseType=" + string));
        }
        return this.isLimitByMonth(string) || this.isLimitByYear(string);
    }

    public long getActivationTime() {
        String string = this.getFeature(KEY_DATE_ACTIVATION);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = simpleDateFormat.parse(string);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("getActivationTime(): date=" + date + ", dateStr=" + string));
            }
            return date.getTime();
        }
        catch (ParseException parseException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not parse date", (Throwable)parseException);
            }
            return defaultActivationTime;
        }
    }

    public long getExpireTime() {
        return this.getExpireTime(this.getActivationTime());
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private void initializeTime() {
        this.isLimitByTime = this.isLimitByTime();
        this.activationTime = this.getActivationTime();
        this.expireTime = this.getExpireTime(this.activationTime);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("initializeTime(): isLimitByTime=" + this.isLimitByTime + ", activationTime=" + new Date(this.activationTime) + ", expireTime=" + new Date(this.expireTime)));
        }
    }

    private boolean isLimitByMonth(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("TimeByMonth") != -1;
    }

    private boolean isLimitByYear(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("TimeByYear") != -1;
    }

    private long getExpireTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        String string = this.getFeature(KEY_DATE_TERM);
        try {
            int n = Integer.parseInt(string);
            String string2 = this.getFeature(KEY_PRODUCT_LICENSE_TYPE);
            if (this.isLimitByMonth(string2)) {
                calendar.add(2, n);
            } else {
                calendar.add(1, n);
            }
            return calendar.getTime().getTime();
        }
        catch (NumberFormatException numberFormatException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not parse int", (Throwable)numberFormatException);
            }
            return defaultExpiredTime;
        }
    }

    private void initializeFunction() {
        this.product = this.getProduct();
        this.function = this.getFunction();
    }

    private String getProduct() {
        return this.getFeature(KEY_PRODUCT_NAME);
    }

    private int getFunction() {
        String string = this.getFeature(KEY_PRODUCT_FUNCTION_BINARY);
        int n = Integer.parseInt(string, 2);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getFunction(): function=" + Integer.toBinaryString(n) + ", functionStr=" + string));
        }
        return n;
    }

    private void checkFreeze() {
        if (this.frozen) {
            throw new IllegalStateException("License is frozen");
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2999, 11, 31, 23, 59, 59);
        defaultActivationTime = calendar.getTime().getTime();
        calendar.set(1970, 0, 1, 0, 0, 0);
        defaultExpiredTime = calendar.getTime().getTime();
    }
}

