/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.PartDataSerializer;
import com.nexacro.xapi.tx.impl.MiBinaryDataDeserializer;
import com.nexacro.xapi.tx.impl.MiBinaryDataSerializer;
import com.nexacro.xapi.tx.impl.MiXmlDataDeserializer;
import com.nexacro.xapi.tx.impl.MiXmlDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformBinaryDataDeserializer;
import com.nexacro.xapi.tx.impl.PlatformBinaryDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformBinaryPartDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformHtmlDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformSsvDataDeserializer;
import com.nexacro.xapi.tx.impl.PlatformSsvDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformSsvExtDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformSsvPartDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformXmlDataDeserializer;
import com.nexacro.xapi.tx.impl.PlatformXmlDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformXmlPartDataSerializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSerializerFactory {
    private static final String SUFFIX_SERIALIZER = ".serializer";
    private static final String SUFFIX_PART_SERIALIZER = ".partserializer";
    private static final String SUFFIX_DESERIALIZER = ".deserializer";
    private static Map filters = new HashMap();

    public static DataSerializer getSerializer(String string) {
        block4: {
            Object v = filters.get(string + SUFFIX_SERIALIZER);
            if (v instanceof DataSerializer) {
                return (DataSerializer)v;
            }
            if (v instanceof Class) {
                try {
                    return (DataSerializer)((Class)v).newInstance();
                }
                catch (Throwable throwable) {
                    Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not create DataSerializer: type=" + string), throwable);
                }
            }
        }
        return null;
    }

    public static PartDataSerializer getPartSerializer(String string) {
        block4: {
            Object v = filters.get(string + SUFFIX_PART_SERIALIZER);
            if (v instanceof PartDataSerializer) {
                return (PartDataSerializer)v;
            }
            if (v instanceof Class) {
                try {
                    return (PartDataSerializer)((Class)v).newInstance();
                }
                catch (Throwable throwable) {
                    Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not create PartDataSerializer: type=" + string), throwable);
                }
            }
        }
        return null;
    }

    public static DataDeserializer getDeserializer(String string) {
        block4: {
            Object v = filters.get(string + SUFFIX_DESERIALIZER);
            if (v instanceof DataDeserializer) {
                return (DataDeserializer)v;
            }
            if (v instanceof Class) {
                try {
                    return (DataDeserializer)((Class)v).newInstance();
                }
                catch (Throwable throwable) {
                    Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not create DataDeserializer: type=" + string), throwable);
                }
            }
        }
        return null;
    }

    public static void registerSerializer(String string, Object object) {
        block12: {
            DataSerializerFactory.checkType(string);
            Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
            String string2 = string.trim();
            if (object instanceof DataSerializer) {
                filters.put(string2 + SUFFIX_SERIALIZER, object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register DataSerializer: type=" + string + ", serializer=" + object));
                }
            } else {
                if (object instanceof Class) {
                    try {
                        Object t = ((Class)object).newInstance();
                        if (t instanceof DataSerializer) {
                            filters.put(string2 + SUFFIX_SERIALIZER, object);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Register DataSerializer: type=" + string + ", serializer=" + object));
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Could not register DataSerializer: type=" + string + ", serializer=" + object));
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not register DataSerializer: type=" + string + ", serializer=" + object), throwable);
                        }
                        break block12;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not register DataSerializer: type=" + string + ", serializer=" + object));
                }
            }
        }
    }

    public static void registerPartSerializer(String string, Object object) {
        block12: {
            DataSerializerFactory.checkType(string);
            Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
            String string2 = string.trim();
            if (object instanceof PartDataSerializer) {
                filters.put(string2 + SUFFIX_PART_SERIALIZER, object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register PartDataSerializer: type=" + string + ", serializer=" + object));
                }
            } else {
                if (object instanceof Class) {
                    try {
                        Object t = ((Class)object).newInstance();
                        if (t instanceof PartDataSerializer) {
                            filters.put(string2 + SUFFIX_PART_SERIALIZER, object);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Register PartDataSerializer: type=" + string + ", serializer=" + object));
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Could not register PartDataSerializer: type=" + string + ", serializer=" + object));
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not register PartDataSerializer: type=" + string + ", serializer=" + object), throwable);
                        }
                        break block12;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not register PartDataSerializer: type=" + string + ", serializer=" + object));
                }
            }
        }
    }

    public static void registerDeserializer(String string, Object object) {
        block12: {
            DataSerializerFactory.checkType(string);
            Log log = LogFactory.getLog((Class)DataSerializerFactory.class);
            String string2 = string.trim();
            if (object instanceof DataDeserializer) {
                filters.put(string2 + SUFFIX_DESERIALIZER, object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register DataDeserializer: type=" + string + ", deserializer=" + object));
                }
            } else {
                if (object instanceof Class) {
                    try {
                        Object t = ((Class)object).newInstance();
                        if (t instanceof DataDeserializer) {
                            filters.put(string2 + SUFFIX_DESERIALIZER, object);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Register DataDeserializer: type=" + string + ", deserializer=" + object));
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Could not register DataDeserializer: type=" + string + ", deserializer=" + object));
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not register DataDeserializer: type=" + string + ", deserializer=" + object), throwable);
                        }
                        break block12;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not register DataDeserializer: type=" + string + ", deserializer=" + object));
                }
            }
        }
    }

    private static void initSerializers(Map map) {
        map.put("PlatformXml.serializer", PlatformXmlDataSerializer.class);
        map.put("PlatformBinary.serializer", PlatformBinaryDataSerializer.class);
        map.put("PlatformSsv.serializer", PlatformSsvDataSerializer.class);
        map.put("MiXml.serializer", MiXmlDataSerializer.class);
        map.put("MiBinary.serializer", MiBinaryDataSerializer.class);
        map.put("PlatformHtml.serializer", new PlatformHtmlDataSerializer());
        map.put("PlatformSsvExt.serializer", PlatformSsvExtDataSerializer.class);
    }

    private static void initPartSerializers(Map map) {
        map.put("PlatformXml.partserializer", PlatformXmlPartDataSerializer.class);
        map.put("PlatformBinary.partserializer", PlatformBinaryPartDataSerializer.class);
        map.put("PlatformSsv.partserializer", PlatformSsvPartDataSerializer.class);
    }

    private static void initDeserializers(Map map) {
        map.put("PlatformXml.deserializer", PlatformXmlDataDeserializer.class);
        map.put("PlatformBinary.deserializer", PlatformBinaryDataDeserializer.class);
        map.put("PlatformSsv.deserializer", PlatformSsvDataDeserializer.class);
        map.put("MiXml.deserializer", MiXmlDataDeserializer.class);
        map.put("MiBinary.deserializer", MiBinaryDataDeserializer.class);
    }

    private static void checkType(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("No type specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid type: \"" + string + "\"");
        }
    }

    private DataSerializerFactory() {
    }

    static {
        DataSerializerFactory.initSerializers(filters);
        DataSerializerFactory.initPartSerializers(filters);
        DataSerializerFactory.initDeserializers(filters);
    }
}

