/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformUtils;
import com.nexacro.xapi.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpPlatformRequest
extends PlatformRequest {
    private Log log = LogFactory.getLog((Class)HttpPlatformRequest.class);
    private static final String REGISTER_GET_PARAMETER = "http.getparameter.register";
    private static final String GET_PARAMETER_AS_VARIABLE = "http.getparameter.asvariable";
    private HttpServletRequest httpReq;

    public HttpPlatformRequest(InputStream inputStream) {
        super(inputStream);
    }

    public HttpPlatformRequest(InputStream inputStream, String string) {
        super(inputStream, string);
    }

    public HttpPlatformRequest(InputStream inputStream, String string, String string2) {
        super(inputStream, string, string2);
    }

    public HttpPlatformRequest(Reader reader) {
        super(reader);
    }

    public HttpPlatformRequest(Reader reader, String string) {
        super(reader, string);
    }

    public HttpPlatformRequest(Reader reader, String string, String string2) {
        super(reader, string, string2);
    }

    public HttpPlatformRequest(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, null, null);
    }

    public HttpPlatformRequest(HttpServletRequest httpServletRequest, String string) {
        this(httpServletRequest, string, null);
    }

    public HttpPlatformRequest(HttpServletRequest httpServletRequest, String string, String string2) {
        super(string, string2);
        this.httpReq = httpServletRequest;
        this.setCheckLicense(!this.isLocalRequest(httpServletRequest));
    }

    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    public void receiveData() throws PlatformException {
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Receiving data from HTTP: " + this.toSimpleString()));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Receiving data from HTTP: " + this.toSimpleString()));
        }
        if (this.httpReq == null) {
            super.receiveData();
            return;
        }
        int n = this.httpReq.getContentLength();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Receiving data: contentLength=" + n));
        }
        try {
            this.findContentTypeAndCharset(this.httpReq);
            String string = this.getCurrentCharset();
            boolean bl = this.isHttpPost(this.httpReq);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Checking HTTP POST: isHttpPost=" + bl));
            }
            if (bl) {
                this.setData(this.createEmptyData());
                this.parseHttpParametersToDataSet(this.httpReq);
            } else {
                if (n > 0) {
                    this.readFrom(this.httpReq);
                } else {
                    this.setData(this.createEmptyData());
                }
                if (this.isRegisterGetParameter()) {
                    if (this.isRegisterGetParameterAsVariable()) {
                        this.parseHttpParametersToVariables(this.httpReq);
                    } else {
                        this.parseHttpParametersToDataSet(this.httpReq);
                    }
                }
            }
        }
        catch (PlatformException platformException) {
            throw platformException;
        }
        catch (Throwable throwable) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Receiving data failed", throwable);
            }
            throw new PlatformException("Receiving data failed", throwable);
        }
    }

    void readFrom(HttpServletRequest httpServletRequest) throws PlatformException {
        try {
            this.setInputStream((InputStream)httpServletRequest.getInputStream());
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not get HTTP InputStream", (Throwable)iOException);
            }
            throw new PlatformException("Could not get HTTP InputStream", iOException);
        }
        super.receiveData();
    }

    void parseHttpParametersToDataSet(HttpServletRequest httpServletRequest) {
        Enumeration enumeration;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Parsing HTTP Parameters: " + this));
        }
        if (this.getData() == null) {
            this.setData(this.createEmptyData());
        }
        if ((enumeration = httpServletRequest.getParameterNames()).hasMoreElements()) {
            DataSet dataSet = new DataSet("httpData");
            DataSet dataSet2 = new DataSet("httpDataCount");
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                dataSet.addColumn(string, 2, 256);
                dataSet2.addColumn(string, 3, 4);
            }
            dataSet2.newRow();
            int n = dataSet.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string = dataSet.getColumn(i).getName();
                String[] stringArray = httpServletRequest.getParameterValues(string);
                if (stringArray == null || stringArray.length == 0) {
                    dataSet2.set(0, string, 0);
                    continue;
                }
                int n3 = stringArray.length;
                dataSet2.set(0, string, n3);
                int n4 = n3 - dataSet.getRowCount();
                if (n4 > 0) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        dataSet.newRow();
                    }
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    dataSet.set(n2, string, stringArray[n2]);
                }
            }
            this.getData().addDataSet(dataSet);
            this.getData().addDataSet(dataSet2);
        }
    }

    void parseHttpParametersToVariables(HttpServletRequest httpServletRequest) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Parsing HTTP Parameters: " + this));
        }
        if (this.getData() == null) {
            this.setData(this.createEmptyData());
        }
        VariableList variableList = this.getData().getVariableList();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = httpServletRequest.getParameter(string);
                variableList.add(string, string2);
            }
        }
    }

    private void findContentTypeAndCharset(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = httpServletRequest.getContentType();
        String string3 = httpServletRequest.getHeader("Content-Encoding");
        String string4 = httpServletRequest.getHeader("User-Agent");
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reading data: httpContentType=" + (string2 != null ? URLEncoder.encode(string2, "UTF-8") : null) + ", httpContentEncoding=" + (string3 != null ? URLEncoder.encode(string3, "UTF-8") : null) + ", userAgent=" + (string4 != null ? URLEncoder.encode(string4, "UTF-8") : null)));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string5 = this.getContentType();
        if (string5 == null) {
            string5 = this.findContentType(string2, string4);
        }
        if ((string = this.getCharset()) == null) {
            string = this.findCharset(string2);
        }
        this.setContentType(string5);
        this.setCharset(string);
    }

    String findContentType(String string, String string2) {
        String string3;
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        int n = string.indexOf(59);
        String string4 = string3 = n == -1 ? string : string.substring(0, n);
        if ("text/xml".equals(string3)) {
            if (this.isMiPlatform(string2)) {
                return "MiXml";
            }
            return "PlatformXml";
        }
        if ("application/octet-stream".equals(string3)) {
            if (this.isMiPlatform(string2)) {
                return "MiBinary";
            }
            return "PlatformBinary";
        }
        if ("text/html".equals(string3)) {
            return "PlatformHtml";
        }
        return null;
    }

    String findCharset(String string) {
        String[] stringArray = PlatformUtils.splitKeyAndValue(string, ';');
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = PlatformUtils.splitKeyAndValue(stringArray[1], '=');
        if (stringArray2 == null) {
            return null;
        }
        if ("charset".equals(stringArray2[0]) && !StringUtils.isEmpty(stringArray2[1])) {
            return stringArray2[1];
        }
        return null;
    }

    private boolean isMiPlatform(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("MiPlatform");
    }

    private boolean isHttpPost(HttpServletRequest httpServletRequest) {
        return "application/x-www-form-urlencoded".equals(httpServletRequest.getContentType());
    }

    private boolean isLocalRequest(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getServerName();
        return "localhost".equals(string) || "127.0.0.1".equals(string);
    }

    private boolean isRegisterGetParameter() {
        return "true".equals(this.getProperty(REGISTER_GET_PARAMETER));
    }

    private boolean isRegisterGetParameterAsVariable() {
        return "true".equals(this.getProperty(GET_PARAMETER_AS_VARIABLE));
    }

    private PlatformData createEmptyData() {
        return new PlatformData();
    }
}

