/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.JavaTypeDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformBinaryJavaTypeDataSerializer;
import com.nexacro.xapi.tx.impl.PlatformXmlJavaTypeDataSerializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaTypeDataSerializerFactory {
    private static final String SUFFIX_SERIALIZER = ".serializer";
    private static Map filters = new HashMap();

    public static JavaTypeDataSerializer getSerializer(String string) {
        block4: {
            Object v = filters.get(string + SUFFIX_SERIALIZER);
            if (v instanceof JavaTypeDataSerializer) {
                return (JavaTypeDataSerializer)v;
            }
            if (v instanceof Class) {
                try {
                    return (JavaTypeDataSerializer)((Class)v).newInstance();
                }
                catch (Throwable throwable) {
                    Log log = LogFactory.getLog((Class)JavaTypeDataSerializerFactory.class);
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not create JavaTypeDataSerializer: type=" + string), throwable);
                }
            }
        }
        return null;
    }

    public static void registerSerializer(String string, Object object) {
        block12: {
            JavaTypeDataSerializerFactory.checkType(string);
            Log log = LogFactory.getLog((Class)JavaTypeDataSerializerFactory.class);
            String string2 = string.trim();
            if (object instanceof JavaTypeDataSerializer) {
                filters.put(string2 + SUFFIX_SERIALIZER, object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register JavaTypeDataSerializer: type=" + string + ", serializer=" + object));
                }
            } else {
                if (object instanceof Class) {
                    try {
                        Object t = ((Class)object).newInstance();
                        if (t instanceof JavaTypeDataSerializer) {
                            filters.put(string2 + SUFFIX_SERIALIZER, object);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Register JavaTypeDataSerializer: type=" + string + ", serializer=" + object));
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Could not register JavaTypeDataSerializer: type=" + string + ", serializer=" + object));
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not register JavaTypeDataSerializer: type=" + string + ", serializer=" + object), throwable);
                        }
                        break block12;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not register JavaTypeDataSerializer: type=" + string + ", serializer=" + object));
                }
            }
        }
    }

    private static void initSerializers(Map map) {
        map.put("PlatformXml.serializer", PlatformXmlJavaTypeDataSerializer.class);
        map.put("PlatformBinary.serializer", PlatformBinaryJavaTypeDataSerializer.class);
    }

    private static void checkType(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("No type specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid type: \"" + string + "\"");
        }
    }

    private JavaTypeDataSerializerFactory() {
    }

    static {
        JavaTypeDataSerializerFactory.initSerializers(filters);
    }
}

